---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：16-INotificationHandler<TRequest>

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **大きなドキュメント処理のメモリ考慮事項**：ソースコードに明示的な記載なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs` 22-30行目
- E-02: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs` 27-28行目
- E-03: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs` 29行目
- E-04: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializedHandler.cs` 15行目
- E-05: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializedHandler.cs` 21行目
- E-06: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/MethodHandlerDetails.cs` 80-84行目
- E-07: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/QueueItem.cs` 202-208行目
- E-08: `src/LanguageServer/Protocol/Handler/ILspServiceNotificationHandler.cs` 16-21行目
- E-09: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/QueueItem.cs` 113-155行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotificationHandler<TRequest, TRequestContext>はIMethodHandlerを継承 | E-02 | ○ |
| C-02 | HandleNotificationAsyncメソッドが(TRequest, TRequestContext, CancellationToken)を受け取る | E-03 | ○ |
| C-03 | TRequestはリクエストパラメータの型を表す | E-01（XMLドキュメント） | ○ |
| C-04 | TRequestContextはリクエストコンテキストの型を表す | E-01（XMLドキュメント） | ○ |
| C-05 | InitializedHandlerが実装例として存在 | E-04 | ○ |
| C-06 | HandleNotificationAsyncの実装 | E-05 | ○ |
| C-07 | MethodHandlerDetailsでINotificationHandler<,>を検出 | E-06 | ○ |
| C-08 | genericArguments[0]がRequestType | E-06（82行目） | ○ |
| C-09 | genericArguments[1]がRequestContextType | E-06（83行目） | ○ |
| C-10 | QueueItem.StartRequestAsyncで通知処理 | E-07 | ○ |
| C-11 | NoValue.Instanceが返却される | E-07 | ○ |
| C-12 | ILspServiceNotificationHandler<TRequest>がRoslyn拡張 | E-08 | ○ |
| C-13 | TryDeserializeRequestでparamsをデシリアライズ | E-09 | ○ |
| C-14 | デシリアライズ失敗時は処理中断 | E-09（145-154行目） | ○ |
| C-15 | JSON-RPC 2.0プロトコルを使用 | LSP仕様 | ○ |
| C-16 | 一方向通知でレスポンスなし | E-01（XMLドキュメント） | ○ |
| C-17 | 大きなドキュメント処理はメモリ使用量に注意 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-17: メモリ使用量の考慮事項**
  - パフォーマンスに関するベストプラクティスとして記載したが、ソースコード内に明示的な記載なし
  - 候補：パフォーマンスガイドライン / アーキテクチャドキュメント / メモリプロファイリング結果

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 技術的な記述はソースコードで確認可能
- 1: 中リスク - パフォーマンス考慮事項は一般的なベストプラクティスに基づく

## 6) レビュアーチェックリスト（最小）

- [ ] INotificationHandler<TRequest, TRequestContext>実装の動作をデバッグで確認
- [ ] TryDeserializeRequestのエラーハンドリングを確認
- [ ] 具体的なTRequest型の実装例（DidOpenTextDocumentParams等）を確認
- [ ] C-17のメモリ使用量について、実際の運用データと照合
