---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：17-OmniSharpSendNotification

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **具体的な送信トリガーシナリオ**：実装コードで直接確認できず

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` 15-18行目
- E-02: `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` 9-14行目
- E-03: `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` 12行目
- E-04: `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` 13行目
- E-05: `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` 14行目
- E-06: `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` 9-14行目
- E-07: `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` 11行目
- E-08: `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` 12行目
- E-09: `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` 13行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SendNotificationメソッドがIOmniSharpNotificationServiceで定義 | E-01 | ○ |
| C-02 | messageパラメータは必須 | E-01 | ○ |
| C-03 | titleパラメータはnull許容 | E-04 | ○ |
| C-04 | severityのデフォルト値はWarning | E-05 | ○ |
| C-05 | メッセージボックスにOKボタンが表示される | E-02（XMLドキュメント） | ○ |
| C-06 | OmniSharpNotificationSeverityがNotificationSeverityにマッピング | E-06 | ○ |
| C-07 | Information重大度のマッピング | E-07 | ○ |
| C-08 | Warning重大度のマッピング | E-08 | ○ |
| C-09 | Error重大度のマッピング | E-09 | ○ |
| C-10 | titleは一部実装で無視される可能性 | E-04（XMLドキュメント） | ○ |
| C-11 | 外部通信は発生しない | コード分析 | ○ |
| C-12 | 名前空間はMicrosoft.CodeAnalysis.ExternalAccess.OmniSharp.Notification | E-01（ファイルヘッダ） | ○ |
| C-13 | プロジェクト読み込みエラー等での使用シナリオ | **根拠なし** | △ |
| C-14 | voidを返す同期メソッド | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-13: 具体的な送信トリガーシナリオ**
  - プロジェクト読み込みエラー、リファクタリング前警告等は一般的なシナリオとして記載
  - 実際の呼び出し箇所はOmniSharpサーバー側の実装に依存
  - 候補：OmniSharpサーバーソースコード / OmniSharp統合テスト

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - インターフェース定義はソースコードで確認可能
- 1: 中リスク - 具体的な使用シナリオはOmniSharp側の実装に依存

## 6) レビュアーチェックリスト（最小）

- [ ] IOmniSharpNotificationService実装の存在を確認
- [ ] OmniSharpサーバーでの実際の使用箇所を確認
- [ ] VS Code等でのメッセージボックス表示動作を確認
- [ ] C-13の具体的なトリガーシナリオをOmniSharpドキュメントと照合
