---
generated_at: 2026-02-10 10:32:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：2-ConfirmMessageBox

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **レート制限の設定値**：コード上で制限なしと推測したが明示的な根拠なし
  2. **テスト時のコールバックがtrueを返す仕様**：EditorDialogServiceでは明示的だがVSDialogServiceでは確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Notification/INotificationService.cs` - インターフェース定義
- E-02: `src/VisualStudio/Core/Def/Notification/VSNotificationServiceFactory.cs` - VS環境実装
- E-03: `src/EditorFeatures/Core/Notification/EditorNotificationServiceFactory.cs` - エディタ環境実装
- E-04: `src/EditorFeatures/Core/ExtractMethod/ExtractMethodCommandHandler.cs` - 呼び出し元例
- E-05: `src/Features/Core/Portable/ChangeSignature/ChangeSignatureCodeActionOperation.cs` - 呼び出し元例
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotificationServiceインターフェースで定義されている | E-01 | ○ |
| C-02 | Yes/No形式の確認ダイアログを表示する | E-01 行24-34 | ○ |
| C-03 | ユーザーの選択結果（true/false）を返す | E-01 行30 | ○ |
| C-04 | Visual StudioではYESNOボタン付きで表示 | E-02 行103 (OLEMSGBUTTON.OLEMSGBUTTON_YESNO) | ○ |
| C-05 | WPFエディタではMessageBoxButton.YesNoを使用 | E-03 行80 | ○ |
| C-06 | dialogResult == 6 がYesクリックを示す | E-02 行110 | ○ |
| C-07 | テスト時にコールバックが呼ばれtrueを返す | E-03 行70-76 | ○ |
| C-08 | UIモードをモーダル/非モーダルに切り替える | E-02 行92, 115 | ○ |
| C-09 | SeverityをOLEMSGICONにマッピングする（VS環境） | E-02 行95, 119-137 | ○ |
| C-10 | 同期的に送信される（応答を待機） | E-01, E-02, E-03 戻り値bool | ○ |
| C-11 | ExtractMethod時に使用される | E-04 | ○ |
| C-12 | ChangeSignature操作時に使用される | E-05 | ○ |
| C-13 | finallyブロックでモーダル状態を解除する | E-02 行112-116 | ○ |
| C-14 | titleパラメータはオプション | E-01 行28 (= null) | ○ |
| C-15 | severityのデフォルトはWarning | E-01 行29 | ○ |
| C-16 | レート制限は設定されていない | **根拠なし** | △ |
| C-17 | VSDialogServiceでのテストコールバック動作 | **根拠なし**（コード未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- レート制限に関するコード上の明示的な設定がないため、「制限なし」と推測した
  - 候補：設計ドキュメント / 要件定義書 / コメント内の記述
- VSDialogServiceでのConfirmMessageBoxテストコールバック時の動作が未確認
  - 候補：VSNotificationServiceFactory.csの詳細確認 / テストコード確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義とソースコードから確認可能な主張が大半
- 1: 中リスク - テスト時のコールバック動作に関する詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] INotificationServiceインターフェースのConfirmMessageBox定義が最新のコードと一致しているか
- [ ] dialogResult == 6 がYesを示すことがMSDNドキュメントと一致しているか
- [ ] テスト環境でのコールバック動作がVSDialogServiceとEditorDialogServiceで一貫しているか
- [ ] 記載されたトリガー（ExtractMethod等）が網羅的か
