---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-ShowToastNotification

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **クライアント側でのコマンド実行制限**：セキュリティ考慮事項として記載したが実装上の制限は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Logging/ShowToastNotification.cs` - トースト通知クラス
- E-02: `src/LanguageServer/Protocol/IClientLanguageServerManager.cs` - LSPマネージャインターフェース
- E-03: `src/LanguageServer/Protocol/Handler/LanguageServerNotificationManager.cs` - 通知マネージャ実装
- E-04: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/ProjectInitializationHandler.cs` - 呼び出し元例
- E-05: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/ProjectTelemetry/ProjectLoadTelemetryReporter.cs` - 呼び出し元例
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | window/_roslyn_showToastというカスタムLSPメソッド名 | E-01 行19 | ○ |
| C-02 | 非同期で送信される（Fire-and-forget） | E-01 行27, E-02 行21 (ValueTask) | ○ |
| C-03 | ShowToastNotificationParamsはrecord型 | E-01 行35-38 | ○ |
| C-04 | messageType, message, commandsの3パラメータ | E-01 行35-38 | ○ |
| C-05 | JsonPropertyName属性でJSONプロパティ名を指定 | E-01 行36-38 | ○ |
| C-06 | ShowCSharpLogsCommandが定義済み | E-01 行21-25 | ○ |
| C-07 | csharp.showOutputWindowコマンド識別子 | E-01 行24 | ○ |
| C-08 | LanguageServerHost.Instanceのnullチェック | E-01 行29 | ○ |
| C-09 | IClientLanguageServerManagerを使用 | E-01 行30 | ○ |
| C-10 | SendNotificationAsyncで送信 | E-01 行32 | ○ |
| C-11 | JsonRpc.NotifyWithParameterObjectAsyncを使用 | E-03 行38-39 | ○ |
| C-12 | 標準window/showMessageRequestとは異なる | E-01 行12-16 コメント | ○ |
| C-13 | レスポンス待機が不要 | E-01 行13-14 コメント | ○ |
| C-14 | コマンドボタンにマッピング可能 | E-01 行15-16 コメント | ○ |
| C-15 | CancellationTokenをサポート | E-01 行27 | ○ |
| C-16 | クライアント側でのコマンド実行制限 | **根拠なし**（推奨事項として記載） | △ |

## 4) 不足情報（Unknown / Missing）
- クライアント側でのコマンド実行に関するセキュリティ制限の実装有無
  - 候補：クライアント側コード（VS Code拡張） / LSPクライアント仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる主張が大半
- 0: 低リスク - LSPプロトコルの実装詳細が明確

## 6) レビュアーチェックリスト（最小）
- [ ] ShowToastNotificationクラスの定義が最新のコードと一致しているか
- [ ] window/_roslyn_showToastメソッド名がクライアント側実装と一致しているか
- [ ] ShowCSharpLogsCommandのコマンド識別子がVS Code拡張で定義されているか
- [ ] 記載されたトリガー（ProjectInitialization等）が網羅的か
