---
generated_at: 2026-02-10 10:38:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：4-SendNotificationAsync

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **レート制限の設定**：呼び出し元の判断に委ねると記載したが、実装上の制限有無は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/LanguageServer/Protocol/IClientLanguageServerManager.cs` - インターフェース定義
- E-02: `src/LanguageServer/Protocol/Handler/LanguageServerNotificationManager.cs` - 実装クラス
- E-03: `src/LanguageServer/Protocol/Handler/SourceGenerators/SourceGeneratorRefreshQueue.cs` - 呼び出し元例
- E-04: `src/LanguageServer/Protocol/Handler/WorkDoneProgress/WorkDoneProgressManager.cs` - 呼び出し元例
- E-05: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Logging/ShowToastNotification.cs` - 呼び出し元例
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IClientLanguageServerManagerインターフェースで定義 | E-01 | ○ |
| C-02 | パラメータなし通知のオーバーロードが存在 | E-01 行20 | ○ |
| C-03 | パラメータ付き通知のオーバーロードが存在 | E-01 行21 | ○ |
| C-04 | ValueTaskを返す | E-01 行20-21 | ○ |
| C-05 | ILspServiceを継承 | E-01 行15 | ○ |
| C-06 | ClientLanguageServerManagerが実装を提供 | E-02 | ○ |
| C-07 | JsonRpcをコンストラクタで受け取る | E-02 行16-24 | ○ |
| C-08 | NotifyWithParameterObjectAsyncを使用 | E-02 行36, 39 | ○ |
| C-09 | ソースジェネレータリフレッシュで使用 | E-03 | ○ |
| C-10 | ワークプログレス通知で使用 | E-04 | ○ |
| C-11 | トースト通知で使用 | E-05 | ○ |
| C-12 | CancellationTokenをサポート | E-01 行20-21 | ○ |
| C-13 | JSON-RPC 2.0プロトコルに準拠 | E-02 StreamJsonRpc使用 | ○ |
| C-14 | 任意のメソッド名を指定可能 | E-01 行20-21 string methodName | ○ |
| C-15 | レート制限なし | **根拠なし**（コード上で確認できず） | △ |

## 4) 不足情報（Unknown / Missing）
- レート制限に関する実装上の制限や推奨事項の記載がない
  - 候補：設計ドキュメント / StreamJsonRpcドキュメント / パフォーマンスガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェースと実装クラスから直接確認できる主張が大半
- 0: 低リスク - StreamJsonRpcライブラリの使用が明確

## 6) レビュアーチェックリスト（最小）
- [ ] IClientLanguageServerManagerインターフェースの定義が最新のコードと一致しているか
- [ ] ClientLanguageServerManagerの実装がインターフェースと整合しているか
- [ ] 記載された呼び出し元（SourceGeneratorRefreshQueue等）が網羅的か
- [ ] StreamJsonRpcライブラリのバージョンとAPIが正しいか
