---
generated_at: 2026-02-10 10:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-DidChangeConfiguration

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **.editorconfigファイル変更時のトリガー動作**：LSP標準の動作として記載したが、Roslyn固有の実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler.cs` - メインハンドラ
- E-02: `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler_OnInitialized.cs` - 初期化処理
- E-03: `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler_OptionList.cs` - オプションリスト
- E-04: `src/LanguageServer/Protocol/Protocol/DidChangeConfigurationParams.cs` - パラメータ型
- E-05: `src/LanguageServer/Protocol/Protocol/Methods.Workspace.cs` - メソッド名定義
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | workspace/didChangeConfigurationはLSP標準通知 | E-05 Methods.WorkspaceDidChangeConfigurationName | ○ |
| C-02 | DidChangeConfigurationNotificationHandlerが処理 | E-01 行23 | ○ |
| C-03 | ILspServiceNotificationHandlerを実装 | E-01 行23 | ○ |
| C-04 | IOnInitializedを実装 | E-01 行23 | ○ |
| C-05 | C#とVisual Basicをサポート | E-01 行42-46 SupportedLanguages | ○ |
| C-06 | csharpとvisual_basicプレフィックスを使用 | E-01 行42-44 s_languageNameToPrefix | ○ |
| C-07 | workspace/configurationリクエストで設定取得 | E-01 行120-131 GetConfigurationsAsync | ○ |
| C-08 | IGlobalOptionServiceで設定を更新 | E-01 行117 SetGlobalOptions | ○ |
| C-09 | IOnConfigurationChangedで変更を通知 | E-01 行70-74 | ○ |
| C-10 | HandleNotificationAsyncでRefreshOptionsAsyncを呼び出し | E-01 行66-68 | ○ |
| C-11 | パース失敗時に警告ログを出力 | E-01 行112 LogWarning | ○ |
| C-12 | workspace/configurationをサポートしない場合はスキップ | E-01 行79-83 | ○ |
| C-13 | GenerateFullNameForOptionでオプション名を生成 | E-01 行195-201 | ○ |
| C-14 | IPerLanguageValuedOptionの場合は言語ごとに設定 | E-01 行138-141 | ○ |
| C-15 | SupportedOptionsで対象オプションを定義 | E-03 | ○ |
| C-16 | MutatesSolutionStateはtrue | E-01 行62 | ○ |
| C-17 | RequiresLSPSolutionはfalse | E-01 行64 | ○ |
| C-18 | .editorconfigファイル変更時にトリガー | **根拠なし**（LSP標準動作として推測） | △ |

## 4) 不足情報（Unknown / Missing）
- .editorconfigファイル変更時のトリガー動作についてRoslyn固有の実装確認が必要
  - 候補：FileWatcherの実装 / クライアント側の動作仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - LSP標準仕様とソースコードから確認できる主張が大半
- 0: 低リスク - ハンドラの実装詳細が明確

## 6) レビュアーチェックリスト（最小）
- [ ] DidChangeConfigurationNotificationHandlerの実装が最新のコードと一致しているか
- [ ] SupportedOptionsのリストが最新のオプション定義と一致しているか
- [ ] 言語プレフィックス（csharp, visual_basic）がクライアント側実装と一致しているか
- [ ] workspace/configurationリクエストの形式がLSP仕様と一致しているか
