---
generated_at: 2026-02-10 10:46:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-GlobalOperationStarted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ビルド開始時のトリガー動作**：ビルドがグローバル操作として開始される具体的な実装箇所の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/ExternalAccess/UnitTesting/Notification/IGlobalOperationNotificationService.cs` - インターフェース定義
- E-02: `src/Features/Core/Portable/ExternalAccess/UnitTesting/Notification/AbstractGlobalOperationNotificationService.cs` - 抽象基底クラス
- E-03: `src/Features/Core/Portable/ExternalAccess/UnitTesting/Notification/AbstractGlobalOperationNotificationService.GlobalOperationRegistration.cs` - Registration実装
- E-04: `src/VisualStudio/Core/Def/ExternalAccess/UnitTesting/VisualStudioGlobalOperationNotificationService.cs` - VS環境実装
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IGlobalOperationNotificationServiceで定義 | E-01 | ○ |
| C-02 | Startedイベントが定義されている | E-01 行17-18 | ○ |
| C-03 | Stoppedイベントが定義されている | E-01 行22-23 | ○ |
| C-04 | Start()メソッドがIDisposableを返す | E-01 行28 | ○ |
| C-05 | AbstractGlobalOperationNotificationServiceが実装を提供 | E-02 | ○ |
| C-06 | 参照カウント方式で管理 | E-02 行71-75 | ○ |
| C-07 | AsyncBatchingWorkQueueを使用 | E-02 行23, 32-36 | ○ |
| C-08 | Count==1の場合のみイベント発火 | E-02 行71-75 | ○ |
| C-09 | ProcessEventsAsyncでイベントを発火 | E-02 行48-57 | ○ |
| C-10 | EventArgs.Emptyを送信 | E-02 行53 | ○ |
| C-11 | GlobalOperationRegistrationがIDisposable | E-03 行11 | ○ |
| C-12 | DisposeでDone()を呼び出し | E-03 行13-16 | ○ |
| C-13 | BulkFileOperation.Begin/Endにフック | E-04 行42-43 | ○ |
| C-14 | SolutionEventMonitorと連携 | E-04 行28 | ○ |
| C-15 | ファイナライザで検証（シャットダウン時スキップ） | E-02 行39-46 | ○ |
| C-16 | ビルド開始時にグローバル操作開始 | **根拠なし**（具体的な呼び出し元未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- ビルド開始時にIGlobalOperationNotificationService.Start()が呼び出される具体的な箇所
  - 候補：VisualStudio.Build関連コード / DTEイベントハンドラ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェースと実装から直接確認できる主張が大半
- 0: 低リスク - 参照カウント方式の実装が明確

## 6) レビュアーチェックリスト（最小）
- [ ] IGlobalOperationNotificationServiceの定義が最新のコードと一致しているか
- [ ] AbstractGlobalOperationNotificationServiceの参照カウント管理が正確か
- [ ] BulkFileOperation.Begin/Endのフックが正しく動作しているか
- [ ] Startedイベントのサブスクライバが網羅的に記載されているか
