---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-GlobalOperationStopped

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/ExternalAccess/UnitTesting/Notification/IGlobalOperationNotificationService.cs` - インターフェース定義
- E-02: `src/Features/Core/Portable/ExternalAccess/UnitTesting/Notification/AbstractGlobalOperationNotificationService.cs` - 抽象基底クラス
- E-03: `src/Features/Core/Portable/ExternalAccess/UnitTesting/Notification/AbstractGlobalOperationNotificationService.GlobalOperationRegistration.cs` - Registration実装
- E-04: `src/VisualStudio/Core/Def/ExternalAccess/UnitTesting/VisualStudioGlobalOperationNotificationService.cs` - VS環境実装
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IGlobalOperationNotificationServiceで定義 | E-01 | ○ |
| C-02 | Stoppedイベントが定義されている | E-01 行22-23 | ○ |
| C-03 | StartedイベントとペアでStartで動作 | E-01 行17-18, 22-23 | ○ |
| C-04 | DisposeでDone()を呼び出し | E-03 行13-16 | ○ |
| C-05 | Doneメソッドで参照カウント減算 | E-02 行81-94 | ○ |
| C-06 | Count==0の場合のみイベント発火 | E-02 行88-91 | ○ |
| C-07 | operations.Clear()が実行される | E-02 行90 | ○ |
| C-08 | EventQueueにfalseを追加 | E-02 行91 | ○ |
| C-09 | ProcessEventsAsyncでイベントを発火 | E-02 行48-57 | ○ |
| C-10 | valueがfalseの場合Stoppedイベント | E-02 行52 | ○ |
| C-11 | EventArgs.Emptyを送信 | E-02 行53 | ○ |
| C-12 | 二重Disposeで例外 | E-02 行85-86 Contract.ThrowIfFalse | ○ |
| C-13 | BulkFileOperation.EndでlocalRegistration?.Dispose() | E-04 行63-70 | ○ |
| C-14 | AsyncBatchingWorkQueueを使用 | E-02 行23, 32-36 | ○ |
| C-15 | サブスクライバがバックグラウンド処理を再開 | E-05（通知一覧の説明） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Stoppedイベントの定義が最新のコードと一致しているか
- [ ] Doneメソッドの参照カウント管理が正確か
- [ ] GlobalOperationRegistration.Disposeの動作が正しいか
- [ ] ProcessEventsAsyncのイベント発火ロジックが正確か
