---
generated_at: 2026-02-10 10:54:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：8-OnBeforeGlobalSymbolRenamed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **InlineRename完了時の具体的な呼び出し箇所**：ファイルは特定したが具体的な行番号の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Rename/IRefactorNotifyService.cs` - インターフェース定義
- E-02: `src/VisualStudio/Core/Def/Implementation/VsRefactorNotifyService.cs` - VS環境実装
- E-03: `src/EditorFeatures/Core/Shared/Extensions/IRefactorNotifyServiceExtensions.cs` - 拡張メソッド
- E-04: `src/EditorFeatures/Core/InlineRename/AbstractEditorInlineRenameService.SymbolRenameInfo.cs` - 呼び出し元
- E-05: `src/EditorFeatures/Core/RenameTracking/RenameTrackingTaggerProvider.RenameTrackingCommitter.cs` - 呼び出し元
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IRefactorNotifyServiceで定義 | E-01 | ○ |
| C-02 | TryOnBeforeGlobalSymbolRenamedメソッドが存在 | E-01 行22-23 | ○ |
| C-03 | 戻り値がboolで続行/キャンセルを制御 | E-01 行22 | ○ |
| C-04 | throwOnFailureパラメータをサポート | E-01 行23 | ○ |
| C-05 | VsRefactorNotifyServiceが実装を提供 | E-02 | ○ |
| C-06 | UIスレッドでの実行を要求 | E-02 行37 | ○ |
| C-07 | IVsHierarchyRefactorNotifyに委譲 | E-02 行44-65 | ○ |
| C-08 | HRESULTをチェックして例外処理 | E-02 行54-64 | ○ |
| C-09 | 拡張メソッドで一括通知 | E-03 行12-29 | ○ |
| C-10 | foreachで全サービスに通知 | E-03 行20-27 | ○ |
| C-11 | 1つでもfalseなら全体がfalse | E-03 行22-25 | ○ |
| C-12 | TryOnAfterGlobalSymbolRenamedとペア | E-01 行26-33 | ○ |
| C-13 | コンストラクタ/デストラクタは型に変換 | E-02 行160-161 | ○ |
| C-14 | RQName生成でシンボルを識別 | E-02 行158-164 | ○ |
| C-15 | changedDocumentIDsが空ならスキップ | E-02 行139-142 | ○ |
| C-16 | promptContinueOnFail: 1を渡す | E-02 行52 | ○ |
| C-17 | InlineRename完了時の具体的な呼び出し | **根拠なし**（ファイル特定済みだが詳細未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- InlineRename完了時の具体的な呼び出し箇所の行番号
  - 候補：AbstractEditorInlineRenameService.SymbolRenameInfo.cs の詳細読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェースと実装から直接確認できる主張が大半
- 0: 低リスク - Visual Studio COM相互運用の詳細が明確

## 6) レビュアーチェックリスト（最小）
- [ ] IRefactorNotifyServiceの定義が最新のコードと一致しているか
- [ ] VsRefactorNotifyServiceのHRESULT処理が正確か
- [ ] 拡張メソッドの一括通知ロジックが正しいか
- [ ] 記載された呼び出し元が網羅的か
