---
generated_at: 2026-02-10 10:58:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-OnAfterGlobalSymbolRenamed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Rename/IRefactorNotifyService.cs` - インターフェース定義
- E-02: `src/VisualStudio/Core/Def/Implementation/VsRefactorNotifyService.cs` - VS環境実装
- E-03: `src/EditorFeatures/Core/Shared/Extensions/IRefactorNotifyServiceExtensions.cs` - 拡張メソッド
- E-04: `src/VisualStudio/Core/Def/Workspace/VisualStudioSymbolRenamedCodeActionOperationFactoryWorkspaceService.cs` - 呼び出し元
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IRefactorNotifyServiceで定義 | E-01 | ○ |
| C-02 | TryOnAfterGlobalSymbolRenamedメソッドが存在 | E-01 行26-33 | ○ |
| C-03 | 戻り値がboolで成功/失敗を報告 | E-01 行33 | ○ |
| C-04 | throwOnFailureパラメータをサポート | E-01 行33 | ○ |
| C-05 | OnBeforeがtrueを返した場合のみ呼び出すべき | E-01 行26-28 コメント | ○ |
| C-06 | VsRefactorNotifyServiceが実装を提供 | E-02 | ○ |
| C-07 | OnGlobalSymbolRenamed（非OnAfter）を呼び出す | E-02 行83 | ○ |
| C-08 | UIスレッドでの実行を要求 | E-02 行74 | ○ |
| C-09 | IVsHierarchyRefactorNotifyに委譲 | E-02 行81-104 | ○ |
| C-10 | HRESULTをチェックして例外処理 | E-02 行89-99 | ○ |
| C-11 | 拡張メソッドで一括通知 | E-03 行31-49 | ○ |
| C-12 | foreachで全サービスに通知 | E-03 行37-46 | ○ |
| C-13 | 1つでもfalseなら全体がfalse | E-03 行39-43 | ○ |
| C-14 | TryOnBeforeGlobalSymbolRenamedとペア | E-01 行19-23, 26-33 | ○ |
| C-15 | ワークスペース変更はロールバックされない | E-01 行28 コメント「after...applied」 | ○ |
| C-16 | コードアクション操作で呼び出される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] TryOnAfterGlobalSymbolRenamedの定義が最新のコードと一致しているか
- [ ] VsRefactorNotifyServiceでOnGlobalSymbolRenamedを呼び出していることが正確か
- [ ] 拡張メソッドの一括通知ロジックがOnBeforeと対称であるか
- [ ] ワークスペース変更がロールバックされないことが設計意図と一致しているか
