---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **ホットキーの正確性**：Visual Studio標準のショートカットキーとの整合性確認が必要
  2. **サポート連絡先URL**：外部URLの有効性確認が必要
  3. **バージョン要件**：最新のVisual StudioおよびSDKバージョンとの整合性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能対応表
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-06: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件一覧
- E-07: `docs/code-to-docs/画面設計書/1-シグネチャ変更ダイアログ.md` - シグネチャ変更ダイアログ設計書
- E-08: `docs/code-to-docs/画面設計書/21-リネームフライアウト.md` - リネームフライアウト設計書
- E-09: `docs/code-to-docs/画面設計書/14-ドキュメントアウトラインビュー.md` - ドキュメントアウトライン設計書
- E-10: `docs/code-to-docs/画面設計書/34-C#詳細オプションページコントロール.md` - C#詳細オプション設計書
- E-11: `docs/code-to-docs/画面設計書/37-設定エディタコントロール.md` - EditorConfig設定エディタ設計書

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Roslynは.NETコンパイラプラットフォームである | E-01 | ○ |
| C-02 | C#およびVBコンパイラのリファレンス実装を提供 | E-01, E-03 | ○ |
| C-03 | Visual Studioの言語サービス基盤となっている | E-01 | ○ |
| C-04 | 静的コード分析機能を提供 | E-03, E-06 (BR-025) | ○ |
| C-05 | リファクタリング機能を提供（名前変更、シグネチャ変更等） | E-03, E-06 (BR-013, BR-015) | ○ |
| C-06 | コード補完（IntelliSense）を提供 | E-03, E-06 (BR-009) | ○ |
| C-07 | F2キーでリネームフライアウトが表示される | E-08 | ○ |
| C-08 | リネームでオーバーロード・コメント・文字列検索オプションがある | E-08 | ○ |
| C-09 | Enterで確定、Escapeでキャンセル | E-08 | ○ |
| C-10 | Copilot連携によるスマートリネームが可能 | E-08 | ○ |
| C-11 | シグネチャ変更ダイアログでパラメータの追加・削除・並べ替えが可能 | E-07 | ○ |
| C-12 | Alt+Up/Alt+Downでパラメータ移動 | E-07 | ○ |
| C-13 | プレビュー変更オプションがある | E-07 | ○ |
| C-14 | ドキュメントアウトラインでシンボル構造をツリー表示 | E-09 | ○ |
| C-15 | 名前順・位置順・種類順でソート可能 | E-09 | ○ |
| C-16 | 検索機能でフィルタリング可能 | E-09 | ○ |
| C-17 | カーソル位置と連動してツリー内のシンボルを自動選択 | E-09 | ○ |
| C-18 | 「表示」メニューからドキュメントアウトラインにアクセス | E-09 | ○ |
| C-19 | EditorConfig設定エディタで4つのタブがある | E-11 | ○ |
| C-20 | Whitespace、Code Style、Naming Style、Analyzersタブ | E-11 | ○ |
| C-21 | EditorConfigファイルに変更が自動反映される | E-11 | ○ |
| C-22 | C#詳細オプションでバックグラウンド分析スコープを設定 | E-10 | ○ |
| C-23 | 分析スコープはNone/Active File/Open Files/Full Solution | E-10 | ○ |
| C-24 | インラインヒントを有効/無効化可能 | E-10 | ○ |
| C-25 | 継承マージンを有効/無効化可能 | E-10 | ○ |
| C-26 | 命名スタイルダイアログでプレフィックス・サフィックスを設定 | E-04 (画面No 31) | ○ |
| C-27 | シンボル仕様ダイアログでアクセス修飾子を設定 | E-04 (画面No 32) | ○ |
| C-28 | 型生成ダイアログで新規クラス・インターフェースを生成 | E-02, E-07 | ○ |
| C-29 | クラス抽出ダイアログでメンバーを選択して抽出 | E-02, E-04 | ○ |
| C-30 | インターフェース抽出ダイアログでパブリックメンバーを選択 | E-02, E-04 | ○ |
| C-31 | 値追跡ツールウィンドウで変数の追跡結果を表示 | E-02 (画面No 15, 16), E-03 | ○ |
| C-32 | スタックトレースエクスプローラーでコードナビゲーション | E-02 (画面No 17, 18), E-03 | ○ |
| C-33 | 継承マージンコンテキストメニューで継承関係をナビゲート | E-02 (画面No 53), E-04 | ○ |
| C-34 | 定義へ移動（Go to Definition）機能がある | E-03, E-06 (BR-011) | ○ |
| C-35 | 参照の検索（Find All References）機能がある | E-03, E-06 (BR-012) | ○ |
| C-36 | Edit and Continue機能がある | E-03, E-06 (BR-045) | ○ |
| C-37 | メソッド抽出リファクタリングが可能 | E-03 | ○ |
| C-38 | コンストラクタ生成機能がある | E-03 | ○ |
| C-39 | インターフェース実装の自動生成機能がある | E-03, E-06 (BR-040) | ○ |
| C-40 | Equals/GetHashCode生成機能がある | E-03 | ○ |
| C-41 | 診断メッセージは赤（エラー）、緑（警告）、グレー（情報）で表示 | E-06 (BR-006) | ○ |
| C-42 | F12キーで定義へ移動 | **根拠なし** | △ |
| C-43 | Shift+F12キーで参照検索 | **根拠なし** | △ |
| C-44 | Visual Studio 2022 Previewが必要 | E-01 | ○ |
| C-45 | GitHubイシューでサポートを受けられる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **ショートカットキーの正確性**: F12、Shift+F12などのキーバインドはVisual Studioの標準機能であり、Roslyn固有のドキュメントには明記されていない
  - 候補：Visual Studio公式ドキュメント / キーボードショートカットリファレンス / ユーザー設定の確認
- **サポートURLの有効性**: GitHubリポジトリURLは時間とともに変更される可能性がある
  - 候補：公式サイトの確認 / リンクチェッカーでの検証

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: システム概要、機能一覧 - README.mdと機能一覧から直接引用
- 0（低リスク）: リファクタリング操作手順 - 画面設計書に詳細が記載
- 0（低リスク）: 設定画面の操作 - 画面設計書に詳細が記載
- 1（中リスク）: ショートカットキー - Visual Studio標準機能のため、カスタマイズにより異なる可能性
- 1（中リスク）: バージョン要件 - 時間経過により最新情報と乖離する可能性
- 0（低リスク）: トラブルシューティング - 画面設計書のメッセージ仕様から推定

## 6) レビュアーチェックリスト（最小）
- [ ] システム概要がREADME.mdの内容と一致しているか確認
- [ ] 各操作手順が画面設計書の記載と整合しているか確認
- [ ] ショートカットキーが実際のVisual Studioと一致するか実機確認
- [ ] EditorConfig設定の4タブ構成が正確か確認
- [ ] 診断メッセージの色分け（赤・緑・グレー）が正確か確認
- [ ] 外部URLが有効かリンクチェック
- [ ] バージョン要件が最新情報と一致しているか確認
- [ ] 命名規則の例（_camelCase、PascalCase等）が実際の推奨と一致するか確認
