# Roslyn (.NET Compiler Platform) 開発者向け業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [Visual Studioの起動とプロジェクト開始](#2-visual-studioの起動とプロジェクト開始)
3. [エディタの基本操作](#3-エディタの基本操作)

**【業務フローに沿った機能】**
4. [【STEP1】コード分析・診断機能（問題の検出）](#4-step1コード分析診断機能問題の検出)
5. [【STEP2-3】リファクタリング機能（コードの改善）](#5-step2-3リファクタリング機能コードの改善)
6. [【STEP3-4】コード生成・補完機能（コードの作成）](#6-step3-4コード生成補完機能コードの作成)
7. [【STEP4-5】設定・カスタマイズ機能（環境の最適化）](#7-step4-5設定カスタマイズ機能環境の最適化)

**【サポート機能】**
8. [ナビゲーション機能](#8-ナビゲーション機能)
9. [ツールウィンドウ](#9-ツールウィンドウ)
10. [デバッグ支援機能](#10-デバッグ支援機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Roslynとは

Roslyn（.NET Compiler Platform）は、Microsoftが開発するオープンソースの.NETコンパイラプラットフォームです。C#およびVisual Basicコンパイラのリファレンス実装であり、Visual Studioの言語サービス、IntelliSense、コードリファクタリング機能の基盤となっています。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **コード分析** | 静的コード分析、命名規則チェック、未使用コード検出 |
| **リファクタリング** | 名前変更、メソッド抽出、シグネチャ変更、クラス抽出 |
| **コード生成** | コンストラクタ生成、インターフェース実装、コード補完 |
| **コードナビゲーション** | 定義へ移動、参照検索、ドキュメントアウトライン |
| **設定管理** | EditorConfig編集、コードスタイル設定、命名規則設定 |

### 1.3 業務フロー概要

本システムにおける開発業務は、以下の流れで進行します：

```
+---------------------------------------------------------------------+
|                        開発業務フロー                                |
+---------------------------------------------------------------------+
|                                                                     |
|  【STEP 1】コード分析：問題や改善点を検出                            |
|      |                                                              |
|  【STEP 2】問題の確認：診断メッセージを確認、修正方法を検討          |
|      |                                                              |
|  【STEP 3】リファクタリング：コード修正・コード品質向上              |
|      |                                                              |
|  【STEP 4】コード生成・補完：新規コードの作成を支援                  |
|      |                                                              |
|  【STEP 5】設定最適化：コードスタイル・分析ルールをカスタマイズ      |
|                                                                     |
+---------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **開発者** | コーディング、リファクタリング、コード補完の利用、診断への対応 |
| **チームリーダー** | EditorConfig設定、命名規則の策定、コードスタイルの標準化 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| コード分析 | コード品質問題を静的に検出 | STEP 1 |
| 診断メッセージ | エラー・警告・情報メッセージの生成 | STEP 1-2 |
| クイックアクション | 診断に対する自動修正の提案 | STEP 2-3 |
| リファクタリング | コード構造を改善する変換操作 | STEP 3 |
| コード補完 | IntelliSenseによる入力支援 | STEP 4 |
| コード生成 | コンストラクタ・メソッド等の自動生成 | STEP 4 |
| EditorConfig設定 | コードスタイル・分析ルールの設定 | STEP 5 |
| ナビゲーション | 定義へ移動、参照検索 | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 開発者 | C#/Visual Basicでのコーディングを行う一般ユーザー |
| チームリーダー | コードスタイル・命名規則の設定を管理するユーザー |
| 拡張機能開発者 | カスタムアナライザーやコードフィックスを開発するユーザー |

### 1.6 対応環境

**必要環境：**
- Visual Studio 2022 Preview（拡張機能開発ワークロード含む）
- .NET SDK 10.0.102以上
- .NET Framework 4.7.2以上（Windows）

**推奨ブラウザ（ドキュメント閲覧用）：**
- Microsoft Edge（最新版）
- Google Chrome（最新版）

---

## 2. Visual Studioの起動とプロジェクト開始

### 2.1 Visual Studioの起動

1. Windowsのスタートメニューから「Visual Studio 2022」を選択します
2. Visual Studioが起動し、スタートウィンドウが表示されます
3. 「プロジェクトやソリューションを開く」または「リポジトリをクローン」を選択します

### 2.2 Roslynソリューションの開き方

1. ファイルメニューから「開く」>「プロジェクト/ソリューション」を選択します
2. `Roslyn.slnx`ファイルを選択して「開く」をクリックします
3. ソリューションの読み込みが完了するまで待機します

### 2.3 ビルドの実行

1. メニューから「ビルド」>「ソリューションのビルド」を選択します（またはCtrl+Shift+B）
2. 出力ウィンドウでビルドの進行状況を確認します
3. ビルドが成功すると「ビルド: 正常終了」と表示されます

---

## 3. エディタの基本操作

### 3.1 ファイルを開く

1. ソリューションエクスプローラーで対象のファイルをダブルクリックします
2. または「Ctrl+O」でファイルを開くダイアログを表示します

### 3.2 コード補完（IntelliSense）

1. コード入力中に自動的に補完候補が表示されます
2. 「Ctrl+Space」で明示的に補完候補を表示できます
3. 候補を選択して「Tab」または「Enter」で確定します

**入力例：**
- クラス名を入力すると、使用可能なメソッドやプロパティが表示されます
- 変数名の途中まで入力すると、一致する候補が絞り込まれます

### 3.3 クイック情報（ホバー）

1. シンボル（変数名、メソッド名など）上にマウスカーソルを置きます
2. 型情報、ドキュメントコメント、パラメータ情報が表示されます

---

## 4. 【STEP1】コード分析・診断機能（問題の検出）

> **業務フローでの位置**: コードの問題点や改善箇所を自動的に検出し、開発者に通知するステップです。

### 4.1 診断メッセージの確認

エディタ上に表示される診断メッセージを確認する手順：

1. コードに問題がある箇所は、波線（赤：エラー、緑：警告、グレー：情報）で示されます
2. 波線にマウスカーソルを合わせると、問題の詳細が表示されます
3. エラー一覧ウィンドウ（「表示」>「エラー一覧」）で全ての診断を確認できます

**診断の種類：**

| 種類 | 表示 | 説明 |
|------|------|------|
| エラー | 赤い波線 | コンパイルエラー、必ず修正が必要 |
| 警告 | 緑の波線 | 潜在的な問題、修正を推奨 |
| 情報 | グレーの波線 | コードスタイルの提案 |

### 4.2 クイックアクション（電球アイコン）

1. 診断がある行にカーソルを置くと、左側に電球アイコンが表示されます
2. 電球アイコンをクリック、または「Ctrl+.」を押します
3. 利用可能な修正候補が一覧表示されます
4. 適用したい修正を選択してクリックします

**よく使う修正例：**
- usingディレクティブの追加
- 未使用変数の削除
- 命名規則違反の修正

### 4.3 バックグラウンド分析の設定

1. 「ツール」>「オプション」を選択します
2. 「テキストエディター」>「C#」>「詳細」を開きます
3. 「Analysis」セクションで分析スコープを設定します：
   - **None**: 分析を無効化
   - **Active File**: 開いているファイルのみ
   - **Open Files**: 開いている全ファイル
   - **Full Solution**: ソリューション全体

---

## 5. 【STEP2-3】リファクタリング機能（コードの改善）

> **業務フローでの位置**: 診断で検出された問題を修正し、コード品質を向上させるステップです。

### 5.1 名前変更（Rename）

シンボルの名前を安全に変更する手順：

1. 変更したいシンボル（変数名、メソッド名など）にカーソルを置きます
2. 「F2」キーを押すと、リネームフライアウトが表示されます
3. 新しい名前を入力します
4. 必要に応じてオプションを設定します：
   - **オーバーロードを含む**: 同名のオーバーロードメソッドも変更
   - **コメント内を検索**: コメント内の参照も変更
   - **文字列内を検索**: 文字列リテラル内の参照も変更
   - **ファイル名を変更**: 型名に一致するファイル名も変更
5. 「Enter」キーでリネームを確定します
6. 変更をプレビューしたい場合は「Shift+Enter」を押します

**注意点：**
- すべての参照箇所が自動的に更新されます
- 競合がある場合は警告が表示されます

### 5.2 シグネチャ変更ダイアログ

メソッドのパラメータを変更する手順：

1. メソッドのシグネチャ部分にカーソルを置きます
2. 右クリック >「リファクタリング」>「シグネチャの変更」を選択します
3. シグネチャ変更ダイアログが表示されます
4. 以下の操作が可能です：
   - **パラメータの追加**: 「Add」ボタンをクリック
   - **パラメータの削除**: 行を選択して「Remove」ボタンをクリック
   - **パラメータの並べ替え**: 行を選択して上下ボタンで移動
5. 「OK」をクリックして変更を確定します

**ダイアログの項目：**

| 項目 | 説明 |
|------|------|
| Index | パラメータの位置番号 |
| Modifier | 修飾子（ref、out、params等） |
| Type | パラメータの型 |
| Parameter | パラメータ名 |
| Default | デフォルト値 |
| Callsite | 呼び出し元での値 |

### 5.3 クラス抽出

既存クラスから新しいクラスを抽出する手順：

1. 抽出したいメンバーを含むクラス内にカーソルを置きます
2. 右クリック >「リファクタリング」>「クラスの抽出」を選択します
3. クラス抽出ダイアログが表示されます
4. 新しいクラス名を入力します
5. 抽出するメンバーをチェックボックスで選択します
6. ファイルの作成先を指定します
7. 「OK」をクリックして抽出を実行します

### 5.4 インターフェース抽出

クラスからインターフェースを抽出する手順：

1. クラス定義にカーソルを置きます
2. 右クリック >「リファクタリング」>「インターフェースの抽出」を選択します
3. インターフェース抽出ダイアログが表示されます
4. インターフェース名を入力します
5. 抽出するパブリックメンバーを選択します
6. 「OK」をクリックして抽出を実行します

### 5.5 メソッド抽出

選択したコードを新しいメソッドに抽出する手順：

1. 抽出したいコードブロックを選択します
2. 右クリック >「リファクタリング」>「メソッドの抽出」を選択します
3. 新しいメソッド名を入力します
4. 抽出されたメソッドが作成され、元の場所が呼び出しに置き換えられます

---

## 6. 【STEP3-4】コード生成・補完機能（コードの作成）

> **業務フローでの位置**: 新しいコードの作成を効率化し、開発者の生産性を向上させるステップです。

### 6.1 コンストラクタの生成

フィールドやプロパティからコンストラクタを生成する手順：

1. クラス内でコンストラクタを生成したい位置にカーソルを置きます
2. 「Ctrl+.」を押してクイックアクションを表示します
3. 「コンストラクタの生成」を選択します
4. 初期化するメンバーを選択します
5. コンストラクタが自動生成されます

### 6.2 インターフェースの実装

インターフェースのメンバーを自動実装する手順：

1. インターフェースを実装するクラスを定義します
2. インターフェース名に赤い波線が表示されます
3. 「Ctrl+.」を押してクイックアクションを表示します
4. 「インターフェースの実装」を選択します
5. インターフェースのすべてのメンバーが自動生成されます

### 6.3 型の生成

存在しない型を自動生成する手順：

1. 存在しない型名を入力します（赤い波線が表示されます）
2. 「Ctrl+.」を押してクイックアクションを表示します
3. 「型の生成」を選択します
4. 型生成ダイアログが表示されます
5. 以下の項目を設定します：
   - **アクセス修飾子**: public、internal等
   - **型の種類**: class、struct、interface、enum
   - **プロジェクト**: 生成先プロジェクト
   - **ファイル名**: 新規ファイルまたは既存ファイル
6. 「OK」をクリックして生成を実行します

### 6.4 Equals/GetHashCodeの生成

オブジェクトの等価性比較メソッドを生成する手順：

1. クラス内にカーソルを置きます
2. 「Ctrl+.」を押してクイックアクションを表示します
3. 「Equals と GetHashCode を生成」を選択します
4. 比較に使用するメンバーを選択します
5. メソッドが自動生成されます

---

## 7. 【STEP4-5】設定・カスタマイズ機能（環境の最適化）

> **業務フローでの位置**: チームのコーディング規約や個人の好みに合わせて環境を設定するステップです。

### 7.1 EditorConfig設定エディタ

EditorConfigファイルをGUIで編集する手順：

1. ソリューションエクスプローラーで `.editorconfig` ファイルをダブルクリックします
2. EditorConfig設定エディタが表示されます
3. 4つのタブから設定カテゴリを選択します：
   - **Whitespace**: インデント、タブサイズ等の空白設定
   - **Code Style**: varの使用、括弧の配置等
   - **Naming Style**: 命名規則の設定
   - **Analyzers**: アナライザールールの重大度設定
4. 設定を変更すると、EditorConfigファイルに自動反映されます

### 7.2 命名スタイルの設定

命名規則を設定する手順：

1. 「ツール」>「オプション」を選択します
2. 「テキストエディター」>「C#」>「コードスタイル」>「名前付け」を開きます
3. 命名スタイルオプションページが表示されます
4. 以下の操作が可能です：
   - **ルールの追加**: 新しい命名規則を追加
   - **仕様の編集**: シンボル種類、アクセス修飾子を設定
   - **スタイルの編集**: プレフィックス、サフィックス、大文字小文字規則を設定
5. 「OK」をクリックして設定を保存します

**命名スタイルの例：**

| シンボル種類 | 命名規則 | 例 |
|-------------|---------|-----|
| プライベートフィールド | _camelCase | _firstName |
| パブリックプロパティ | PascalCase | FirstName |
| 定数 | UPPER_CASE | MAX_VALUE |
| インターフェース | IPrefix | IDisposable |

### 7.3 C#詳細オプションの設定

C#の詳細設定を行う手順：

1. 「ツール」>「オプション」を選択します
2. 「テキストエディター」>「C#」>「詳細」を開きます
3. 各セクションの設定を調整します：

**主要な設定項目：**

| セクション | 項目 | 説明 |
|-----------|------|------|
| Analysis | バックグラウンド分析スコープ | 分析対象の範囲 |
| Source Generators | 実行タイミング | 自動/バランス |
| Go To Definition | SourceLinkへのナビゲーション | 有効/無効 |
| Inline Hints | パラメータ名ヒント | 有効/無効 |
| Inheritance Margin | 継承マージン表示 | 有効/無効 |

### 7.4 コードスタイルの重大度設定

コードスタイル違反の重大度を設定する手順：

1. EditorConfig設定エディタを開きます
2. 「Code Style」タブを選択します
3. 各ルールの重大度を選択します：
   - **None**: 無効
   - **Suggestion**: 提案（グレー表示）
   - **Warning**: 警告（緑の波線）
   - **Error**: エラー（赤の波線）

---

## 8. ナビゲーション機能

### 8.1 定義へ移動（Go to Definition）

シンボルの定義位置に移動する手順：

1. 移動したいシンボル上にカーソルを置きます
2. 「F12」キーを押します
3. シンボルの定義位置にジャンプします

**注意点：**
- 外部アセンブリの場合、メタデータまたは逆コンパイル結果が表示されます
- SourceLinkが有効な場合、ソースコードに移動できます

### 8.2 参照の検索（Find All References）

シンボルの使用箇所を検索する手順：

1. 検索したいシンボル上にカーソルを置きます
2. 「Shift+F12」キーを押します
3. 「参照の検索」ウィンドウに結果が表示されます
4. 結果をダブルクリックして該当箇所にジャンプできます

### 8.3 ドキュメントアウトライン

ファイル内のシンボル構造を確認する手順：

1. 「表示」>「ドキュメントアウトライン」を選択します
2. ドキュメントアウトラインウィンドウが表示されます
3. 以下の操作が可能です：
   - **ツリーの展開/折りたたみ**: シンボル構造を確認
   - **ソート**: 名前順、位置順、種類順で並べ替え
   - **検索**: シンボル名でフィルタリング
   - **ナビゲーション**: シンボルをクリックして該当位置に移動
4. エディタ内のカーソル位置に連動してツリー内のシンボルが自動選択されます

### 8.4 継承マージン

型の継承関係を確認する手順：

1. エディタの左マージンに継承アイコンが表示されます
2. アイコンをクリックするとコンテキストメニューが表示されます
3. 以下のナビゲーションが可能です：
   - **基底型へ移動**: 親クラスに移動
   - **派生型へ移動**: 子クラスに移動
   - **インターフェースへ移動**: 実装元インターフェースに移動
   - **実装へ移動**: インターフェース実装に移動

---

## 9. ツールウィンドウ

### 9.1 値追跡（Value Tracking）

変数の値の流れを追跡する手順：

1. 追跡したい変数にカーソルを置きます
2. 右クリック >「値の追跡」を選択します
3. 値追跡ツールウィンドウが表示されます
4. 値がどこから来ているかをツリー形式で確認できます

### 9.2 スタックトレースエクスプローラー

例外スタックトレースからコードに移動する手順：

1. 「表示」>「スタックトレースエクスプローラー」を選択します
2. スタックトレースをコピーしてエクスプローラーにペーストします
3. 各スタックフレームをクリックしてコード位置に移動できます

---

## 10. デバッグ支援機能

### 10.1 Edit and Continue

デバッグ中にコードを編集して実行を継続する手順：

1. デバッグを開始します（F5）
2. ブレークポイントで停止中にコードを編集します
3. 「継続」（F5）または「ステップ実行」で実行を再開します
4. 編集内容が即時反映されます

**注意点：**
- 一部の変更（メソッドシグネチャの変更等）は適用できません
- 変更できない場合はエラーメッセージが表示されます

### 10.2 スマートリネーム（Copilot連携）

AIによるリネーム候補を使用する手順（Copilot有効時）：

1. シンボル上で「F2」キーを押します
2. スマートリネームコンボボックスが表示されます
3. 「Ctrl+Space」でAI候補の取得をトリガーします
4. 候補から選択するか、新しい名前を入力します
5. 「Enter」で確定します

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
====================================================
【STEP 1】コード分析：問題や改善点を検出 --> 4章参照
    |
【STEP 2】問題の確認：診断メッセージを確認 --> 4章参照
    |
【STEP 3】リファクタリング：コード修正・改善 --> 5章参照
    |
【STEP 4】コード生成・補完：新規コード作成 --> 6章参照
    |
【STEP 5】設定最適化：環境カスタマイズ --> 7章参照
====================================================
```

### 11.1 【開発者】STEP1: コードを書き始める

1. Visual Studioを起動し、プロジェクトを開きます
2. 編集するファイルをソリューションエクスプローラーから開きます
3. コードを入力します（IntelliSenseが補完候補を表示）
4. バックグラウンド分析が自動的に問題を検出します

### 11.2 【開発者】STEP2: 診断メッセージへの対応

1. 波線で示された問題箇所を確認します
2. マウスホバーで問題の詳細を確認します
3. 電球アイコン（Ctrl+.）でクイックアクションを表示します
4. 適切な修正を選択して適用します

### 11.3 【開発者】STEP3: リファクタリングの実行

1. 改善したいコードにカーソルを置きます
2. 右クリック >「リファクタリング」から操作を選択します
3. ダイアログで必要な設定を行います
4. プレビューで変更内容を確認し、適用します

### 11.4 【チームリーダー】STEP5: コードスタイルの設定

1. プロジェクトルートに `.editorconfig` ファイルを作成します
2. EditorConfig設定エディタで命名規則を設定します
3. コードスタイルの重大度を設定します
4. チームメンバーにファイルを共有します

---

## 12. よくある質問と対処法

### 12.1 IntelliSenseに関するQ&A

**Q: IntelliSenseが表示されません**

A: 以下を確認してください：
1. 「ツール」>「オプション」>「テキストエディター」>「C#」>「IntelliSense」で設定を確認
2. 「Ctrl+Space」で明示的に呼び出しを試す
3. ソリューションを再ビルドする
4. Visual Studioを再起動する

**Q: IntelliSenseが遅いです**

A: 以下を試してください：
1. バックグラウンド分析のスコープを「Active File」に変更
2. 不要な拡張機能を無効化
3. ソリューション内の不要なプロジェクトをアンロード

### 12.2 リファクタリングに関するQ&A

**Q: リネームで一部の参照が更新されません**

A: 以下を確認してください：
1. リネームオプションで「コメント内を検索」「文字列内を検索」を有効化
2. 対象がダイナミック型の場合、静的解析で検出できない可能性があります
3. 複数のソリューションにまたがる場合、各ソリューションで個別にリネームが必要です

**Q: シグネチャ変更ダイアログが開きません**

A: 以下を確認してください：
1. カーソルがメソッド、コンストラクタ、インデクサーのシグネチャ部分にあることを確認
2. ファイルが読み取り専用でないことを確認
3. 対象がソースコード内（メタデータ表示ではない）であることを確認

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| シグネチャを変更する必要があります | シグネチャ変更ダイアログでOKを押したが変更がない | パラメータの追加・削除・並べ替えを行ってから確定 |
| 新しい名前は有効な識別子ではありません | リネームで無効な識別子を入力 | C#/VBの識別子規則に従った名前を入力 |
| N件の解決できない競合があります | リネームで名前の競合が発生 | 別の名前を選択するか、競合を手動で解決 |

### 13.2 よくあるトラブルと解決方法

**トラブル: 診断が表示されない**

解決方法：
1. 「ツール」>「オプション」>「テキストエディター」>「C#」>「詳細」を開く
2. 「Analysis」セクションで分析スコープが「None」になっていないか確認
3. 「コンパイラ診断スコープ」が適切に設定されているか確認
4. ソリューションを再ビルドする

**トラブル: EditorConfigの設定が反映されない**

解決方法：
1. `.editorconfig` ファイルがプロジェクトに含まれているか確認
2. ファイルが正しいディレクトリ階層にあるか確認
3. Visual Studioを再起動する
4. 設定の構文エラーがないか確認

**トラブル: ドキュメントアウトラインが空です**

解決方法：
1. ファイルにシンボル（クラス、メソッド等）が定義されているか確認
2. ファイルがC#またはVBファイルであることを確認
3. ソリューションが読み込まれているか確認

### 13.3 サポートへの連絡方法

問題が解決しない場合は、以下の方法でサポートを受けることができます：

1. **GitHubイシュー**: https://github.com/dotnet/roslyn/issues で問題を報告
2. **Stack Overflow**: `roslyn` タグを使用して質問
3. **Gitter**: https://gitter.im/dotnet/roslyn でコミュニティに相談

**問題報告時に含める情報：**
- Visual Studioのバージョン
- Roslynのバージョン
- 再現手順
- エラーメッセージのスクリーンショット
- 関連するコードスニペット

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-10 | 初版作成 |

---

*本マニュアルは、Roslyn (.NET Compiler Platform) のエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
