---
generated_at: 2026-02-10 15:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **NFT-005（大規模ソリューション応答性）**：4GBメモリ制限の具体的な測定基準が未定義
  2. **NFT-024（セキュリティレポートプロセス）**：24時間応答の実測値が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/wiki/Measuring-Compiler-Performance.md` - コンパイラ性能測定ガイド
- E-02: `docs/wiki/Performance-considerations-for-large-solutions.md` - 大規模ソリューション性能考慮事項
- E-03: `azure-pipelines.yml` - メインCI/CDパイプライン設定
- E-04: `azure-pipelines-integration.yml` - 統合テストパイプライン設定
- E-05: `azure-pipelines-compliance.yml` - コンプライアンスパイプライン設定
- E-06: `eng/pipelines/test-windows-job.yml` - Windowsテストジョブ設定
- E-07: `eng/pipelines/test-unix-job.yml` - Unixテストジョブ設定
- E-08: `SECURITY.md` - セキュリティポリシー
- E-09: `docs/contributing/Building, Debugging, and Testing on Windows.md` - ビルド・テストガイド
- E-10: `eng/TSAConfig.gdntsa` - セキュリティ解析設定
- E-11: `eng/todo-check.ps1` - TODO検証スクリプト
- E-12: `eng/validate-code-formatting.ps1` - コードフォーマット検証スクリプト
- E-13: `eng/validate-rules-missing-documentation.ps1` - ドキュメント検証スクリプト
- E-14: `global.json` - SDK設定
- E-15: `src/Tools/IdeBenchmarks/` - IDEベンチマークプロジェクト
- E-16: `src/Tools/IdeCoreBenchmarks/` - IDEコアベンチマークプロジェクト
- E-17: `src/RoslynAnalyzers/PerformanceSensitiveAnalyzers/` - 性能感度アナライザ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: CompileMethodsAndEmit性能測定（Mean 6,374ms以内） | E-01 | ○ |
| C-02 | NFT-002: SerializeMetadata性能測定（Mean 422ms以内） | E-01 | ○ |
| C-03 | NFT-003: GetDiagnostics性能測定（Mean 4,808ms以内） | E-01 | ○ |
| C-04 | NFT-004: GetDiagnosticsWithAnalyzers性能測定（Mean 17,985ms以内） | E-01 | ○ |
| C-05 | NFT-005: 大規模ソリューション応答性（4GBメモリ制限） | E-02 | △ |
| C-06 | NFT-006: 構文木キャッシュメモリ管理（RecoverableTreeLengthThreshold） | E-02 | ○ |
| C-07 | NFT-007: ビルドタイムアウト検証（90分以内） | E-03 | ○ |
| C-08 | NFT-008: 単体テストタイムアウト検証（120分以内） | E-06 | ○ |
| C-09 | NFT-009: VS統合テストタイムアウト検証（150分以内） | E-04 | ○ |
| C-10 | NFT-010: Windows Debug x86動作確認 | E-03 | ○ |
| C-11 | NFT-011: Windows Debug x64動作確認 | E-03 | ○ |
| C-12 | NFT-012: Windows Release x86動作確認 | E-03 | ○ |
| C-13 | NFT-013: Windows Release x64動作確認 | E-03 | ○ |
| C-14 | NFT-014: Linux CoreClr Debug動作確認 | E-03, E-07 | ○ |
| C-15 | NFT-015: macOS Debug動作確認 | E-03 | ○ |
| C-16 | NFT-016: CoreClr Debug動作確認 | E-03 | ○ |
| C-17 | NFT-017: CoreClr Release動作確認 | E-03 | ○ |
| C-18 | NFT-018: スペイン語環境動作確認 | E-03 | ○ |
| C-19 | NFT-019: 決定論的ビルド検証 | E-03 | ○ |
| C-20 | NFT-020: Managed Source Build検証 | E-03 | ○ |
| C-21 | NFT-021: APIScan実行 | E-05 | ○ |
| C-22 | NFT-022: TSAUpload結果確認 | E-05, E-10 | ○ |
| C-23 | NFT-023: アナライザ警告検証 | E-03 | ○ |
| C-24 | NFT-024: セキュリティレポートプロセス（24時間応答） | E-08 | △ |
| C-25 | NFT-025: NET Framework 4.7.2互換性 | E-09 | ○ |
| C-26 | NFT-026: Visual Studio 2022 Preview統合 | E-03, E-04 | ○ |
| C-27 | NFT-027: Visual Studio 2026 Preview統合 | E-03 | ○ |
| C-28 | NFT-028: .NET 10.0 SDK互換性 | E-09, E-14 | ○ |
| C-29 | NFT-029: ブートストラップビルド検証 | E-03 | ○ |
| C-30 | NFT-030: Frameworkブートストラップ検証 | E-03 | ○ |
| C-31 | NFT-031: コードフォーマット検証 | E-12 | ○ |
| C-32 | NFT-032: TODO/PROTOTYPE検証 | E-11 | ○ |
| C-33 | NFT-033: ルールドキュメント検証 | E-13 | ○ |
| C-34 | NFT-034: BuildBoss検証 | E-03 | ○ |
| C-35 | NFT-035: ソース同期検証 | E-03 | ○ |
| C-36 | NFT-036: リビルド検証 | E-03 | ○ |
| C-37 | NFT-037: IOperation検証付きテスト | E-03 | ○ |
| C-38 | NFT-038: RuntimeAsync検証付きテスト | E-03 | ○ |
| C-39 | NFT-039: UsedAssemblies検証付きテスト | E-03 | ○ |
| C-40 | NFT-040: シングルマシンテスト実行 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-005: 大規模ソリューション応答性**
  - 4GBメモリ制限は32bitプロセスの理論的制限であり、具体的な測定基準やパス基準が文書化されていない
  - 候補：IDE性能ベンチマーク結果 / Visual Studioパフォーマンステストレポート / ユーザビリティテスト結果

- **NFT-024: セキュリティレポートプロセス**
  - SECURITY.mdには「24時間以内の応答」と記載されているが、これはMSRCのSLAであり、Roslynプロジェクト固有の実測値ではない
  - 候補：MSRCインシデント対応履歴 / セキュリティ対応SLA文書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 性能テストケース（NFT-001〜NFT-004）：ベンチマーク基準が明確に定義されている
- **0: 低リスク** - CI/CDパイプラインテスト（NFT-007〜NFT-040）：YAMLファイルで明確に設定されている
- **1: 中リスク** - IDE性能テスト（NFT-005, NFT-006）：ユーザー環境依存の要素があり、定量的な基準の確認が必要
- **1: 中リスク** - セキュリティプロセステスト（NFT-024）：外部組織（MSRC）への依存があり、応答時間の保証確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テストの合格基準値（Mean, Allocated）が最新のベンチマーク結果と一致しているか確認
- [ ] CI/CDパイプラインのタイムアウト設定が実際のYAMLファイルと一致しているか確認
- [ ] 対応プラットフォーム（Windows/Linux/macOS）のバージョンが最新の要件と一致しているか確認
- [ ] Visual Studioバージョン（2022 Preview, 2026 Preview）のサポート状況を確認
- [ ] セキュリティ関連テストケースがMSRCポリシーと整合しているか確認
- [ ] .NET SDKバージョン要件がglobal.jsonと一致しているか確認
