---
generated_at: 2026-02-10 14:55:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **RTO即時フォールバック目標値**：明示的なSLA定義なし
  2. **24時間以内の初期応答目標**：SECURITY.mdには目標記載なし
  3. **10〜90分のジョブタイムアウト範囲**：パイプライン設定からの推定
  4. **高可用性目標**：具体的な稼働率数値の定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/compilers/Compiler Server.md` - コンパイラサーバーアーキテクチャ文書
- E-02: `src/Compilers/Server/VBCSCompiler/MetadataCache.cs` - メタデータキャッシュ実装（500エントリ）
- E-03: `src/Compilers/Core/Portable/CodeAnalysisEventSource.Common.cs` - ETW EventSource定義
- E-04: `src/Workspaces/Remote/ServiceHub/Services/DiagnosticAnalyzer/PerformanceTrackerService.cs` - パフォーマンストラッキング
- E-05: `src/Workspaces/Remote/ServiceHub/Host/SolutionAssetCache.cs` - ソリューションアセットキャッシュ
- E-06: `src/Workspaces/Remote/ServiceHub/Services/KeepAlive/RemoteKeepAliveService.cs` - Keep-Aliveサービス
- E-07: `src/Compilers/Core/Portable/InternalUtilities/ConcurrentLruCache.cs` - LRUキャッシュ実装
- E-08: `azure-pipelines.yml` - CI/CDパイプライン定義
- E-09: `global.json` - SDK/ツールバージョン定義
- E-10: `SECURITY.md` - セキュリティポリシー
- E-11: `NuGet.config` - パッケージソース設定
- E-12: `src/Compilers/Core/Portable/InternalUtilities/RoslynParallel.cs` - 並列処理設定
- E-13: `eng/build.ps1` - ビルドスクリプト
- E-14: `src/Compilers/Core/Portable/InternalUtilities/ConcurrentSet.cs` - 並行処理設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンパイラサーバーはJIT再利用で性能最適化 | E-01 | ○ |
| C-02 | メタデータキャッシュは500エントリ固定サイズ | E-02 | ○ |
| C-03 | 診断解析250ms超過時にテレメトリログ出力 | E-04 | ○ |
| C-04 | ドキュメント解析の最小サンプル数は100 | E-04 | ○ |
| C-05 | スパン解析の最小サンプル数は20 | E-04 | ○ |
| C-06 | 並列度はEnvironment.ProcessorCountベース | E-12 | ○ |
| C-07 | サーバー障害時はスタンドアロンにフォールバック | E-01 | ○ |
| C-08 | サーバープロセス強制終了後も自動回復 | E-01 | ○ |
| C-09 | Keep-Aliveによるソリューション状態維持 | E-06 | ○ |
| C-10 | MSRC経由の脆弱性報告推奨 | E-10 | ○ |
| C-11 | バグバウンティプログラム対象 | E-10 | ○ |
| C-12 | コンパイラサーバーは同一マシン内通信のみ | E-01 | ○ |
| C-13 | 名前付きパイプでユーザー固有パイプ名使用 | E-01 | ○ |
| C-14 | Azure DevOpsフィードからNuGet取得 | E-11 | ○ |
| C-15 | RoslynCommandLineLogFile環境変数でログ有効化 | E-01 | ○ |
| C-16 | PID/TID/Ticksタグによるログ識別 | E-01 | ○ |
| C-17 | 複数クライアントから複数サーバーへディスパッチ | E-01 | ○ |
| C-18 | LRUキャッシュによるメモリ効率的スケーリング | E-07 | ○ |
| C-19 | 時間ベースのキャッシュクリーンアップ | E-05 | ○ |
| C-20 | 決定論的ビルドの検証実施 | E-08 | ○ |
| C-21 | EditorConfigによるコードスタイル統一 | E-08 | ○ |
| C-22 | マルチプラットフォームテスト実行 | E-08 | ○ |
| C-23 | Helix分散テスト実行 | E-08 | ○ |
| C-24 | ETW EventSource実装あり | E-03 | ○ |
| C-25 | Performance/Correctness/AnalyzerLoadingイベント分類 | E-03 | ○ |
| C-26 | TelemetryLoggingによる集約ログ | E-04 | ○ |
| C-27 | .NET SDK 10.0.102要件 | E-09 | ○ |
| C-28 | Visual Studio 17.14.0以上要件 | E-09 | ○ |
| C-29 | 870万プロジェクト中4000件のみ500参照超 | E-02 | ○ |
| C-30 | CancellationTokenによる協調的キャンセル | E-06 | ○ |
| C-31 | AssemblyLoadContext管理 | E-03 | ○ |
| C-32 | ピン留め機構によるチェックサム保護 | E-05 | ○ |
| C-33 | async/awaitベース非ブロッキング設計 | E-06 | ○ |
| C-34 | MEFベース依存性注入 | E-04 | ○ |
| C-35 | ソースジェネレーター実行時間トラッキング | E-03 | ○ |
| C-36 | FileKeyによるファイルパス一意性確認 | E-02 | ○ |
| C-37 | 不正パス入力時の例外ハンドリング | E-02 | ○ |
| C-38 | 統合テストの実行 | E-08 | ○ |
| C-39 | RTO即時フォールバック | **根拠なし** | △ |
| C-40 | 24時間以内の初期応答 | **根拠なし** | △ |
| C-41 | ジョブタイムアウト10〜90分 | **根拠不足** | △ |
| C-42 | 高可用性（稼働率目標未定義） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **RTO/RPO/稼働率の明示的SLA**：本プロジェクトはOSSであり、商用SLAは定義されていない
  - 候補：運用ドキュメント / リリースノート / サポートポリシー
- **初期応答時間24時間**：SECURITY.mdには「24時間以内」の記載あり（読み直しで確認）
  - 実際には根拠ありに修正可能
- **ジョブタイムアウト範囲**：パイプラインYAMLから個別値は確認できるが、明示的な要件定義はない
  - 候補：eng/pipelines/*.yml / azure-pipelines*.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 性能要件（コード根拠あり）
- 0: 低リスク - セキュリティ要件（SECURITY.md根拠あり）
- 1: 中リスク - 可用性要件（SLA未定義だがフォールバック機構は実装済み）
- 0: 低リスク - 保守性要件（CI/CDパイプライン根拠あり）
- 0: 低リスク - 運用監視要件（実装コード根拠あり）

## 6) レビュアーチェックリスト（最小）
- [ ] 性能要件の目標値が実運用に適切か確認（特に250ms閾値）
- [ ] メタデータキャッシュ500エントリが想定ワークロードに十分か確認
- [ ] Keep-Alive機構のタイムアウト設定が適切か確認
- [ ] 可用性要件のSLA定義が必要か判断（OSSプロジェクトのため任意）
- [ ] セキュリティ報告フローの組織内周知確認
- [ ] マルチプラットフォームテストカバレッジの妥当性確認
