# 非機能要件定義書

## 概要

本ドキュメントは、Roslyn（.NET Compiler Platform）プロジェクトの非機能要件を定義するものである。Roslynは、C#およびVisual Basicのコンパイラ、コード分析ツール、IDEサポート機能を提供するプラットフォームであり、高い性能、可用性、セキュリティ、保守性が求められる。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| コンパイラサーバー応答 | 数百ミリ秒以内 | JIT済みコード再利用により、初回以降は高速化 |
| インクリメンタルコンパイル | 変更差分に応じた時間 | ソースジェネレーター実行時間をETWでトラッキング |
| 診断解析（ドキュメント） | 250ミリ秒以内（推奨） | 250ms超過時はテレメトリログ出力 |
| 診断解析（スパン/ライトバルブ） | リアルタイム応答 | 最小サンプル数20で統計評価 |
| コード補完応答 | ユーザー入力に追従 | CompletionListCacheによるキャッシュ活用 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時コンパイル | 複数クライアント対応 | コンパイラサーバーが複数クライアントを処理 |
| 並列処理 | CPUコア数に応じたスケーリング | `Environment.ProcessorCount`ベースの並列度設定 |
| メタデータキャッシュエントリ数 | 500エントリ | LRUキャッシュによる自動退避（約870万プロジェクト中4,000件のみが500参照超） |
| ソリューションアセットキャッシュ | 時間ベース自動クリーンアップ | 未使用アセットの自動パージ |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| コンパイラサーバー稼働率 | 高可用性 | サーバー障害時は自動でスタンドアロンコンパイルにフォールバック |
| グレースフルリカバリ | 即時 | サーバープロセス強制終了時もクライアントは自動回復 |
| Keep-Alive機構 | セッション維持 | RemoteKeepAliveServiceによるソリューション状態の維持 |
| 計画停止時間 | 最小化 | ホットリロード、インクリメンタルビルド対応 |
| 障害復旧時間（RTO） | 即時（フォールバック） | サーバー通信失敗時は即座にインプロセス実行 |
| 目標復旧時点（RPO） | N/A | ステートレス設計のため該当なし |

## セキュリティ要件

### 脆弱性管理

- **脆弱性報告**: Microsoft Security Response Center (MSRC)への非公開報告を推奨
- **報告先**: secure@microsoft.com または https://msrc.microsoft.com
- **応答時間**: 24時間以内の初期応答
- **バグバウンティ**: .NET Core Bug Bountyプログラム対象

### アクセス制御

- **コンパイラサーバー通信**: 同一マシン内のみ（クライアント・サーバー間でコマンドラインのみ交換）
- **名前付きパイプ**: ユーザー固有のパイプ名使用（ユーザー名ベース）
- **NuGetパッケージソース**: 認証済みAzure DevOpsフィード使用

### 入力検証

- **ファイルパス検証**: FileKey使用による一意性確認
- **例外処理**: 不正パス入力時の適切なエラーハンドリング（NotSupportedException、PathTooLongException、UnauthorizedAccessException等）

### 監査ログ

- **診断ログ**: `RoslynCommandLineLogFile`環境変数による詳細ログ出力
- **PID/TID/Ticksタグ**: クライアント/サーバー識別可能なログフォーマット

## 拡張性要件

### アーキテクチャ拡張性

- **クライアント・サーバーモデル**: 複数クライアントから複数サーバーへのディスパッチ対応
- **プラグインアーキテクチャ**: アナライザー、コードフィクス、リファクタリングの動的追加
- **ソースジェネレーター**: コンパイル時コード生成の拡張ポイント
- **MEFベース依存性注入**: ワークスペースサービスの柔軟な構成

### スケーラビリティ

- **LRUキャッシュ**: 固定サイズキャッシュによるメモリ効率的なスケーリング
- **並列処理**: `ParallelOptions`による並列度制御
- **非同期処理**: async/awaitベースの非ブロッキング設計
- **リモートワークスペース**: Out-of-Process実行によるIDEプロセス分離

## 保守性要件

### コード品質

- **決定論的ビルド**: ビルド再現性の検証（Correctness_Determinism）
- **コードスタイル強制**: EditorConfigによる統一的なコードスタイル
- **アナライザー実行**: ビルド時の静的解析によるコード品質維持
- **BootstrapビルドTest**: 自己ホスティングビルドの検証

### テスト

- **マルチプラットフォーム**: Windows（Debug/Release）、Unix、macOSでのテスト実行
- **Helix分散テスト**: 大規模並列テスト実行基盤
- **統合テスト**: Visual Studio統合テスト
- **IOperationテスト**: セマンティックモデル検証

### ログ・診断

- **ETW EventSource**: `CodeAnalysisEventSource`による詳細なパフォーマンストレース
- **パフォーマンスキーワード**: Performance、Correctness、AnalyzerLoadingのイベント分類
- **テレメトリ**: `TelemetryLogging`による集約ヒストグラムとイベントログ
- **バイナリログ**: MSBuildバイナリログによるビルドトレース

### ドキュメント

- **API XML文書**: DocumentationProviderによるXMLドキュメント提供
- **Wikiドキュメント**: CI障害調査手順等の運用ドキュメント

## 運用・監視要件

### ビルド・CI/CD

- **Azure Pipelines**: 複数ステージによる並列ビルド・テストパイプライン
- **ジョブタイムアウト**: 10〜90分（ジョブ種別により設定）
- **成果物管理**: アーティファクト公開・保持
- **Helix統合**: 分散テスト実行と結果収集

### パフォーマンス監視

- **PerformanceTrackerService**: アナライザー実行時間の統計収集
- **サンプルサイズ**: ドキュメント解析100サンプル、スパン解析20サンプルで安定評価
- **遅延閾値アラート**: 250ms超過時のテレメトリ通知

### キャッシュ管理

- **SolutionAssetCache**: 時間ベースのクリーンアップ（`cleanupInterval`、`purgeAfter`パラメータ）
- **MetadataCache**: 500エントリ固定サイズLRUキャッシュ
- **ピン留め機構**: 現在のソリューションに関連するチェックサムの保護

### リソース管理

- **Keep-Alive**: セッションベースのリソース保持と自動解放
- **CancellationToken**: 協調的キャンセルによるリソース適切な解放
- **AssemblyLoadContext**: アナライザーアセンブリのロード/アンロード管理

## 備考

### 環境要件

- **.NET SDK**: 10.0.102
- **Visual Studio**: 17.14.0以上
- **対応OS**: Windows、Ubuntu 22.04、macOS 15

### 制約事項

- コンパイラサーバーはクライアントと同一マシンでの実行が必須
- 大規模プロジェクト（500参照超）ではキャッシュ効率が低下する可能性あり
- ソースジェネレーター実行時間は生成内容に依存
