# API設計書

## 概要

本ドキュメントは、RuoYi管理システムのAPIエンドポイント仕様を定義します。RuoYiはSpring Boot + Apache Shiroベースの権限管理システムであり、ユーザー管理、ロール管理、メニュー管理、システム監視などの機能を提供します。

## 共通仕様

### ベースURL

```
http://{hostname}:{port}
```

デフォルト: `http://localhost:80`

### 認証方式

Apache Shiroによるセッションベース認証を採用しています。
- ログイン後、サーバーサイドでセッションが作成され、クライアントにはセッションIDがCookieで返されます
- 各リクエストにはセッションCookieが必要です
- Remember Me機能（オプション）をサポート

### 共通ヘッダー

| ヘッダー名 | 必須 | 説明 |
| --- | --- | --- |
| Cookie | - | セッションID（JSESSIONID） |
| Content-Type | - | application/x-www-form-urlencoded（フォームデータ）/ multipart/form-data（ファイルアップロード） |

### 共通レスポンス形式

#### 標準レスポンス（AjaxResult）

```json
{
  "code": 0,
  "msg": "操作成功",
  "data": {}
}
```

| フィールド | 型 | 説明 |
| --- | --- | --- |
| code | int | 状態コード（0: 成功, 301: 警告, 500: エラー） |
| msg | string | メッセージ |
| data | object | データ（オプション） |

#### ページネーションレスポンス（TableDataInfo）

```json
{
  "total": 100,
  "rows": [],
  "code": 0,
  "msg": null
}
```

| フィールド | 型 | 説明 |
| --- | --- | --- |
| total | long | 総件数 |
| rows | array | データリスト |
| code | int | 状態コード |
| msg | string | メッセージ |

### 共通エラーレスポンス

| ステータスコード | code値 | 説明 |
| --- | --- | --- |
| 200 | 0 | 成功 |
| 200 | 301 | 警告（業務エラー） |
| 200 | 500 | エラー |
| 302 | - | 未認証（ログインページへリダイレクト） |

### ページネーション共通パラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| pageNum | int | - | 1 | ページ番号 |
| pageSize | int | - | 10 | 1ページあたりの件数 |
| orderByColumn | string | - | - | ソート列 |
| isAsc | string | - | asc | ソート順（asc/desc） |

---

## API一覧

### 認証系

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| 認証 | /login | GET | ログインページ表示 |
| 認証 | /login | POST | ログイン処理 |
| 認証 | /register | GET | ユーザー登録ページ表示 |
| 認証 | /register | POST | ユーザー登録処理 |
| 認証 | /captcha/captchaImage | GET | 画像認証コード取得 |

### システム管理

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| ユーザー管理 | /system/user/list | POST | ユーザー一覧取得 |
| ユーザー管理 | /system/user/add | POST | ユーザー追加 |
| ユーザー管理 | /system/user/edit | POST | ユーザー更新 |
| ユーザー管理 | /system/user/remove | POST | ユーザー削除 |
| ユーザー管理 | /system/user/export | POST | ユーザーエクスポート |
| ユーザー管理 | /system/user/importData | POST | ユーザーインポート |
| ユーザー管理 | /system/user/resetPwd | POST | パスワードリセット |
| ユーザー管理 | /system/user/changeStatus | POST | ユーザー状態変更 |
| ロール管理 | /system/role/list | POST | ロール一覧取得 |
| ロール管理 | /system/role/add | POST | ロール追加 |
| ロール管理 | /system/role/edit | POST | ロール更新 |
| ロール管理 | /system/role/remove | POST | ロール削除 |
| ロール管理 | /system/role/export | POST | ロールエクスポート |
| メニュー管理 | /system/menu/list | POST | メニュー一覧取得 |
| メニュー管理 | /system/menu/add | POST | メニュー追加 |
| メニュー管理 | /system/menu/edit | POST | メニュー更新 |
| メニュー管理 | /system/menu/remove/{menuId} | GET | メニュー削除 |
| 部門管理 | /system/dept/list | POST | 部門一覧取得 |
| 部門管理 | /system/dept/add | POST | 部門追加 |
| 部門管理 | /system/dept/edit | POST | 部門更新 |
| 部門管理 | /system/dept/remove/{deptId} | GET | 部門削除 |
| 岗位管理 | /system/post/list | POST | 岗位一覧取得 |
| 岗位管理 | /system/post/add | POST | 岗位追加 |
| 岗位管理 | /system/post/edit | POST | 岗位更新 |
| 岗位管理 | /system/post/remove | POST | 岗位削除 |
| 辞書管理 | /system/dict/list | POST | 辞書タイプ一覧取得 |
| 辞書管理 | /system/dict/add | POST | 辞書タイプ追加 |
| 辞書管理 | /system/dict/edit | POST | 辞書タイプ更新 |
| 辞書管理 | /system/dict/remove | POST | 辞書タイプ削除 |
| 辞書管理 | /system/dict/data/list | POST | 辞書データ一覧取得 |
| 設定管理 | /system/config/list | POST | 設定一覧取得 |
| 設定管理 | /system/config/add | POST | 設定追加 |
| 設定管理 | /system/config/edit | POST | 設定更新 |
| 設定管理 | /system/config/remove | POST | 設定削除 |
| 通知管理 | /system/notice/list | POST | 通知一覧取得 |
| 通知管理 | /system/notice/add | POST | 通知追加 |
| 通知管理 | /system/notice/edit | POST | 通知更新 |
| 通知管理 | /system/notice/remove | POST | 通知削除 |

### システム監視

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| ログイン履歴 | /monitor/logininfor/list | POST | ログイン履歴一覧取得 |
| ログイン履歴 | /monitor/logininfor/remove | POST | ログイン履歴削除 |
| ログイン履歴 | /monitor/logininfor/clean | POST | ログイン履歴全削除 |
| ログイン履歴 | /monitor/logininfor/unlock | POST | アカウントロック解除 |
| 操作ログ | /monitor/operlog/list | POST | 操作ログ一覧取得 |
| 操作ログ | /monitor/operlog/remove | POST | 操作ログ削除 |
| 操作ログ | /monitor/operlog/clean | POST | 操作ログ全削除 |
| オンラインユーザー | /monitor/online/list | POST | オンラインユーザー一覧取得 |
| オンラインユーザー | /monitor/online/batchForceLogout | POST | 強制ログアウト |
| キャッシュ監視 | /monitor/cache/getNames | POST | キャッシュ名一覧取得 |
| キャッシュ監視 | /monitor/cache/getKeys | POST | キャッシュキー一覧取得 |
| キャッシュ監視 | /monitor/cache/clearAll | GET | 全キャッシュクリア |

### 定時タスク

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| ジョブ管理 | /monitor/job/list | POST | ジョブ一覧取得 |
| ジョブ管理 | /monitor/job/add | POST | ジョブ追加 |
| ジョブ管理 | /monitor/job/edit | POST | ジョブ更新 |
| ジョブ管理 | /monitor/job/remove | POST | ジョブ削除 |
| ジョブ管理 | /monitor/job/run | POST | ジョブ即時実行 |
| ジョブ管理 | /monitor/job/changeStatus | POST | ジョブ状態変更 |
| ジョブログ | /monitor/jobLog/list | POST | ジョブログ一覧取得 |
| ジョブログ | /monitor/jobLog/remove | POST | ジョブログ削除 |
| ジョブログ | /monitor/jobLog/clean | POST | ジョブログ全削除 |

### コード生成

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| コード生成 | /tool/gen/list | POST | テーブル一覧取得 |
| コード生成 | /tool/gen/db/list | POST | DB テーブル一覧取得 |
| コード生成 | /tool/gen/column/list | POST | カラム一覧取得 |
| コード生成 | /tool/gen/importTable | POST | テーブルインポート |
| コード生成 | /tool/gen/createTable | POST | テーブル作成 |
| コード生成 | /tool/gen/edit | POST | 設定更新 |
| コード生成 | /tool/gen/remove | POST | テーブル削除 |
| コード生成 | /tool/gen/preview/{tableId} | GET | コードプレビュー |
| コード生成 | /tool/gen/download/{tableName} | GET | コード生成（ダウンロード） |
| コード生成 | /tool/gen/genCode/{tableName} | GET | コード生成（ローカル出力） |
| コード生成 | /tool/gen/synchDb/{tableName} | GET | DB同期 |
| コード生成 | /tool/gen/batchGenCode | GET | 一括コード生成 |

### 共通機能

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| ファイル | /common/upload | POST | ファイルアップロード（単一） |
| ファイル | /common/uploads | POST | ファイルアップロード（複数） |
| ファイル | /common/download | GET | ファイルダウンロード |
| ファイル | /common/download/resource | GET | リソースダウンロード |

### 個人情報

| カテゴリ | エンドポイント | メソッド | 説明 |
| --- | --- | --- | --- |
| プロファイル | /system/user/profile | GET | プロファイル表示 |
| プロファイル | /system/user/profile/update | POST | プロファイル更新 |
| プロファイル | /system/user/profile/updateAvatar | POST | アバター更新 |
| プロファイル | /system/user/profile/resetPwd | POST | パスワード変更 |
| プロファイル | /system/user/profile/checkPassword | GET | パスワード検証 |

---

## 各APIエンドポイント定義

### 認証

#### 1. ログイン

ユーザー認証を行い、セッションを確立します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /login` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| username | string | ○ | ログインアカウント |
| password | string | ○ | パスワード |
| rememberMe | boolean | - | Remember Me機能を使用するか |

**レスポンス（成功時）**

ステータスコード: `200 OK`

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

**レスポンス（エラー時）**

```json
{
  "code": 500,
  "msg": "用户或密码错误"
}
```

---

#### 2. ユーザー登録

新規ユーザーを登録します（設定で有効化されている場合のみ）。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /register` |
| 認証 | 不要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| loginName | string | ○ | ログインアカウント |
| userName | string | - | ユーザー名 |
| password | string | ○ | パスワード |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

**レスポンス（エラー時）**

```json
{
  "code": 500,
  "msg": "当前系统没有开启注册功能！"
}
```

---

#### 3. 画像認証コード取得

ログイン用の画像認証コード（CAPTCHA）を取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /captcha/captchaImage` |
| 認証 | 不要 |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
| --- | --- | --- | --- | --- |
| type | string | - | - | 認証コードタイプ（math: 数式, char: 文字） |

**レスポンス（成功時）**

Content-Type: `image/jpeg`

画像バイナリデータが返されます。

---

### ユーザー管理

#### 4. ユーザー一覧取得

ユーザー一覧をページネーション付きで取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/list` |
| 認証 | 必要 |
| 権限 | system:user:list |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| loginName | string | - | ログインアカウント（部分一致） |
| userName | string | - | ユーザー名（部分一致） |
| phonenumber | string | - | 電話番号 |
| status | string | - | 状態（0: 正常, 1: 停止） |
| deptId | long | - | 部門ID |
| pageNum | int | - | ページ番号 |
| pageSize | int | - | 1ページあたりの件数 |

**レスポンス（成功時）**

```json
{
  "total": 10,
  "rows": [
    {
      "userId": 1,
      "deptId": 100,
      "loginName": "admin",
      "userName": "管理員",
      "email": "admin@example.com",
      "phonenumber": "12345678901",
      "sex": "0",
      "avatar": "/profile/avatar/xxx.png",
      "status": "0",
      "loginIp": "127.0.0.1",
      "loginDate": "2024-01-01 12:00:00",
      "createTime": "2024-01-01 00:00:00",
      "dept": {
        "deptId": 100,
        "deptName": "本社"
      },
      "roles": []
    }
  ],
  "code": 0,
  "msg": null
}
```

---

#### 5. ユーザー追加

新規ユーザーを追加します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/add` |
| 認証 | 必要 |
| 権限 | system:user:add |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| loginName | string | ○ | max:30, NotBlank, Xss | ログインアカウント |
| userName | string | - | max:30, Xss | ユーザー名 |
| deptId | long | - | - | 部門ID |
| phonenumber | string | - | max:11 | 電話番号 |
| email | string | - | max:50, Email | メールアドレス |
| sex | string | - | - | 性別（0: 男, 1: 女, 2: 不明） |
| password | string | ○ | - | パスワード |
| status | string | - | - | 状態（0: 正常, 1: 停止） |
| roleIds | long[] | - | - | ロールIDリスト |
| postIds | long[] | - | - | 崗位IDリスト |
| remark | string | - | - | 備考 |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

**レスポンス（エラー時）**

```json
{
  "code": 500,
  "msg": "新增用户'xxx'失败，登录账号已存在"
}
```

---

#### 6. ユーザー更新

既存ユーザー情報を更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/edit` |
| 認証 | 必要 |
| 権限 | system:user:edit |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
| --- | --- | --- | --- | --- |
| userId | long | ○ | - | ユーザーID |
| loginName | string | ○ | max:30, NotBlank, Xss | ログインアカウント |
| userName | string | - | max:30, Xss | ユーザー名 |
| deptId | long | - | - | 部門ID |
| phonenumber | string | - | max:11 | 電話番号 |
| email | string | - | max:50, Email | メールアドレス |
| sex | string | - | - | 性別 |
| status | string | - | - | 状態 |
| roleIds | long[] | - | - | ロールIDリスト |
| postIds | long[] | - | - | 崗位IDリスト |
| remark | string | - | - | 備考 |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

---

#### 7. ユーザー削除

ユーザーを削除します（複数選択可）。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/remove` |
| 認証 | 必要 |
| 権限 | system:user:remove |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| ids | string | ○ | カンマ区切りのユーザーID |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

**レスポンス（エラー時）**

```json
{
  "code": 500,
  "msg": "当前用户不能删除"
}
```

---

#### 8. パスワードリセット

ユーザーのパスワードをリセットします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/resetPwd` |
| 認証 | 必要 |
| 権限 | system:user:resetPwd |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| userId | long | ○ | ユーザーID |
| loginName | string | ○ | ログインアカウント |
| password | string | ○ | 新しいパスワード |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

---

#### 9. ユーザー状態変更

ユーザーの状態（有効/無効）を変更します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/changeStatus` |
| 認証 | 必要 |
| 権限 | system:user:edit |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| userId | long | ○ | ユーザーID |
| status | string | ○ | 状態（0: 正常, 1: 停止） |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

---

#### 10. ユーザーエクスポート

ユーザー一覧をExcelファイルとしてエクスポートします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/export` |
| 認証 | 必要 |
| 権限 | system:user:export |

**リクエストボディ（フォームデータ）**

ユーザー一覧取得と同じ検索条件パラメータが使用可能です。

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "xxx.xlsx",
  "data": null
}
```

---

### ロール管理

#### 11. ロール一覧取得

ロール一覧をページネーション付きで取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/role/list` |
| 認証 | 必要 |
| 権限 | system:role:list |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| roleName | string | - | ロール名（部分一致） |
| roleKey | string | - | ロールキー（部分一致） |
| status | string | - | 状態 |
| pageNum | int | - | ページ番号 |
| pageSize | int | - | 1ページあたりの件数 |

**レスポンス（成功時）**

```json
{
  "total": 5,
  "rows": [
    {
      "roleId": 1,
      "roleName": "管理者",
      "roleKey": "admin",
      "roleSort": 1,
      "dataScope": "1",
      "status": "0",
      "createTime": "2024-01-01 00:00:00"
    }
  ],
  "code": 0,
  "msg": null
}
```

---

#### 12. ロール追加

新規ロールを追加します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/role/add` |
| 認証 | 必要 |
| 権限 | system:role:add |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| roleName | string | ○ | ロール名 |
| roleKey | string | ○ | ロールキー |
| roleSort | int | ○ | 表示順序 |
| status | string | - | 状態 |
| menuIds | long[] | - | メニューIDリスト |
| remark | string | - | 備考 |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

---

### メニュー管理

#### 13. メニュー一覧取得

メニュー一覧を取得します（ツリー構造）。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/menu/list` |
| 認証 | 必要 |
| 権限 | system:menu:list |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| menuName | string | - | メニュー名（部分一致） |
| visible | string | - | 表示状態 |

**レスポンス（成功時）**

```json
[
  {
    "menuId": 1,
    "menuName": "システム管理",
    "parentId": 0,
    "orderNum": 1,
    "url": "#",
    "menuType": "M",
    "visible": "0",
    "perms": "",
    "icon": "fa fa-gear",
    "children": []
  }
]
```

---

#### 14. メニュー追加

新規メニューを追加します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/menu/add` |
| 認証 | 必要 |
| 権限 | system:menu:add |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| menuName | string | ○ | メニュー名 |
| parentId | long | ○ | 親メニューID |
| orderNum | int | ○ | 表示順序 |
| url | string | - | URL |
| menuType | string | ○ | タイプ（M: ディレクトリ, C: メニュー, F: ボタン） |
| visible | string | - | 表示状態（0: 表示, 1: 非表示） |
| perms | string | - | 権限識別子 |
| icon | string | - | アイコン |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

---

### 部門管理

#### 15. 部門一覧取得

部門一覧を取得します（ツリー構造）。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/dept/list` |
| 認証 | 必要 |
| 権限 | system:dept:list |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| deptName | string | - | 部門名（部分一致） |
| status | string | - | 状態 |

**レスポンス（成功時）**

```json
[
  {
    "deptId": 100,
    "parentId": 0,
    "deptName": "本社",
    "orderNum": 0,
    "leader": "管理者",
    "phone": "12345678901",
    "email": "admin@example.com",
    "status": "0",
    "children": []
  }
]
```

---

### 定時タスク

#### 16. ジョブ一覧取得

定時タスク一覧をページネーション付きで取得します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /monitor/job/list` |
| 認証 | 必要 |
| 権限 | monitor:job:list |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobName | string | - | ジョブ名（部分一致） |
| jobGroup | string | - | ジョブグループ |
| status | string | - | 状態 |
| pageNum | int | - | ページ番号 |
| pageSize | int | - | 1ページあたりの件数 |

**レスポンス（成功時）**

```json
{
  "total": 3,
  "rows": [
    {
      "jobId": 1,
      "jobName": "システムタスク",
      "jobGroup": "DEFAULT",
      "invokeTarget": "ryTask.ryNoParams",
      "cronExpression": "0/10 * * * * ?",
      "misfirePolicy": "3",
      "concurrent": "1",
      "status": "1",
      "createTime": "2024-01-01 00:00:00"
    }
  ],
  "code": 0,
  "msg": null
}
```

---

#### 17. ジョブ追加

新規定時タスクを追加します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /monitor/job/add` |
| 認証 | 必要 |
| 権限 | monitor:job:add |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobName | string | ○ | ジョブ名 |
| jobGroup | string | ○ | ジョブグループ |
| invokeTarget | string | ○ | 呼び出し対象文字列 |
| cronExpression | string | ○ | Cron式 |
| misfirePolicy | string | - | ミスファイアポリシー |
| concurrent | string | - | 並行実行（0: 許可, 1: 禁止） |
| status | string | - | 状態（0: 正常, 1: 停止） |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

**レスポンス（エラー時）**

```json
{
  "code": 500,
  "msg": "新增任务'xxx'失败，Cron表达式不正确"
}
```

---

#### 18. ジョブ即時実行

定時タスクを即時実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /monitor/job/run` |
| 認証 | 必要 |
| 権限 | monitor:job:changeStatus |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| jobId | long | ○ | ジョブID |
| jobGroup | string | ○ | ジョブグループ |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

---

### 共通機能

#### 19. ファイルアップロード（単一）

単一ファイルをアップロードします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /common/upload` |
| 認証 | 必要 |
| 権限 | なし |

**リクエスト**

Content-Type: `multipart/form-data`

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| file | file | ○ | アップロードするファイル |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功",
  "url": "http://localhost/profile/upload/xxx.png",
  "fileName": "/profile/upload/xxx.png",
  "newFileName": "xxx.png",
  "originalFilename": "original.png"
}
```

---

#### 20. ファイルダウンロード

ファイルをダウンロードします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `GET /common/download` |
| 認証 | 必要 |
| 権限 | なし |

**クエリパラメータ**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| fileName | string | ○ | ファイル名 |
| delete | boolean | - | ダウンロード後に削除するか |

**レスポンス（成功時）**

Content-Type: `application/octet-stream`

ファイルバイナリデータが返されます。

---

### 個人情報

#### 21. プロファイル更新

ログインユーザーの個人情報を更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/profile/update` |
| 認証 | 必要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| userName | string | - | ユーザー名 |
| email | string | - | メールアドレス |
| phonenumber | string | - | 電話番号 |
| sex | string | - | 性別 |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

---

#### 22. パスワード変更

ログインユーザーのパスワードを変更します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/profile/resetPwd` |
| 認証 | 必要 |
| 権限 | なし |

**リクエストボディ（フォームデータ）**

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| oldPassword | string | ○ | 現在のパスワード |
| newPassword | string | ○ | 新しいパスワード |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

**レスポンス（エラー時）**

```json
{
  "code": 500,
  "msg": "修改密码失败，旧密码错误"
}
```

---

#### 23. アバター更新

ログインユーザーのアバター画像を更新します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| エンドポイント | `POST /system/user/profile/updateAvatar` |
| 認証 | 必要 |
| 権限 | なし |

**リクエスト**

Content-Type: `multipart/form-data`

| パラメータ名 | 型 | 必須 | 説明 |
| --- | --- | --- | --- |
| avatarfile | file | ○ | アバター画像ファイル |

**レスポンス（成功時）**

```json
{
  "code": 0,
  "msg": "操作成功"
}
```

---

## 備考

### 権限について

各APIエンドポイントには`@RequiresPermissions`アノテーションによる権限チェックが設定されています。権限がない場合は、未認証エラーが返されます。

### データスコープについて

ユーザー、部門、ロールの各管理機能では、データスコープによるアクセス制御が実装されています。管理者以外のユーザーは、自分に割り当てられたデータスコープ内のデータのみ操作できます。

### ログについて

`@Log`アノテーションが付与されたエンドポイントは、操作ログ（sys_oper_log）に記録されます。

### XSS対策

ユーザー入力項目には`@Xss`アノテーションによるXSS対策が実装されています。
