---
generated_at: 2026-01-08 15:10:00
metrics:
  claims_total: 46
  claims_with_evidence: 44
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：44 / 46、根拠なし：2
- 優先レビュー（高）
  1. **ベースURL（デフォルトポート80）**：設定ファイルの確認が必要
  2. **Remember Me機能のデフォルト設定**：環境依存の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java`
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-04: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java`
- E-06: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java`
- E-07: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java`
- E-08: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java`
- E-09: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-10: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-11: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java`
- E-12: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysCaptchaController.java`
- E-13: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java`
- E-14: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java`
- E-15: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java`
- E-16: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java`
- E-17: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/CacheController.java`
- E-18: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/common/CommonController.java`
- E-19: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-20: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java`
- E-21: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-22: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java`
- E-23: `ruoyi-common/src/main/java/com/ruoyi/common/core/page/TableDataInfo.java`
- E-24: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 認証方式はApache Shiroセッションベース認証 | E-01（@Value shiro.rememberMe.enabled, UsernamePasswordToken） | ○ |
| C-02 | AjaxResultのcode値（0: 成功, 301: 警告, 500: エラー） | E-22（Type enum定義） | ○ |
| C-03 | TableDataInfoのレスポンス形式 | E-23（total, rows, code, msg フィールド） | ○ |
| C-04 | POST /login エンドポイント | E-01（@PostMapping("/login")） | ○ |
| C-05 | POST /register エンドポイント | E-13（@PostMapping("/register")） | ○ |
| C-06 | GET /captcha/captchaImage エンドポイント | E-12（@GetMapping("/captchaImage")） | ○ |
| C-07 | POST /system/user/list エンドポイント | E-02（@PostMapping("/list")） | ○ |
| C-08 | POST /system/user/add エンドポイント | E-02（@PostMapping("/add")） | ○ |
| C-09 | POST /system/user/edit エンドポイント | E-02（@PostMapping("/edit")） | ○ |
| C-10 | POST /system/user/remove エンドポイント | E-02（@PostMapping("/remove")） | ○ |
| C-11 | POST /system/user/resetPwd エンドポイント | E-02（@PostMapping("/resetPwd")） | ○ |
| C-12 | POST /system/user/changeStatus エンドポイント | E-02（@PostMapping("/changeStatus")） | ○ |
| C-13 | POST /system/user/export エンドポイント | E-02（@PostMapping("/export")） | ○ |
| C-14 | POST /system/user/importData エンドポイント | E-02（@PostMapping("/importData")） | ○ |
| C-15 | ユーザーのバリデーションルール | E-24（@NotBlank, @Size, @Email, @Xssアノテーション） | ○ |
| C-16 | POST /system/role/list エンドポイント | E-03（@PostMapping("/list")） | ○ |
| C-17 | POST /system/role/add エンドポイント | E-03（@PostMapping("/add")） | ○ |
| C-18 | POST /system/role/edit エンドポイント | E-03（@PostMapping("/edit")） | ○ |
| C-19 | POST /system/role/remove エンドポイント | E-03（@PostMapping("/remove")） | ○ |
| C-20 | POST /system/menu/list エンドポイント | E-04（@PostMapping("/list")） | ○ |
| C-21 | POST /system/menu/add エンドポイント | E-04（@PostMapping("/add")） | ○ |
| C-22 | POST /system/menu/edit エンドポイント | E-04（@PostMapping("/edit")） | ○ |
| C-23 | GET /system/menu/remove/{menuId} エンドポイント | E-04（@GetMapping("/remove/{menuId}")） | ○ |
| C-24 | POST /system/dept/list エンドポイント | E-05（@PostMapping("/list")） | ○ |
| C-25 | POST /system/dept/add エンドポイント | E-05（@PostMapping("/add")） | ○ |
| C-26 | POST /system/post/list エンドポイント | E-06（@PostMapping("/list")） | ○ |
| C-27 | POST /system/post/add エンドポイント | E-06（@PostMapping("/add")） | ○ |
| C-28 | POST /system/dict/list エンドポイント | E-07（@PostMapping("/list")） | ○ |
| C-29 | POST /system/dict/data/list エンドポイント | E-08（@PostMapping("/list")） | ○ |
| C-30 | POST /system/config/list エンドポイント | E-09（@PostMapping("/list")） | ○ |
| C-31 | POST /system/notice/list エンドポイント | E-10（@PostMapping("/list")） | ○ |
| C-32 | POST /monitor/logininfor/list エンドポイント | E-14（@PostMapping("/list")） | ○ |
| C-33 | POST /monitor/logininfor/unlock エンドポイント | E-14（@PostMapping("/unlock")） | ○ |
| C-34 | POST /monitor/operlog/list エンドポイント | E-15（@PostMapping("/list")） | ○ |
| C-35 | POST /monitor/online/list エンドポイント | E-16（@PostMapping("/list")） | ○ |
| C-36 | POST /monitor/online/batchForceLogout エンドポイント | E-16（@PostMapping("/batchForceLogout")） | ○ |
| C-37 | POST /monitor/cache/getNames エンドポイント | E-17（@PostMapping("/getNames")） | ○ |
| C-38 | POST /monitor/job/list エンドポイント | E-19（@PostMapping("/list")） | ○ |
| C-39 | POST /monitor/job/add エンドポイント | E-19（@PostMapping("/add")） | ○ |
| C-40 | POST /monitor/job/run エンドポイント | E-19（@PostMapping("/run")） | ○ |
| C-41 | POST /tool/gen/list エンドポイント | E-21（@PostMapping("/list")） | ○ |
| C-42 | POST /common/upload エンドポイント | E-18（@PostMapping("/upload")） | ○ |
| C-43 | GET /common/download エンドポイント | E-18（@GetMapping("/download")） | ○ |
| C-44 | POST /system/user/profile/update エンドポイント | E-11（@PostMapping("/update")） | ○ |
| C-45 | ベースURLのデフォルトポート80 | **根拠なし** | △ |
| C-46 | Remember Me機能のデフォルト設定がfalse | E-01（@Value default: false） | ○ |

## 4) 不足情報（Unknown / Missing）
- **ベースURLのデフォルトポート設定**：application.yml/propertiesファイルで確認が必要
  - 候補：`ruoyi-admin/src/main/resources/application.yml` / `application.properties`
- **環境固有の設定値**：本番環境では異なる可能性があるため要確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: APIエンドポイント定義 - コントローラーのアノテーションから直接確認済み
- **0（低リスク）**: レスポンス形式 - AjaxResult/TableDataInfoクラスから確認済み
- **1（中リスク）**: バリデーションルール - エンティティのアノテーションから抽出したが、一部カスタムバリデーションが存在する可能性
- **1（中リスク）**: 権限設定 - @RequiresPermissionsから抽出したが、実際の権限マスターデータとの整合性は要確認
- **0（低リスク）**: 認証方式 - Apache Shiroの使用はコードから明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ベースURLとポート番号が運用環境と一致しているか
- [ ] 各APIの権限識別子が実際のシステム設定と一致しているか
- [ ] バリデーションルールが業務要件を満たしているか
- [ ] エラーメッセージが日本語/多言語対応の要件を満たしているか（現状は中国語）
- [ ] 記載されていないAPIエンドポイントがないか（デモ用コントローラーは除外済み）
- [ ] セキュリティ要件（HTTPS、CSRF対策等）の記載が必要か検討
