# RuoYi 若依管理システム

## 概要

RuoYi（若依）は、Spring Bootをベースとした軽量なJava Webアプリケーション開発フレームワークです。企業向けの管理システム、会員管理センター、CMS、CRM、OAシステムなど、様々なWebアプリケーションの基盤として利用できます。バージョン4.8.2を使用しており、ユーザー管理、権限管理、ログ監視、コード生成など、多数の内蔵機能を提供しています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ユーザー管理 | システムユーザーの設定と管理 |
| 部門管理 | 組織構造（会社、部門、グループ）の管理、ツリー構造表示、データ権限対応 |
| 岗位管理 | ユーザーの職務・役職の設定 |
| メニュー管理 | システムメニュー、操作権限、ボタン権限の設定 |
| 角色管理 | 役割ベースのメニュー権限割り当て、データ範囲の権限設定 |
| 辞書管理 | システム内で頻繁に使用する固定データの管理 |
| パラメータ管理 | システムの動的パラメータ設定 |
| 通知・公告 | システム通知・公告の発行と管理 |
| 操作ログ | 正常操作と異常操作のログ記録・照会 |
| ログインログ | ログイン履歴と異常ログインの記録・照会 |
| オンラインユーザー | 現在のアクティブユーザー状態の監視 |
| 定時タスク | Quartzベースのタスクスケジューリング管理 |
| コード生成 | フロントエンド・バックエンドコードの自動生成（Java、HTML、XML、SQL） |
| システムAPI | Swagger3による自動API文書生成 |
| サーバー監視 | CPU、メモリ、ディスク、スタック情報の監視 |
| キャッシュ監視 | EhCacheキャッシュの照会・削除・クリア操作 |
| オンラインビルダー | フォーム要素をドラッグ&ドロップでHTMLコード生成 |
| 接続プール監視 | Druidによるデータベース接続プールの状態監視とSQL分析 |

## 技術スタック

### コア

- フレームワーク: Spring Boot 2.5.15
- 言語: Java 1.8
- テンプレートエンジン: Thymeleaf
- データベース: MySQL
- 接続プール: Alibaba Druid 1.2.27
- ORM: MyBatis + PageHelper
- セキュリティ: Apache Shiro 1.13.0
- スケジューラー: Quartz

### 主要ライブラリ

- Spring Framework 5.3.39
- Swagger3 (SpringFox 3.0.0) - API文書生成
- EhCache - キャッシュ管理
- Kaptcha 2.3.3 - 認証コード生成
- Apache POI 4.1.2 - Excel処理
- Velocity 2.3 - コード生成テンプレート
- FastJSON 1.2.83 - JSON解析
- OSHI 6.9.1 - システム情報取得
- Yauaa 7.32.0 - ユーザーエージェント解析
- Logback 1.2.13 - ログ管理

## ディレクトリ構成

```
RuoYi-master/
├── ruoyi-admin/          # Webサービスエントリーモジュール（メインアプリケーション）
│   └── src/main/
│       ├── java/         # コントローラー、設定クラス
│       └── resources/    # 設定ファイル、テンプレート、静的リソース
├── ruoyi-common/         # 共通ユーティリティモジュール
│   └── src/main/java/    # 共通クラス、アノテーション、例外、ユーティリティ
├── ruoyi-framework/      # フレームワークコアモジュール
│   └── src/main/java/    # Shiro設定、AOP、インターセプター
├── ruoyi-system/         # システム業務モジュール
│   └── src/main/java/    # サービス、マッパー、ドメイン
├── ruoyi-quartz/         # 定時タスクモジュール
│   └── src/main/java/    # Quartzジョブ、タスク管理
├── ruoyi-generator/      # コード生成モジュール
│   └── src/main/         # コード生成ロジック、テンプレート
├── sql/                  # データベーススクリプト
│   ├── ry_20250416.sql   # 業務テーブル初期化SQL
│   └── quartz.sql        # Quartzテーブル初期化SQL
├── doc/                  # ドキュメント
├── bin/                  # ビルド・起動スクリプト
├── pom.xml               # Maven親POM
└── ry.sh / ry.bat        # 起動スクリプト（Linux/Windows）
```

## セットアップ

### 必要条件

- JDK 1.8以上
- Maven 3.x
- MySQL 5.7以上

### データベース設定

1. MySQLでデータベース`ry`を作成

   ```sql
   CREATE DATABASE ry DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
   ```

2. SQLスクリプトを実行

   ```bash
   mysql -u root -p ry < sql/ry_20250416.sql
   mysql -u root -p ry < sql/quartz.sql
   ```

3. `ruoyi-admin/src/main/resources/application-druid.yml`のデータベース接続情報を編集

   ```yaml
   spring:
     datasource:
       druid:
         master:
           url: jdbc:mysql://localhost:3306/ry?useUnicode=true&characterEncoding=utf8&zeroDateTimeBehavior=convertToNull&useSSL=true&serverTimezone=GMT%2B8
           username: root
           password: your_password
   ```

### インストール手順

1. プロジェクトをクローン

2. 依存関係をインストール

   ```bash
   mvn clean install
   ```

3. アプリケーションを起動

   ```bash
   # Linuxの場合
   ./ry.sh start

   # Windowsの場合
   ry.bat start

   # または直接起動
   cd ruoyi-admin
   mvn spring-boot:run
   ```

4. ブラウザでアクセス

   - URL: http://localhost:80
   - デフォルトログイン: admin / admin123

## 開発

### ビルドコマンド

```bash
# クリーンビルド
mvn clean package

# 単体テストをスキップしてビルド
mvn clean package -DskipTests

# 特定モジュールのビルド
mvn clean package -pl ruoyi-admin -am
```

### 開発モード

Spring Boot DevToolsが有効化されており、ホットデプロイをサポートしています。

```yaml
# application.ymlで設定
spring:
  devtools:
    restart:
      enabled: true
```

### Swagger API文書

- Swaggerが有効な場合、以下のURLでAPI文書にアクセス可能
- URL: http://localhost:80/swagger-ui/index.html

### Druid監視

- データベース接続プールの監視画面
- URL: http://localhost:80/druid
- デフォルトログイン: ruoyi / 123456

### コード生成

1. 管理画面からコード生成機能にアクセス
2. データベーステーブルを選択
3. 生成設定を調整
4. Java、HTML、XML、SQLコードを自動生成

### 設定ファイル

| ファイル | 説明 |
| --- | --- |
| `application.yml` | メイン設定ファイル |
| `application-druid.yml` | データソース設定 |
| `mybatis-config.xml` | MyBatis設定 |
| `logback.xml` | ログ設定 |
| `ehcache.xml` | キャッシュ設定 |
