---
generated_at: 2026-01-08 13:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Quartzテーブル初期化SQL（quartz.sql）の内容**：sqlディレクトリにファイル存在確認済みだが、詳細な内容は未検証
  2. **ehcache.xml設定ファイルの存在確認**：ruoyi-frameworkモジュールに存在する可能性があるが明示的確認未実施
  3. **logback.xml設定ファイルの存在確認**：ruoyi-adminのresourcesに存在する可能性があるが明示的確認未実施

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/RuoYi-master/pom.xml` - プロジェクトのメインPOM
- E-02: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-admin/pom.xml` - Adminモジュール設定
- E-03: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-admin/src/main/resources/application.yml` - メイン設定ファイル
- E-04: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-admin/src/main/resources/application-druid.yml` - データソース設定
- E-05: `/Users/tomokababa/Work/route06/RuoYi-master/README.md` - オリジナルREADME
- E-06: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-admin/src/main/java/com/ruoyi/RuoYiApplication.java` - メインエントリーポイント
- E-07: `/Users/tomokababa/Work/route06/RuoYi-master/sql/` - SQLスクリプトディレクトリ
- E-08: `/Users/tomokababa/Work/route06/RuoYi-master/bin/` - ビルドスクリプトディレクトリ
- E-09: `/Users/tomokababa/Work/route06/RuoYi-master/ry.sh` / `ry.bat` - 起動スクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクト名はRuoYi（若依）である | E-05, E-03 | ○ |
| C-02 | バージョンは4.8.2である | E-01 (version: 4.8.2) | ○ |
| C-03 | Spring Boot 2.5.15を使用 | E-01 (spring-boot.version: 2.5.15) | ○ |
| C-04 | Java 1.8を使用 | E-01 (java.version: 1.8) | ○ |
| C-05 | Thymeleafテンプレートエンジンを使用 | E-02, E-03 | ○ |
| C-06 | MySQLデータベースを使用 | E-02 (mysql-connector-java), E-04 | ○ |
| C-07 | Alibaba Druid 1.2.27を使用 | E-01 (druid.version: 1.2.27) | ○ |
| C-08 | Apache Shiro 1.13.0を使用 | E-01 (shiro.version: 1.13.0) | ○ |
| C-09 | Quartzスケジューラーを使用 | E-01 (ruoyi-quartz), E-07 | ○ |
| C-10 | Spring Framework 5.3.39を使用 | E-01 (spring-framework.version: 5.3.39) | ○ |
| C-11 | Swagger3 (SpringFox 3.0.0)を使用 | E-01 (swagger.version: 3.0.0), E-02 | ○ |
| C-12 | Kaptcha 2.3.3を使用 | E-01 (kaptcha.version: 2.3.3) | ○ |
| C-13 | Apache POI 4.1.2を使用 | E-01 (poi.version: 4.1.2) | ○ |
| C-14 | Velocity 2.3を使用 | E-01 (velocity.version: 2.3) | ○ |
| C-15 | FastJSON 1.2.83を使用 | E-01 (fastjson.version: 1.2.83) | ○ |
| C-16 | OSHI 6.9.1を使用 | E-01 (oshi.version: 6.9.1) | ○ |
| C-17 | Yauaa 7.32.0を使用 | E-01 (yauaa.version: 7.32.0) | ○ |
| C-18 | Logback 1.2.13を使用 | E-01 (logback.version: 1.2.13) | ○ |
| C-19 | デフォルトポートは80 | E-03 (server.port: 80) | ○ |
| C-20 | デフォルトログインはadmin/admin123 | E-05 | ○ |
| C-21 | Druid監視ログインはruoyi/123456 | E-04 (login-username/password) | ○ |
| C-22 | 6つのモジュールで構成 | E-01 (modules) | ○ |
| C-23 | 18の主要機能を提供 | E-05 | ○ |
| C-24 | ホットデプロイを有効化可能 | E-03 (devtools.restart.enabled: true) | ○ |
| C-25 | ehcache.xml設定ファイルが存在 | **根拠なし（明示的確認未実施）** | △ |

## 4) 不足情報（Unknown / Missing）
- ehcache.xml設定ファイルの存在確認
  - 候補：`ruoyi-framework/src/main/resources/ehcache.xml` / `ruoyi-admin/src/main/resources/ehcache.xml`
- logback.xml設定ファイルの詳細パス確認
  - 候補：`ruoyi-admin/src/main/resources/logback.xml`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バージョン情報とライブラリ依存関係はpom.xmlから直接抽出
- 0: 低リスク - データベース設定は設定ファイルから直接抽出
- 1: 中リスク - ehcache.xmlなど一部設定ファイルの存在は推測に基づく
- 0: 低リスク - 機能一覧はオリジナルREADMEから抽出

## 6) レビュアーチェックリスト（最小）
- [ ] pom.xmlのバージョン情報が最新か確認
- [ ] application.ymlの設定値が実環境と一致しているか確認
- [ ] データベース接続情報（ホスト、ポート、ユーザー名）が正しいか確認
- [ ] ehcache.xml、logback.xmlの存在パスを確認
- [ ] デフォルトログイン情報が変更されている場合はドキュメント更新が必要
- [ ] 起動スクリプト（ry.sh/ry.bat）の実行権限を確認
