---
generated_at: 2026-01-08 17:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **ドキュメント参照順序の推奨順**：プロジェクト固有の推奨がない
  2. **デバッグヒント**：実運用での検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pom.xml` - Maven設定、バージョン情報
- E-02: `README.md` - プロジェクト概要
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/RuoYiApplication.java` - エントリーポイント
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` - ユーザーエンティティ
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザーController
- E-06: `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` - ユーザーServiceインターフェース
- E-07: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java` - ユーザーService実装
- E-08: `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserMapper.java` - ユーザーMapper
- E-09: `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` - ユーザーMapper XML
- E-10: `ruoyi-common/src/main/java/com/ruoyi/common/core/controller/BaseController.java` - 基底Controller
- E-11: `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Log.java` - Logアノテーション
- E-12: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java` - LogAspect
- E-13: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/realm/UserRealm.java` - Shiro Realm
- E-14: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/ShiroConfig.java` - Shiro設定
- E-15: `ruoyi-admin/src/main/resources/application.yml` - アプリケーション設定
- E-16: `ruoyi-common/src/main/java/com/ruoyi/common/enums/BusinessType.java` - 業務タイプ列挙

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトバージョンは4.8.2 | E-01:8行目 | ○ |
| C-02 | Java 1.8を使用 | E-01:18行目 | ○ |
| C-03 | Spring Boot 2.5.15を使用 | E-01:20行目 | ○ |
| C-04 | Apache Shiro 1.13.0を使用 | E-01:21行目 | ○ |
| C-05 | Thymeleafテンプレートエンジンを使用 | E-01:22行目, E-15:49-53行目 | ○ |
| C-06 | MyBatis ORMを使用 | E-01, E-15:77-83行目 | ○ |
| C-07 | エントリーポイントはRuoYiApplication | E-03:12-29行目 | ○ |
| C-08 | SysUserエンティティの構造 | E-04:22-104行目 | ○ |
| C-09 | @RequiresPermissions権限形式 | E-05:64-69行目 | ○ |
| C-10 | @Logアノテーションの構造 | E-11:19-50行目 | ○ |
| C-11 | @DataScopeアノテーション使用 | E-07:81行目 | ○ |
| C-12 | BaseControllerの継承パターン | E-10:33-229行目 | ○ |
| C-13 | Controller命名規則（*Controller.java） | E-05 | ○ |
| C-14 | Service命名規則（I*Service/Impl） | E-06, E-07 | ○ |
| C-15 | Mapper命名規則（*Mapper.java/xml） | E-08, E-09 | ○ |
| C-16 | selectメソッド命名規則 | E-06:21-69行目 | ○ |
| C-17 | insert/update/deleteメソッド命名規則 | E-06:85-118行目 | ○ |
| C-18 | ruoyi-adminモジュールの役割 | E-03, E-05 | ○ |
| C-19 | ruoyi-commonモジュールの役割 | E-04, E-10, E-11 | ○ |
| C-20 | ruoyi-frameworkモジュールの役割 | E-12, E-13, E-14 | ○ |
| C-21 | ruoyi-systemモジュールの役割 | E-06, E-07, E-08 | ○ |
| C-22 | レイヤードアーキテクチャ | E-05, E-07, E-08 | ○ |
| C-23 | Controller→Service→Mapper呼び出しフロー | E-05:71-79行目 | ○ |
| C-24 | @Transactionalトランザクション管理 | E-07:220行目 | ○ |
| C-25 | AOPによるログ記録 | E-12:67-71行目 | ○ |
| C-26 | Shiro認可処理 | E-13:56-81行目 | ○ |
| C-27 | MyBatis XMLマッピング構造 | E-09:62-89行目 | ○ |
| C-28 | ユーザー追加処理フロー | E-05:127-153行目, E-07:218-230行目 | ○ |
| C-29 | パスワード暗号化処理 | E-05:148-150行目 | ○ |
| C-30 | 関連テーブル一括登録 | E-07:218-230行目 | ○ |
| C-31 | insertUserPost/insertUserRole処理 | E-07:336-380行目 | ○ |
| C-32 | startPage()ページング | E-10:57-60行目 | ○ |
| C-33 | getDataTable()レスポンス生成 | E-10:110-118行目 | ○ |
| C-34 | ShiroUtils使用例 | E-05:148-151行目 | ○ |
| C-35 | StringUtils使用例 | E-05:140行目 | ○ |
| C-36 | BusinessType列挙 | E-16:9-59行目 | ○ |
| C-37 | application.yml設定構造 | E-15:1-150行目 | ○ |
| C-38 | Shiro設定項目 | E-15:92-128行目 | ○ |
| C-39 | XSS防止設定 | E-15:131-137行目 | ○ |
| C-40 | CSRF防止設定 | E-15:140-144行目 | ○ |
| C-41 | 6モジュール構成 | E-01:236-242行目 | ○ |
| C-42 | sys_userテーブル構造 | E-09:7-31行目 | ○ |
| C-43 | 権限フォーマット「モジュール:エンティティ:操作」 | E-05:64,71,81行目 | ○ |
| C-44 | ドキュメント参照推奨順 | **根拠なし** | △ |
| C-45 | デバッグヒント | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **ドキュメント参照推奨順（C-44）**
  - プロジェクト固有のオンボーディングガイドが存在しない
  - 候補：CONTRIBUTING.md / 開発者ガイド / Wiki
- **デバッグヒント（C-45）**
  - 実運用での検証結果がない
  - 候補：運用マニュアル / トラブルシューティングガイド / ログ設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 技術スタック情報（C-01〜C-06）- pom.xmlから直接取得
- **0（低リスク）**: コード構造説明（C-07〜C-43）- ソースコードから直接取得
- **1（中リスク）**: 推奨順序・ヒント（C-44〜C-45）- 主観的な推奨、検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] コード例のファイルパスと行番号が正確か確認
- [ ] 命名規則が実際のコードベースと一致しているか確認
- [ ] アーキテクチャ図がプロジェクト構造を正確に反映しているか確認
- [ ] 業務フロー追跡例が実際の処理フローと一致しているか確認
- [ ] 参考資料のURLが有効か確認
- [ ] プロジェクト固有の用語が正確に説明されているか確認
