---
generated_at: 2026-01-08 15:50:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **サーバースペック推奨値**：明示的な根拠なし（業界標準に基づく推定）
  2. **バックアップ頻度・保持期間**：設定ファイルに明示されていない
  3. **推奨外部監視ツール**：プロジェクト固有の指定なし
  4. **スケールアウト対応の拡張方針**：コードベースには記載なし（一般的な推奨事項）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pom.xml` - プロジェクト全体のMaven設定、依存関係、バージョン情報
- E-02: `ruoyi-admin/src/main/resources/application.yml` - アプリケーション設定（サーバー、Spring、Shiro等）
- E-03: `ruoyi-admin/src/main/resources/application-druid.yml` - Druidデータソース設定
- E-04: `ruoyi-admin/src/main/resources/logback.xml` - ログ設定
- E-05: `ruoyi-admin/src/main/resources/ehcache/ehcache-shiro.xml` - EhCacheキャッシュ設定
- E-06: `ruoyi-admin/src/main/resources/mybatis/mybatis-config.xml` - MyBatis設定
- E-07: `ruoyi-admin/pom.xml` - adminモジュール依存関係
- E-08: `ruoyi-framework/pom.xml` - frameworkモジュール依存関係
- E-09: `ry.sh` - 起動スクリプト、JVMパラメータ
- E-10: `sql/ry_20250416.sql` - データベーススキーマ定義
- E-11: `README.md` - プロジェクト説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Spring Boot 2.5.15を使用 | E-01 (spring-boot.version=2.5.15) | ○ |
| C-02 | Java 8 (1.8)を使用 | E-01 (java.version=1.8) | ○ |
| C-03 | 内蔵Tomcat 9.0.112を使用 | E-01 (tomcat.version=9.0.112) | ○ |
| C-04 | HTTPポート80で動作 | E-02 (server.port=80) | ○ |
| C-05 | コンテキストパスは / | E-02 (server.servlet.context-path=/) | ○ |
| C-06 | Tomcat最大スレッド数800 | E-02 (server.tomcat.threads.max=800) | ○ |
| C-07 | Tomcat初期スレッド数100 | E-02 (server.tomcat.threads.min-spare=100) | ○ |
| C-08 | Tomcat接続待ちキュー1000 | E-02 (server.tomcat.accept-count=1000) | ○ |
| C-09 | MySQLデータベース使用 | E-03 (driverClassName=com.mysql.cj.jdbc.Driver) | ○ |
| C-10 | Druid 1.2.27を使用 | E-01 (druid.version=1.2.27) | ○ |
| C-11 | Druid初期接続数5 | E-03 (initialSize=5) | ○ |
| C-12 | Druid最小アイドル10 | E-03 (minIdle=10) | ○ |
| C-13 | Druid最大接続20 | E-03 (maxActive=20) | ○ |
| C-14 | Apache Shiro 1.13.0を使用 | E-01 (shiro.version=1.13.0) | ○ |
| C-15 | セッションタイムアウト30分 | E-02 (shiro.session.expireTime=30) | ○ |
| C-16 | パスワード5回失敗でロック | E-02 (user.password.maxRetryCount=5) | ○ |
| C-17 | ログ保持期間60日 | E-04 (maxHistory=60) | ○ |
| C-18 | ログ出力先/home/ruoyi/logs | E-04 (log.path=/home/ruoyi/logs) | ○ |
| C-19 | EhCacheをキャッシュに使用 | E-05 (ehcache設定ファイル存在) | ○ |
| C-20 | ログインキャッシュTTL 600秒 | E-05 (loginRecordCache.timeToIdleSeconds=600) | ○ |
| C-21 | XSS対策有効 | E-02 (xss.enabled=true) | ○ |
| C-22 | Cookie HttpOnly有効 | E-02 (shiro.cookie.httpOnly=true) | ○ |
| C-23 | CAPTCHA有効（数式方式） | E-02 (shiro.user.captchaType=math) | ○ |
| C-24 | Swagger 3.0.0を使用 | E-01 (swagger.version=3.0.0), E-07 | ○ |
| C-25 | JVM初期ヒープ512MB | E-09 (-Xms512m) | ○ |
| C-26 | JVM最大ヒープ1024MB | E-09 (-Xmx1024m) | ○ |
| C-27 | スレーブDB設定が存在（デフォルト無効） | E-03 (slave.enabled=false) | ○ |
| C-28 | Druidスロークエリ記録1秒以上 | E-03 (slow-sql-millis=1000) | ○ |
| C-29 | サーバー推奨スペック（CPU 2コア、メモリ2GB以上） | **根拠なし** | △ |
| C-30 | バックアップ頻度・保持期間（日次推奨、60日等） | **根拠なし**（ログ以外は設定なし） | △ |
| C-31 | 推奨外部監視ツール（Prometheus、ELK等） | **根拠なし**（一般的推奨） | △ |
| C-32 | スケールアウト時のRedis移行等の推奨 | **根拠なし**（一般的推奨） | △ |

## 4) 不足情報（Unknown / Missing）
- **Docker/Kubernetes設定ファイル**: プロジェクトに存在しない（コンテナ化は未対応）
- **Terraform/CloudFormation**: クラウドインフラ定義なし
- **nginx.conf等**: 外部リバースプロキシ設定なし（内蔵Tomcat直接利用を想定）
- **本番環境用スペック定義**: 明示的な要件定義書なし
- **バックアップポリシー文書**: プロジェクト内に存在しない

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: ミドルウェアバージョン、ポート設定、キャッシュ設定など（設定ファイルから直接確認可能）
- **1: 中リスク**: サーバースペック推奨値、JVMチューニング値（実運用での検証が必要）
- **2: 高リスク**: バックアップ設計、可用性設計の推奨構成（組織のポリシーと要件に依存、要カスタマイズ）

## 6) レビュアーチェックリスト（最小）
- [ ] サーバースペック推奨値が組織の標準・要件に適合しているか確認
- [ ] バックアップ設計が組織のポリシーに適合しているか確認
- [ ] 本番環境での可用性要件を確認し、推奨構成の採用可否を判断
- [ ] セキュリティ設定（CSRF無効等）が許容範囲か確認
- [ ] ログ出力先パスが実環境で使用可能か確認
- [ ] ファイルアップロードパス（D:/ruoyi/uploadPath）が実環境に適切か確認
- [ ] Druid監視画面のデフォルトパスワード（123456）の変更を検討
