# インフラ構成図

## 概要

本ドキュメントは、RuoYi管理システム（若依管理系統）v4.8.2のインフラ構成図をMermaid形式で記載する。

## システム全体構成図

```mermaid
flowchart TB
    subgraph Client["クライアント層"]
        Browser["Webブラウザ"]
        Mobile["モバイルブラウザ"]
    end

    subgraph AP["アプリケーションサーバー"]
        subgraph Tomcat["組み込みTomcat (Port 80)"]
            SpringBoot["Spring Boot 2.5.15"]
            subgraph AppComponents["アプリケーションコンポーネント"]
                Controller["Controller層"]
                Service["Service層"]
                Mapper["Mapper層 (MyBatis)"]
            end
            subgraph Security["セキュリティ"]
                Shiro["Apache Shiro"]
                XSSFilter["XSSフィルター"]
            end
            subgraph Cache["キャッシュ"]
                EhCache["EhCache"]
            end
            subgraph Template["テンプレート"]
                Thymeleaf["Thymeleaf"]
            end
            subgraph Schedule["スケジューラー"]
                Quartz["Quartz"]
            end
            subgraph Monitoring["監視機能"]
                Druid["Druid監視"]
                ServerMonitor["サーバー監視"]
            end
        end
    end

    subgraph DB["データベースサーバー"]
        MySQL["MySQL 5.7+"]
        subgraph DBPool["コネクションプール"]
            DruidPool["Druid Pool<br/>初期:5 / 最小:10 / 最大:20"]
        end
    end

    subgraph Storage["ストレージ"]
        FileStorage["ファイルストレージ<br/>/home/ruoyi/uploadPath"]
        LogStorage["ログストレージ<br/>/home/ruoyi/logs"]
    end

    Browser --> |HTTP Port 80| Tomcat
    Mobile --> |HTTP Port 80| Tomcat
    Controller --> Service
    Service --> Mapper
    Mapper --> DruidPool
    DruidPool --> |JDBC Port 3306| MySQL
    Service --> FileStorage
    SpringBoot --> LogStorage
```

## アプリケーション内部構成図

```mermaid
flowchart LR
    subgraph Modules["Mavenモジュール構成"]
        Admin["ruoyi-admin<br/>(Web入口)"]
        Framework["ruoyi-framework<br/>(コアフレームワーク)"]
        System["ruoyi-system<br/>(システムモジュール)"]
        Quartz["ruoyi-quartz<br/>(定時タスク)"]
        Generator["ruoyi-generator<br/>(コード生成)"]
        Common["ruoyi-common<br/>(共通ユーティリティ)"]
    end

    Admin --> Framework
    Admin --> Quartz
    Admin --> Generator
    Framework --> System
    System --> Common
    Quartz --> Common
    Generator --> Common
```

## データフロー図

```mermaid
sequenceDiagram
    participant Browser as ブラウザ
    participant Shiro as Shiro認証
    participant Controller as Controller
    participant Service as Service
    participant Cache as EhCache
    participant Mapper as MyBatis
    participant Druid as Druid Pool
    participant MySQL as MySQL

    Browser->>Shiro: HTTPリクエスト
    Shiro->>Shiro: 認証・認可チェック
    Shiro->>Controller: 認可済みリクエスト
    Controller->>Service: ビジネスロジック呼び出し

    alt キャッシュヒット
        Service->>Cache: キャッシュ参照
        Cache-->>Service: キャッシュデータ
    else キャッシュミス
        Service->>Mapper: データ取得要求
        Mapper->>Druid: コネクション取得
        Druid->>MySQL: SQLクエリ
        MySQL-->>Druid: クエリ結果
        Druid-->>Mapper: コネクション返却
        Mapper-->>Service: エンティティ
        Service->>Cache: キャッシュ登録
    end

    Service-->>Controller: 処理結果
    Controller-->>Browser: HTTPレスポンス
```

## ネットワーク構成図

```mermaid
flowchart TB
    subgraph Internet["インターネット"]
        Users["ユーザー"]
    end

    subgraph DMZ["DMZ / 公開セグメント"]
        subgraph APServer["APサーバー"]
            Port80["Port 80<br/>(HTTP)"]
            PortDruid["Port 80<br/>(/druid/*)"]
            PortSwagger["Port 80<br/>(/swagger-ui/*)"]
        end
    end

    subgraph Internal["内部ネットワーク"]
        subgraph DBServer["DBサーバー"]
            Port3306["Port 3306<br/>(MySQL)"]
        end
    end

    Users --> |HTTP| Port80
    Users -.-> |監視アクセス| PortDruid
    Users -.-> |API仕様確認| PortSwagger
    APServer --> |JDBC| Port3306
```

## EhCacheキャッシュ構成図

```mermaid
flowchart TB
    subgraph EhCache["EhCacheキャッシュ構成"]
        subgraph SessionCache["セッションキャッシュ"]
            ActiveSession["shiro-activeSessionCache<br/>最大10,000件"]
            LoginRecord["loginRecordCache<br/>最大2,000件<br/>TTL: 600秒"]
        end

        subgraph UserCache["ユーザーキャッシュ"]
            SysUser["sys-userCache<br/>最大10,000件"]
            SysAuth["sys-authCache<br/>最大10,000件<br/>LRU"]
        end

        subgraph SystemCache["システムキャッシュ"]
            SysCache["sys-cache<br/>最大1,000件<br/>永続"]
            SysConfig["sys-config<br/>最大1,000件<br/>永続"]
            SysDict["sys-dict<br/>最大1,000件<br/>永続"]
        end
    end
```

## 推奨本番構成図

```mermaid
flowchart TB
    subgraph Client["クライアント"]
        Browser["ブラウザ"]
    end

    subgraph LB["ロードバランサー層"]
        LoadBalancer["ロードバランサー<br/>(Nginx / HAProxy)"]
    end

    subgraph APCluster["APサーバークラスター"]
        AP1["APサーバー #1<br/>Spring Boot"]
        AP2["APサーバー #2<br/>Spring Boot"]
        APn["APサーバー #N<br/>Spring Boot"]
    end

    subgraph CacheCluster["キャッシュクラスター"]
        Redis["Redis<br/>(セッション共有)"]
    end

    subgraph DBCluster["DBクラスター"]
        Master["MySQL Master<br/>(書き込み)"]
        Slave1["MySQL Slave #1<br/>(読み取り)"]
        Slave2["MySQL Slave #2<br/>(読み取り)"]
    end

    subgraph SharedStorage["共有ストレージ"]
        NFS["NFS / S3<br/>(ファイルストレージ)"]
    end

    Browser --> LoadBalancer
    LoadBalancer --> AP1
    LoadBalancer --> AP2
    LoadBalancer --> APn

    AP1 --> Redis
    AP2 --> Redis
    APn --> Redis

    AP1 --> Master
    AP2 --> Master
    APn --> Master

    AP1 -.-> Slave1
    AP2 -.-> Slave2
    APn -.-> Slave1

    Master --> Slave1
    Master --> Slave2

    AP1 --> NFS
    AP2 --> NFS
    APn --> NFS
```

## デプロイメント図

```mermaid
flowchart TB
    subgraph Dev["開発環境"]
        DevPC["開発者PC"]
        Maven["Maven Build"]
    end

    subgraph Build["ビルド成果物"]
        Jar["ruoyi-admin.jar"]
    end

    subgraph Server["本番サーバー"]
        JDK["JDK 1.8"]
        App["アプリケーション"]
        Scripts["運用スクリプト<br/>ry.sh"]
    end

    DevPC --> |mvn package| Maven
    Maven --> Jar
    Jar --> |デプロイ| Server
    Scripts --> |start/stop/restart| App
    JDK --> App
```

## 変更履歴

| 日付 | バージョン | 変更内容 |
| --- | --- | --- |
| 2026-01-08 | 1.0 | 初版作成 |
