# インフラ設計書

## 概要

本ドキュメントは、RuoYi管理システム（若依管理系統）v4.8.2のインフラストラクチャ設計について記載する。本システムはSpring Boot 2.5.15をベースとしたJava Webアプリケーションであり、単体構成のモノリシックアーキテクチャを採用している。

## システム構成

### 全体構成

本システムは以下のコンポーネントで構成される：

1. **アプリケーション層**：Spring Boot内蔵Tomcatで動作するWebアプリケーション
2. **データベース層**：MySQL 5.7以上のリレーショナルデータベース
3. **キャッシュ層**：EhCacheによるローカルキャッシュ

```
[クライアント]
     |
     | HTTP (Port 80)
     v
[APサーバー (Spring Boot + 内蔵Tomcat)]
     |
     | JDBC (Port 3306)
     v
[DBサーバー (MySQL)]
```

### サーバー構成

| サーバー種別 | 役割 | スペック（推奨） | 台数 |
| --- | --- | --- | --- |
| APサーバー | Webアプリケーション処理、静的リソース配信 | CPU: 2コア以上、メモリ: 2GB以上、ディスク: 50GB以上 | 1台（最小構成） |
| DBサーバー | データ永続化、トランザクション管理 | CPU: 2コア以上、メモリ: 4GB以上、ディスク: 100GB以上 | 1台（最小構成） |

### ネットワーク構成

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| アプリケーションポート | 80 | `application.yml`で設定 |
| コンテキストパス | / | ルートパスでアクセス |
| DBポート | 3306 | MySQL標準ポート |
| Druid監視ポート | 80 (パス: /druid/*) | アプリケーションと同一ポート |

**通信要件**：
- クライアント → APサーバー: HTTP/80
- APサーバー → DBサーバー: TCP/3306 (JDBC)
- APサーバー内部: ローカルキャッシュ（EhCache）

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Java | 1.8 (Java 8) | ランタイム環境 |
| Spring Boot | 2.5.15 | アプリケーションフレームワーク |
| Apache Tomcat (内蔵) | 9.0.112 | Webコンテナ |
| MySQL | 5.7以上推奨 | リレーショナルデータベース |
| Druid | 1.2.27 | DBコネクションプール |
| MyBatis | Spring Boot連携版 | O/Rマッピング |
| Apache Shiro | 1.13.0 | 認証・認可フレームワーク |
| EhCache | Shiro連携版 | ローカルキャッシュ |
| Quartz | Spring Boot連携版 | 定時タスクスケジューラ |
| Thymeleaf | Spring Boot連携版 | テンプレートエンジン |
| Logback | 1.2.13 | ログ出力 |
| Swagger | 3.0.0 | API仕様書自動生成 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| MySQLデータベース | データ永続化 | JDBC (mysql-connector-java) |
| (オプション) 外部IPアドレスサービス | ユーザーIPの地域情報取得 | HTTP API（addressEnabled設定で有効化） |

**備考**：本システムは基本的にスタンドアロンで動作し、外部サービス依存は最小限に抑えられている。

## スケーリング設計

### 現状構成

本システムはモノリシック構成を採用しており、以下の特性を持つ：

- **垂直スケーリング（スケールアップ）**：サーバースペック増強による対応
- **水平スケーリング（スケールアウト）**：標準構成では非対応

### Tomcat設定（スレッド設定）

`application.yml`で以下のチューニングが可能：

| 設定項目 | デフォルト値 | 説明 |
| --- | --- | --- |
| `server.tomcat.threads.max` | 800 | 最大スレッド数 |
| `server.tomcat.threads.min-spare` | 100 | 初期スレッド数 |
| `server.tomcat.accept-count` | 1000 | 接続待ちキュー数 |

### DBコネクションプール設定

Druidコネクションプールの設定：

| 設定項目 | 設定値 | 説明 |
| --- | --- | --- |
| `initialSize` | 5 | 初期接続数 |
| `minIdle` | 10 | 最小アイドル接続数 |
| `maxActive` | 20 | 最大接続数 |
| `maxWait` | 60000ms | 接続取得待ち時間 |
| `connectTimeout` | 30000ms | 接続タイムアウト |
| `socketTimeout` | 60000ms | ソケットタイムアウト |

### スケールアウト対応への拡張

水平スケーリングを実現するには以下の対応が必要：

1. セッション管理のRedis移行（現状はDBベースのセッション管理）
2. ロードバランサーの導入
3. ファイルストレージの共有化（NFS/S3等）

## 可用性設計

### 現状の冗長構成

本システムの標準構成では冗長構成は含まれていない（シングルポイント構成）。

### セッション管理

- セッション情報はデータベースに永続化される
- セッションタイムアウト: 30分（設定可能）
- セッション同期間隔: 1分

### ログイン制御

- 同一ユーザーの最大同時セッション数: 無制限（設定可能）
- パスワード連続失敗時のロック: 5回失敗で10分間ロック

### 可用性向上の推奨構成

本番環境での可用性向上には以下を推奨：

1. **APサーバー冗長化**: ロードバランサー + 複数APサーバー
2. **DB冗長化**: MySQLレプリケーション（マスター/スレーブ構成）
   - 設定ファイルにスレーブDB設定が用意されている（デフォルト無効）
3. **フェイルオーバー**: アプリケーションレベルでのヘルスチェック実装

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| MySQLデータベース | mysqldump / バイナリバックアップ | 日次推奨 | 要件に応じて設定 |
| アプリケーションログ | ファイルベース（時間ローテーション） | 自動ローテーション | 60日間 |
| アップロードファイル | ファイルシステムバックアップ | 日次推奨 | 要件に応じて設定 |
| 設定ファイル | バージョン管理（Git等） | 変更時 | 無期限 |

### ログ設定詳細

- **ログ出力先**: `/home/ruoyi/logs/`
- **ログファイル**:
  - `sys-info.log`: INFOレベルログ
  - `sys-error.log`: ERRORレベルログ
  - `sys-user.log`: ユーザーアクセスログ
- **ローテーション**: 日次
- **保持期間**: 60日

## 監視設計

### 組み込み監視機能

本システムには以下の監視機能が組み込まれている：

| 監視項目 | 機能 | アクセス方法 |
| --- | --- | --- |
| サーバー監視 | CPU、メモリ、ディスク、JVM情報 | /monitor/server |
| データ監視 | Druidコネクションプール状態、SQL実行統計 | /druid/* |
| 缓存監視 | EhCacheキャッシュ状態 | /monitor/cache |
| オンラインユーザー | アクティブセッション一覧 | /monitor/online |

### Druid監視設定

| 設定項目 | 設定値 |
| --- | --- |
| 監視URL | /druid/* |
| ログインユーザー | ruoyi |
| ログインパスワード | 123456 |
| Web統計フィルター | 有効 |
| スロークエリ記録 | 有効（1秒以上） |

### 推奨外部監視

| 監視ツール | 用途 |
| --- | --- |
| Prometheus + Grafana | メトリクス収集・可視化 |
| ELK Stack | ログ集約・分析 |
| Zabbix / Nagios | インフラ監視・アラート |

## JVMチューニング

### 推奨JVMパラメータ（ry.sh記載値）

```
-Xms512m                    # 初期ヒープサイズ
-Xmx1024m                   # 最大ヒープサイズ
-XX:MetaspaceSize=128m      # 初期メタスペース
-XX:MaxMetaspaceSize=512m   # 最大メタスペース
-XX:+HeapDumpOnOutOfMemoryError  # OOM時ヒープダンプ出力
-XX:NewRatio=1              # New/Old世代比率
-XX:SurvivorRatio=30        # Eden/Survivor比率
-XX:+UseParallelGC          # Parallel GC使用
-XX:+UseParallelOldGC       # Parallel Old GC使用
-Duser.timezone=Asia/Shanghai  # タイムゾーン設定
```

## セキュリティ設計

### 認証・認可

- **フレームワーク**: Apache Shiro
- **セッション管理**: DB永続化 + EhCacheキャッシュ
- **パスワード**: ソルト付きハッシュ化
- **記憶機能（Remember Me）**: Cookie暗号化（AES）

### 攻撃対策

| 対策 | 設定 | 備考 |
| --- | --- | --- |
| XSS対策 | 有効 | `/system/*`, `/monitor/*`, `/tool/*` |
| CSRF対策 | 無効（デフォルト） | 必要に応じて有効化 |
| SQLインジェクション対策 | MyBatis PreparedStatement | Druid Wallフィルター併用 |
| CAPTCHA | 有効 | 数式計算方式 |

### Cookie設定

| 設定項目 | 設定値 |
| --- | --- |
| HttpOnly | true |
| 有効期間 | 30日 |
| パス | / |

## 備考

### 前提条件

- Java 8 (JDK 1.8) がインストールされていること
- MySQL 5.7以上が利用可能であること
- ファイルアップロード用ディレクトリが作成されていること（デフォルト: `D:/ruoyi/uploadPath` または `/home/ruoyi/uploadPath`）

### 関連ドキュメント

- [インフラ構成図](./インフラ構成図.md)
- [RuoYi公式ドキュメント](http://doc.ruoyi.vip)

### 変更履歴

| 日付 | バージョン | 変更内容 |
| --- | --- | --- |
| 2026-01-08 | 1.0 | 初版作成 |
