---
generated_at: 2026-01-08 16:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **監査ログ保持期間**：コード上で明示的な設定が見つからない
  2. **HTTPS/HSTS設定**：アプリケーション設定での対応状況が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/ShiroConfig.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/realm/UserRealm.java`
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-04: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java`
- E-05: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/csrf/CsrfValidateFilter.java`
- E-06: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/session/OnlineWebSessionManager.java`
- E-07: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java`
- E-08: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/DataScopeAspect.java`
- E-09: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/PermissionService.java`
- E-10: `ruoyi-admin/src/main/resources/application.yml`
- E-11: `ruoyi-common/src/main/java/com/ruoyi/common/xss/XssFilter.java`
- E-12: `ruoyi-common/src/main/java/com/ruoyi/common/xss/XssHttpServletRequestWrapper.java`
- E-13: `ruoyi-common/src/main/java/com/ruoyi/common/utils/html/HTMLFilter.java`
- E-14: `ruoyi-common/src/main/java/com/ruoyi/common/utils/html/EscapeUtil.java`
- E-15: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/FilterConfig.java`
- E-16: `ruoyi-system/src/main/resources/mapper/system/SysOperLogMapper.xml`
- E-17: `ruoyi-system/src/main/resources/mapper/system/SysLogininforMapper.xml`
- E-18: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Apache Shiroフレームワークを使用した認証 | E-01, E-02 | ○ |
| C-02 | パスワードはMD5（ユーザー名+パスワード+Salt）でハッシュ化 | E-03 | ○ |
| C-03 | ログイン最大試行回数は5回 | E-03, E-10 | ○ |
| C-04 | セッション有効期限はデフォルト30分 | E-01, E-10 | ○ |
| C-05 | セッション検証間隔は10分 | E-01, E-10 | ○ |
| C-06 | セッションID URL書き換えは無効 | E-01 | ○ |
| C-07 | Remember Me機能はAES 128bitで暗号化 | E-01 | ○ |
| C-08 | CAPTCHA検証はデフォルト有効 | E-01, E-10 | ○ |
| C-09 | 管理者ロールは全権限（*:*:*）を持つ | E-02 | ○ |
| C-10 | データスコープは5種類存在 | E-08, E-18 | ○ |
| C-11 | URLベースのアクセス制御をShiro FilterChainで実装 | E-01 | ○ |
| C-12 | @RequiresPermissionsアノテーションによる権限チェック | E-09, Controller classes | ○ |
| C-13 | DataScopeAspectによるデータアクセス制御 | E-08 | ○ |
| C-14 | HTTPS/HSTS設定はアプリケーション設定に依存 | **根拠なし** | △ |
| C-15 | ログ出力時にパスワード関連フィールドを除外 | E-07 | ○ |
| C-16 | IPブラックリスト機能を実装 | E-04 | ○ |
| C-17 | XSSフィルターによるHTMLタグ除去 | E-11, E-12, E-13, E-14, E-15 | ○ |
| C-18 | XSSフィルター設定（enabled: true, urlPatterns等） | E-10, E-15 | ○ |
| C-19 | HTMLFilterでホワイトリスト方式のタグフィルタリング | E-13 | ○ |
| C-20 | 許可されるHTMLタグはa, img, b, strong, i, em | E-13 | ○ |
| C-21 | 許可されるプロトコルはhttp, https, mailto | E-13 | ○ |
| C-22 | CSRFフィルターはデフォルト無効 | E-01, E-05, E-10 | ○ |
| C-23 | CSRFトークンはX-CSRF-TOKENヘッダーで検証 | E-05 | ○ |
| C-24 | POSTリクエストのみCSRF検証 | E-05 | ○ |
| C-25 | MyBatisパラメータバインディングでSQLインジェクション対策 | E-16, E-17 | ○ |
| C-26 | DataScopeでSQL注入防止（dataScopeクリア処理） | E-08 | ○ |
| C-27 | 操作ログはsys_oper_logテーブルに記録 | E-16 | ○ |
| C-28 | ログインログはsys_logininforテーブルに記録 | E-17 | ○ |
| C-29 | 操作ログ記録項目（title, businessType, method等） | E-07, E-16 | ○ |
| C-30 | ログインログ記録項目（loginName, status, ipaddr等） | E-17 | ○ |
| C-31 | @Logアノテーションによる操作ログ記録 | E-07 | ○ |
| C-32 | Cookie HttpOnlyはtrue | E-01, E-10 | ○ |
| C-33 | 同一ユーザー多重ログイン制御（KickoutSessionFilter） | E-01 | ○ |
| C-34 | セッションのデータベース永続化（SysUserOnline） | E-06 | ○ |
| C-35 | 監査ログの保持期間設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **HTTPS/HSTS設定**：アプリケーションコード上での明示的なHTTPS設定が確認できない。リバースプロキシやインフラ層での設定状況は本調査の範囲外。
  - 候補：Nginx設定 / Apache設定 / Spring Security設定（未使用）
- **監査ログ保持期間**：ログデータの保持期間やパージポリシーに関する設定がコード上で確認できない。運用ポリシーや外部ジョブでの対応の可能性あり。
  - 候補：バッチジョブ設定 / データベース設定 / 運用手順書

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 認証・認可の基本設計（Shiro設定、権限体系）
- **0（低リスク）**: XSS対策（フィルター設定、HTMLFilter実装）
- **1（中リスク）**: パスワードハッシュ方式（MD5使用）- より安全なアルゴリズムへの移行検討を推奨
- **1（中リスク）**: CSRFデフォルト無効 - 本番環境での有効化を推奨
- **1（中リスク）**: HTTPS未設定 - インフラ層での対応確認が必要
- **0（低リスク）**: 監査ログ設計（記録項目、テーブル設計）

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードハッシュ方式（MD5）のセキュリティリスク評価と代替案検討
- [ ] CSRF保護のデフォルト無効設定が許容されるか確認
- [ ] HTTPS/TLS設定がインフラ層で適切に構成されているか確認
- [ ] 監査ログの保持期間ポリシーが別途定義されているか確認
- [ ] IPブラックリストの運用方法と更新手順の確認
- [ ] Remember Me暗号化キーの管理方法（クラスタ環境での整合性）確認
- [ ] XSS除外パス（/system/notice/*）の妥当性確認
