---
generated_at: 2026-01-08 16:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 19
  claims_without_evidence: 9
confidence_derived: 0.68
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.68**
  - 根拠あり：19 / 28、根拠なし：9
- 優先レビュー（高）
  1. **カバレッジ目標値**：組織のテスト方針ドキュメントが存在しないため、一般的な推奨値を採用
  2. **テスト環境構成**：現在のインフラ構成が明確でないため、推定に基づく
  3. **CI/CD構成**：現時点でCI/CD設定が存在しないため、推奨構成として記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/RuoYi-master/pom.xml` - 親POM（プロジェクト構成、依存関係、Javaバージョン）
- E-02: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-admin/pom.xml` - Admin モジュールPOM
- E-03: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-framework/pom.xml` - Framework モジュールPOM
- E-04: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-common/pom.xml` - Common モジュールPOM
- E-05: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-admin/src/main/resources/application.yml` - アプリケーション設定
- E-06: `/Users/tomokababa/Work/route06/RuoYi-master/README.md` - プロジェクト概要
- E-07: `/Users/tomokababa/Work/route06/RuoYi-master/sql/ry_20250416.sql` - 初期データベーススキーマ
- E-08: `/Users/tomokababa/Work/route06/RuoYi-master/.github/FUNDING.yml` - GitHub設定
- E-09: Controller層ソースコード（34ファイル）
- E-10: Service層ソースコード（24ファイル）
- E-11: Mapper層ソースコード（20ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RuoYiはSpring Boot 2.5.15ベースである | E-01 (spring-boot.version=2.5.15) | ○ |
| C-02 | Java 1.8対応である | E-01 (java.version=1.8) | ○ |
| C-03 | Apache Shiro 1.13.0による認証・認可 | E-01 (shiro.version=1.13.0), E-05 | ○ |
| C-04 | MyBatisをORMとして使用 | E-01, E-05 (mybatis設定) | ○ |
| C-05 | Tomcat 9.0.112を使用 | E-01 (tomcat.version=9.0.112) | ○ |
| C-06 | 最大800スレッド対応 | E-05 (tomcat.threads.max=800) | ○ |
| C-07 | XSS対策フィルタ有効 | E-05 (xss.enabled=true) | ○ |
| C-08 | CSRF対策フィルタ存在（デフォルト無効） | E-05 (csrf.enabled=false) | ○ |
| C-09 | Swagger 3.0.0による API ドキュメント | E-01, E-02 | ○ |
| C-10 | 6モジュール構成 | E-01 (modules定義) | ○ |
| C-11 | src/testディレクトリが存在しない | Globパターン検索結果 | ○ |
| C-12 | CI/CD設定が存在しない | E-08 (FUNDING.ymlのみ) | ○ |
| C-13 | spring-boot-starter-test依存関係がない | E-01, E-02, E-03, E-04 | ○ |
| C-14 | Druid接続プール使用 | E-01 (druid.version), E-05 | ○ |
| C-15 | PageHelper分ページ使用 | E-01 (pagehelper.boot.version) | ○ |
| C-16 | EhCacheキャッシュ使用 | E-01, E-04 (shiro-ehcache) | ○ |
| C-17 | Thymeleafテンプレートエンジン使用 | E-02, E-05 | ○ |
| C-18 | Quartz定時タスク機能 | E-01 (ruoyi-quartz), sql/quartz.sql | ○ |
| C-19 | Velocity代码生成 | E-01 (velocity-engine-core) | ○ |
| C-20 | カバレッジ目標70%（行） | **根拠なし** | △ |
| C-21 | カバレッジ目標60%（分岐） | **根拠なし** | △ |
| C-22 | JUnit 5推奨 | **根拠なし**（業界標準として推奨） | △ |
| C-23 | Mockito 4.x推奨 | **根拠なし**（業界標準として推奨） | △ |
| C-24 | H2インメモリDB推奨 | **根拠なし**（テスト効率化として推奨） | △ |
| C-25 | Selenium E2E推奨 | **根拠なし**（業界標準として推奨） | △ |
| C-26 | JMeter性能テスト推奨 | **根拠なし**（業界標準として推奨） | △ |
| C-27 | 不具合重要度定義 | **根拠なし**（一般的なプラクティス） | △ |
| C-28 | テスト実装優先順位 | **根拠なし**（アーキテクチャ分析に基づく推奨） | △ |

## 4) 不足情報（Unknown / Missing）
- **テスト要件定義書**: プロジェクトにおけるテスト要件や品質目標を定義したドキュメントが存在しない
  - 候補：組織のテスト方針書 / 品質管理ガイドライン / プロジェクト計画書
- **既存テストコード**: src/test ディレクトリが存在せず、テストコードの参照ができない
  - 候補：開発チームへのヒアリング / 過去のテスト実績確認
- **インフラ構成図**: 本番・ステージング環境の詳細構成が不明
  - 候補：インフラ設計書 / デプロイメント手順書
- **CI/CD設定**: 継続的インテグレーション・デプロイの設定ファイルが存在しない
  - 候補：Jenkinsfile / GitHub Actions ワークフロー

## 5) リスクフラグ（レビュー観点）
- **リスク 1（中）**: テストコードが存在しないため、本方針書は推奨・提案の性質が強い
- **リスク 1（中）**: カバレッジ目標値は組織の方針に基づいて調整が必要
- **リスク 0（低）**: ツールバージョンは現時点の推奨であり、導入時に最新版を検討
- **リスク 2（高）**: セキュリティテスト方針は、Apache Shiroの詳細設定確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標値が組織の品質方針と整合しているか確認
- [ ] テスト環境構成が実際のインフラと一致しているか確認
- [ ] 推奨テストツールが組織の技術スタックと適合しているか確認
- [ ] 不具合重要度定義が組織の既存プロセスと整合しているか確認
- [ ] CI/CD推奨構成が組織のDevOps方針と一致しているか確認
- [ ] セキュリティテスト方針がコンプライアンス要件を満たしているか確認
- [ ] テスト実装優先順位がビジネス優先度と整合しているか確認
