# テスト方針書

## 概要

本ドキュメントは、RuoYi（若依）管理システム v4.8.2 におけるテスト方針を定義するものである。RuoYiは、Spring Boot 2.5.15をベースとしたJava 1.8対応のWebアプリケーションであり、ユーザー管理、権限管理、定時タスク、コード生成などの機能を提供する企業向け管理システムである。

本プロジェクトは現時点でテストコード（src/test）が存在しないため、本方針書では推奨されるテスト戦略と実装方針を提示する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 各クラス・メソッドの個別機能が正しく動作することを確認する。Service層、Utility層を中心にテストを実施 | 開発者 |
| 結合テスト | Controller-Service-Mapper層間の連携、およびデータベースとの統合動作を確認する | 開発者/QA |
| システムテスト | システム全体としての機能動作、画面遷移、認証・認可フローを確認する | QAチーム |
| 受入テスト | ユーザー要件を満たしているか、業務シナリオに沿った動作確認を行う | 顧客/エンドユーザー |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | ユーザー管理、部門管理、メニュー管理、定時タスク等の各機能が仕様通り動作することを確認 | 開発フェーズ、リリース前 |
| 性能テスト | 同時接続800スレッド対応、大量データ処理時の応答時間を測定 | システムテストフェーズ |
| セキュリティテスト | Apache Shiro認証、XSS対策、CSRF対策、セッション管理の脆弱性検証 | システムテストフェーズ、リリース前 |
| 回帰テスト | 既存機能に影響がないことを確認するための自動テスト実行 | 機能追加・修正時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発者による単体テスト・デバッグ | Java 1.8, MySQL 5.7+, Maven 3.x, IDE (IntelliJ IDEA/Eclipse) |
| 結合テスト環境 | Service-Mapper層間の結合テスト、DB連携テスト | Java 1.8, MySQL 5.7+, Spring Boot組み込みTomcat |
| ステージング環境 | 本番同等構成でのシステムテスト・性能テスト | Java 1.8, MySQL 5.7+, 外部Tomcat 9.0.112, Redis（任意） |
| 本番環境 | 受入テスト、最終検証 | 本番サーバー構成 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| JUnit 5 | 単体テスト・結合テストフレームワーク | 5.x（推奨） |
| Mockito | モックオブジェクト作成、依存性の分離 | 4.x（推奨） |
| Spring Boot Test | Spring統合テスト、@SpringBootTest等 | 2.5.15 |
| MyBatis Test | Mapperレイヤーのテスト支援 | 2.0.x（推奨） |
| H2 Database | インメモリDBを使用したテスト高速化 | 1.4.x（推奨） |
| Selenium | 画面自動テスト（E2Eテスト） | 4.x（推奨） |
| JMeter | 性能テスト、負荷テスト | 5.x（推奨） |
| OWASP ZAP | セキュリティ脆弱性スキャン | 最新版 |
| Jacoco | コードカバレッジ測定 | 0.8.x（推奨） |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 70%以上 |
| 分岐カバレッジ | 60%以上 |
| Service層カバレッジ | 80%以上 |
| Controller層カバレッジ | 70%以上 |
| Util/Common層カバレッジ | 85%以上 |

### 優先度別カバレッジ目標

1. **最優先**: 認証・認可関連（SysLoginService, SysPasswordService, UserRealm）- 90%以上
2. **高優先**: コアビジネスロジック（各種ServiceImpl）- 80%以上
3. **中優先**: Controller層、データ変換ロジック - 70%以上
4. **低優先**: 設定クラス、DTO/Entity - 50%以上

## テストデータ

### テストデータ準備方針

1. **マスターデータ**
   - 初期SQLスクリプト（ry_20250416.sql）を基にテスト用マスターデータを準備
   - テスト環境専用のユーザー、部門、ロールを作成

2. **トランザクションデータ**
   - 各テストケースで必要なデータをSetup/Teardownで作成・削除
   - @Transactional + @Rollback を活用してテスト間の独立性を確保

3. **テストデータファクトリ**
   - TestDataFactory クラスを作成し、テストデータ生成を一元管理
   - Builder パターンを活用した柔軟なテストデータ生成

4. **データベース初期化**
   - H2インメモリDBを使用する場合は、schema.sql/data.sql による初期化
   - 本番DB（MySQL）使用時は、Flyway/Liquibase によるマイグレーション管理を検討

### 機密データの取り扱い

- テストデータには本番データを使用しない
- パスワードはテスト専用の固定値を使用（例：test123）
- 個人情報は匿名化されたダミーデータを使用

## 不具合管理

### 不具合管理プロセス

1. **報告**: テスト実行時に不具合を発見した場合、課題管理システム（GitHub Issues/JIRA等）に登録
2. **分類**: 重要度（Critical/Major/Minor/Trivial）と優先度を設定
3. **分析**: 原因調査と影響範囲の特定
4. **修正**: 開発者による修正実施
5. **検証**: 修正確認テストと回帰テストの実施
6. **クローズ**: 検証完了後、不具合をクローズ

### 重要度定義

| 重要度 | 定義 | 対応期限目安 |
| --- | --- | --- |
| Critical | システム停止、データ損失、セキュリティ脆弱性 | 即時対応（24時間以内） |
| Major | 主要機能の動作不可、業務影響大 | 3営業日以内 |
| Minor | 軽微な機能不具合、回避策あり | 次回リリースまで |
| Trivial | 表示崩れ、誤字等、業務影響なし | バックログ管理 |

## CI/CD連携

### 現状分析

本プロジェクトでは現時点でCI/CD設定（GitHub Actions、Jenkins等）は構築されていない。`.github/` ディレクトリには FUNDING.yml のみ存在する。

### 推奨CI/CD構成

#### GitHub Actions（推奨）

```yaml
# .github/workflows/test.yml（参考構成）
name: Test Pipeline

on:
  push:
    branches: [main, develop]
  pull_request:
    branches: [main]

jobs:
  test:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v3
      - name: Set up JDK 1.8
        uses: actions/setup-java@v3
        with:
          java-version: '8'
          distribution: 'temurin'
      - name: Cache Maven packages
        uses: actions/cache@v3
        with:
          path: ~/.m2
          key: ${{ runner.os }}-m2-${{ hashFiles('**/pom.xml') }}
      - name: Run Tests
        run: mvn test
      - name: Generate Coverage Report
        run: mvn jacoco:report
      - name: Upload Coverage to Codecov
        uses: codecov/codecov-action@v3
```

#### テスト実行タイミング

| タイミング | 実行テスト | 目的 |
| --- | --- | --- |
| コミット時 | 単体テスト | 即座にフィードバック |
| プルリクエスト時 | 単体テスト + 結合テスト | マージ前の品質確保 |
| デイリービルド | 全テスト + カバレッジ計測 | 継続的な品質監視 |
| リリース前 | 全テスト + 性能テスト + セキュリティテスト | リリース品質保証 |

## 備考

### モジュール構成とテスト戦略

本プロジェクトは以下の6モジュールで構成されており、各モジュールに応じたテスト戦略が必要である。

| モジュール | 役割 | テスト重点 |
| --- | --- | --- |
| ruoyi-admin | Webエントリーポイント、Controller層 | E2Eテスト、Controller単体テスト |
| ruoyi-framework | フレームワーク設定、Shiro/AOP/Filter | 認証認可テスト、インターセプターテスト |
| ruoyi-system | システムサービス、ユーザー/ロール管理 | Service層単体テスト、Mapper結合テスト |
| ruoyi-quartz | 定時タスク管理 | ジョブ実行テスト、スケジューラーテスト |
| ruoyi-generator | コード生成機能 | テンプレート生成テスト |
| ruoyi-common | 共通ユーティリティ | ユーティリティ単体テスト |

### テスト実装の優先順位

1. **Phase 1**: ruoyi-common のユーティリティクラス（低リスク、高効果）
2. **Phase 2**: ruoyi-system のService層（コアビジネスロジック）
3. **Phase 3**: ruoyi-framework の認証・認可関連（セキュリティ重要）
4. **Phase 4**: ruoyi-admin のController層（統合動作確認）
5. **Phase 5**: ruoyi-quartz の定時タスク（非同期処理の検証）

### 技術的考慮事項

1. **Shiroテスト**: Apache Shiroの認証・認可テストには shiro-test モジュールの活用を検討
2. **非同期処理**: Quartz ジョブのテストには @TestPropertySource による設定上書きを活用
3. **データソース**: @DataJpaTest ではなく @MybatisTest を使用（MyBatis採用のため）
4. **トランザクション**: テスト後のロールバック設定（@Transactional + @Rollback）を標準とする

### 今後の推奨事項

1. **テスト基盤の構築**: spring-boot-starter-test 依存関係の追加
2. **テストディレクトリ作成**: 各モジュールに src/test/java ディレクトリを追加
3. **CI/CD設定**: GitHub Actions ワークフローの実装
4. **カバレッジ計測**: Jacoco プラグインの導入
5. **テストレポート**: Surefire/Failsafe レポートの生成設定

本方針書は、プロジェクトの成熟に合わせて継続的に更新されるものとする。
