# ER図

## 概要

本ドキュメントは、RuoYiフレームワークのデータベースエンティティ関係図（ER図）をMermaid形式で記述しています。

## システム管理系ER図

```mermaid
erDiagram
    %% ユーザー・部門・岗位・ロール関連
    sys_dept ||--o{ sys_user : "所属"
    sys_dept ||--o{ sys_dept : "親子関係"
    sys_dept }o--o{ sys_role : "sys_role_dept"

    sys_user }o--o{ sys_role : "sys_user_role"
    sys_user }o--o{ sys_post : "sys_user_post"

    sys_role }o--o{ sys_menu : "sys_role_menu"
    sys_menu ||--o{ sys_menu : "親子関係"

    %% 辞書関連
    sys_dict_type ||--o{ sys_dict_data : "タイプ-データ"

    %% テーブル定義
    sys_dept {
        bigint dept_id PK "部門ID"
        bigint parent_id FK "親部門ID"
        varchar ancestors "祖先リスト"
        varchar dept_name "部門名"
        int order_num "表示順"
        varchar leader "責任者"
        varchar phone "電話"
        varchar email "メール"
        char status "状態"
        char del_flag "削除フラグ"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
    }

    sys_user {
        bigint user_id PK "ユーザーID"
        bigint dept_id FK "部門ID"
        varchar login_name "ログイン名"
        varchar user_name "ユーザー名"
        varchar user_type "ユーザータイプ"
        varchar email "メール"
        varchar phonenumber "電話"
        char sex "性別"
        varchar avatar "アバター"
        varchar password "パスワード"
        varchar salt "ソルト"
        char status "状態"
        char del_flag "削除フラグ"
        varchar login_ip "最終ログインIP"
        datetime login_date "最終ログイン日時"
        datetime pwd_update_date "パスワード更新日"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }

    sys_post {
        bigint post_id PK "岗位ID"
        varchar post_code "岗位コード"
        varchar post_name "岗位名"
        int post_sort "表示順"
        char status "状態"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }

    sys_role {
        bigint role_id PK "ロールID"
        varchar role_name "ロール名"
        varchar role_key "ロールキー"
        int role_sort "表示順"
        char data_scope "データ範囲"
        char status "状態"
        char del_flag "削除フラグ"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }

    sys_menu {
        bigint menu_id PK "メニューID"
        varchar menu_name "メニュー名"
        bigint parent_id FK "親メニューID"
        int order_num "表示順"
        varchar url "URL"
        varchar target "開き方"
        char menu_type "タイプ"
        char visible "表示状態"
        char is_refresh "リフレッシュ"
        varchar perms "権限識別子"
        varchar icon "アイコン"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }

    sys_user_role {
        bigint user_id PK,FK "ユーザーID"
        bigint role_id PK,FK "ロールID"
    }

    sys_role_menu {
        bigint role_id PK,FK "ロールID"
        bigint menu_id PK,FK "メニューID"
    }

    sys_role_dept {
        bigint role_id PK,FK "ロールID"
        bigint dept_id PK,FK "部門ID"
    }

    sys_user_post {
        bigint user_id PK,FK "ユーザーID"
        bigint post_id PK,FK "岗位ID"
    }

    sys_dict_type {
        bigint dict_id PK "辞書ID"
        varchar dict_name "辞書名"
        varchar dict_type UK "辞書タイプ"
        char status "状態"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }

    sys_dict_data {
        bigint dict_code PK "辞書コード"
        int dict_sort "表示順"
        varchar dict_label "ラベル"
        varchar dict_value "値"
        varchar dict_type FK "辞書タイプ"
        varchar css_class "CSSクラス"
        varchar list_class "リストクラス"
        char is_default "デフォルト"
        char status "状態"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }
```

## システム設定・ログ系ER図

```mermaid
erDiagram
    sys_config {
        int config_id PK "設定ID"
        varchar config_name "設定名"
        varchar config_key "設定キー"
        varchar config_value "設定値"
        char config_type "システム組込"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }

    sys_oper_log {
        bigint oper_id PK "操作ID"
        varchar title "モジュール名"
        int business_type "業務タイプ"
        varchar method "メソッド名"
        varchar request_method "リクエスト方式"
        int operator_type "操作者タイプ"
        varchar oper_name "操作者名"
        varchar dept_name "部門名"
        varchar oper_url "URL"
        varchar oper_ip "操作元IP"
        varchar oper_location "操作場所"
        varchar oper_param "パラメータ"
        varchar json_result "結果"
        int status "状態"
        varchar error_msg "エラーメッセージ"
        datetime oper_time "操作日時"
        bigint cost_time "処理時間"
    }

    sys_logininfor {
        bigint info_id PK "アクセスID"
        varchar login_name "ログイン名"
        varchar ipaddr "IPアドレス"
        varchar login_location "ログイン場所"
        varchar browser "ブラウザ"
        varchar os "OS"
        char status "状態"
        varchar msg "メッセージ"
        datetime login_time "ログイン日時"
    }

    sys_user_online {
        varchar sessionId PK "セッションID"
        varchar login_name "ログイン名"
        varchar dept_name "部門名"
        varchar ipaddr "IPアドレス"
        varchar login_location "ログイン場所"
        varchar browser "ブラウザ"
        varchar os "OS"
        varchar status "状態"
        datetime start_timestamp "セッション開始"
        datetime last_access_time "最終アクセス"
        int expire_time "タイムアウト"
    }

    sys_notice {
        int notice_id PK "公告ID"
        varchar notice_title "タイトル"
        char notice_type "タイプ"
        longblob notice_content "内容"
        char status "状態"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }
```

## 定時タスク系ER図

```mermaid
erDiagram
    sys_job ||--o{ sys_job_log : "実行ログ"

    sys_job {
        bigint job_id PK "タスクID"
        varchar job_name PK "タスク名"
        varchar job_group PK "タスクグループ"
        varchar invoke_target "呼び出し対象"
        varchar cron_expression "Cron式"
        varchar misfire_policy "失敗時ポリシー"
        char concurrent "並列実行"
        char status "状態"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }

    sys_job_log {
        bigint job_log_id PK "ログID"
        varchar job_name FK "タスク名"
        varchar job_group FK "タスクグループ"
        varchar invoke_target "呼び出し対象"
        varchar job_message "メッセージ"
        char status "状態"
        varchar exception_info "例外情報"
        datetime create_time "作成日時"
    }
```

## コード生成系ER図

```mermaid
erDiagram
    gen_table ||--o{ gen_table_column : "カラム定義"

    gen_table {
        bigint table_id PK "テーブルID"
        varchar table_name "テーブル名"
        varchar table_comment "テーブル説明"
        varchar sub_table_name "子テーブル名"
        varchar sub_table_fk_name "子テーブルFK"
        varchar class_name "クラス名"
        varchar tpl_category "テンプレート"
        varchar package_name "パッケージ"
        varchar module_name "モジュール名"
        varchar business_name "業務名"
        varchar function_name "機能名"
        varchar function_author "著者"
        int form_col_num "フォーム列数"
        char gen_type "生成方式"
        varchar gen_path "生成パス"
        varchar options "オプション"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
        varchar remark "備考"
    }

    gen_table_column {
        bigint column_id PK "カラムID"
        bigint table_id FK "テーブルID"
        varchar column_name "カラム名"
        varchar column_comment "カラム説明"
        varchar column_type "カラムタイプ"
        varchar java_type "Javaタイプ"
        varchar java_field "Javaフィールド"
        char is_pk "主キー"
        char is_increment "自動採番"
        char is_required "必須"
        char is_insert "挿入"
        char is_edit "編集"
        char is_list "リスト"
        char is_query "クエリ"
        varchar query_type "クエリ方式"
        varchar html_type "HTML表示"
        varchar dict_type "辞書タイプ"
        int sort "表示順"
        varchar create_by "作成者"
        datetime create_time "作成日時"
        varchar update_by "更新者"
        datetime update_time "更新日時"
    }
```

## Quartzスケジューラ系ER図

```mermaid
erDiagram
    QRTZ_JOB_DETAILS ||--o{ QRTZ_TRIGGERS : "トリガー"
    QRTZ_TRIGGERS ||--o| QRTZ_SIMPLE_TRIGGERS : "単純トリガー"
    QRTZ_TRIGGERS ||--o| QRTZ_CRON_TRIGGERS : "Cronトリガー"
    QRTZ_TRIGGERS ||--o| QRTZ_BLOB_TRIGGERS : "Blobトリガー"
    QRTZ_TRIGGERS ||--o| QRTZ_SIMPROP_TRIGGERS : "プロパティトリガー"
    QRTZ_TRIGGERS }o--o| QRTZ_CALENDARS : "カレンダー参照"

    QRTZ_JOB_DETAILS {
        varchar sched_name PK "スケジューラ名"
        varchar job_name PK "ジョブ名"
        varchar job_group PK "ジョブグループ"
        varchar description "説明"
        varchar job_class_name "クラス名"
        varchar is_durable "永続化"
        varchar is_nonconcurrent "非並列"
        varchar is_update_data "データ更新"
        varchar requests_recovery "リカバリ"
        blob job_data "ジョブデータ"
    }

    QRTZ_TRIGGERS {
        varchar sched_name PK,FK "スケジューラ名"
        varchar trigger_name PK "トリガー名"
        varchar trigger_group PK "トリガーグループ"
        varchar job_name FK "ジョブ名"
        varchar job_group FK "ジョブグループ"
        varchar description "説明"
        bigint next_fire_time "次回発火"
        bigint prev_fire_time "前回発火"
        integer priority "優先度"
        varchar trigger_state "状態"
        varchar trigger_type "タイプ"
        bigint start_time "開始"
        bigint end_time "終了"
        varchar calendar_name FK "カレンダー名"
        smallint misfire_instr "ミスファイア"
        blob job_data "データ"
    }

    QRTZ_SIMPLE_TRIGGERS {
        varchar sched_name PK,FK "スケジューラ名"
        varchar trigger_name PK,FK "トリガー名"
        varchar trigger_group PK,FK "トリガーグループ"
        bigint repeat_count "繰り返し回数"
        bigint repeat_interval "間隔"
        bigint times_triggered "発火回数"
    }

    QRTZ_CRON_TRIGGERS {
        varchar sched_name PK,FK "スケジューラ名"
        varchar trigger_name PK,FK "トリガー名"
        varchar trigger_group PK,FK "トリガーグループ"
        varchar cron_expression "Cron式"
        varchar time_zone_id "タイムゾーン"
    }

    QRTZ_BLOB_TRIGGERS {
        varchar sched_name PK,FK "スケジューラ名"
        varchar trigger_name PK,FK "トリガー名"
        varchar trigger_group PK,FK "トリガーグループ"
        blob blob_data "Blobデータ"
    }

    QRTZ_CALENDARS {
        varchar sched_name PK "スケジューラ名"
        varchar calendar_name PK "カレンダー名"
        blob calendar "カレンダーデータ"
    }

    QRTZ_PAUSED_TRIGGER_GRPS {
        varchar sched_name PK "スケジューラ名"
        varchar trigger_group PK "トリガーグループ"
    }

    QRTZ_FIRED_TRIGGERS {
        varchar sched_name PK "スケジューラ名"
        varchar entry_id PK "エントリID"
        varchar trigger_name "トリガー名"
        varchar trigger_group "トリガーグループ"
        varchar instance_name "インスタンス名"
        bigint fired_time "発火時刻"
        bigint sched_time "スケジュール時刻"
        integer priority "優先度"
        varchar state "状態"
        varchar job_name "ジョブ名"
        varchar job_group "ジョブグループ"
        varchar is_nonconcurrent "非並列"
        varchar requests_recovery "リカバリ"
    }

    QRTZ_SCHEDULER_STATE {
        varchar sched_name PK "スケジューラ名"
        varchar instance_name PK "インスタンス名"
        bigint last_checkin_time "最終チェックイン"
        bigint checkin_interval "チェックイン間隔"
    }

    QRTZ_LOCKS {
        varchar sched_name PK "スケジューラ名"
        varchar lock_name PK "ロック名"
    }

    QRTZ_SIMPROP_TRIGGERS {
        varchar sched_name PK,FK "スケジューラ名"
        varchar trigger_name PK,FK "トリガー名"
        varchar trigger_group PK,FK "トリガーグループ"
        varchar str_prop_1 "文字列1"
        varchar str_prop_2 "文字列2"
        varchar str_prop_3 "文字列3"
        int int_prop_1 "整数1"
        int int_prop_2 "整数2"
        bigint long_prop_1 "長整数1"
        bigint long_prop_2 "長整数2"
        numeric dec_prop_1 "小数1"
        numeric dec_prop_2 "小数2"
        varchar bool_prop_1 "真偽値1"
        varchar bool_prop_2 "真偽値2"
    }
```

## リレーションシップサマリー

### 主要な関連

| 関連元 | 関連先 | 関連種別 | 説明 |
|--------|--------|----------|------|
| sys_user | sys_dept | N:1 | ユーザーは1つの部門に所属 |
| sys_dept | sys_dept | N:1 | 部門は親部門を持つ（自己参照） |
| sys_user | sys_role | N:N | ユーザーは複数ロールを持つ（sys_user_role経由） |
| sys_user | sys_post | N:N | ユーザーは複数岗位を持つ（sys_user_post経由） |
| sys_role | sys_menu | N:N | ロールは複数メニュー権限を持つ（sys_role_menu経由） |
| sys_role | sys_dept | N:N | ロールは複数部門のデータ権限を持つ（sys_role_dept経由） |
| sys_menu | sys_menu | N:1 | メニューは親メニューを持つ（自己参照） |
| sys_dict_type | sys_dict_data | 1:N | 辞書タイプは複数の辞書データを持つ |
| sys_job | sys_job_log | 1:N | タスクは複数の実行ログを持つ |
| gen_table | gen_table_column | 1:N | テーブルは複数のカラムを持つ |
| QRTZ_JOB_DETAILS | QRTZ_TRIGGERS | 1:N | ジョブは複数のトリガーを持つ |
| QRTZ_TRIGGERS | QRTZ_*_TRIGGERS | 1:1 | トリガーはタイプ別サブテーブルを持つ |
