---
generated_at: 2026-01-08 13:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があるため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sql/ry_20250416.sql` - システム管理系テーブル定義（20テーブル）
- E-02: `sql/quartz.sql` - Quartzスケジューラ系テーブル定義（11テーブル）
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` - ユーザーエンティティ
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` - 部門エンティティ
- E-05: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java` - ロールエンティティ
- E-06: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java` - メニューエンティティ
- E-07: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java` - 辞書タイプエンティティ
- E-08: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java` - 辞書データエンティティ
- E-09: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` - 岗位エンティティ
- E-10: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` - 操作ログエンティティ
- E-11: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` - 設定エンティティ
- E-12: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` - 通知エンティティ
- E-13: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` - ログイン情報エンティティ
- E-14: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserOnline.java` - オンラインユーザーエンティティ
- E-15: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserRole.java` - ユーザーロール関連エンティティ
- E-16: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysRoleMenu.java` - ロールメニュー関連エンティティ
- E-17: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysRoleDept.java` - ロール部門関連エンティティ
- E-18: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserPost.java` - ユーザー岗位関連エンティティ
- E-19: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` - 定時タスクエンティティ
- E-20: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` - タスクログエンティティ
- E-21: `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTable.java` - コード生成テーブルエンティティ
- E-22: `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTableColumn.java` - コード生成カラムエンティティ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | データベースは合計31テーブルで構成 | E-01, E-02 | ○ |
| C-02 | ストレージエンジンはInnoDB | E-01, E-02 | ○ |
| C-03 | sys_deptテーブルは部門情報を階層構造で管理 | E-01, E-04 | ○ |
| C-04 | sys_deptのparent_idで親子関係を表現 | E-01, E-04 | ○ |
| C-05 | sys_userテーブルはユーザー情報を管理 | E-01, E-03 | ○ |
| C-06 | sys_userはdept_idでsys_deptと関連 | E-01, E-03 | ○ |
| C-07 | sys_postテーブルは岗位情報を管理 | E-01, E-09 | ○ |
| C-08 | sys_roleテーブルはロール情報を管理 | E-01, E-05 | ○ |
| C-09 | sys_roleのdata_scopeでデータ権限範囲を定義 | E-01, E-05 | ○ |
| C-10 | sys_menuテーブルはメニュー・権限を管理 | E-01, E-06 | ○ |
| C-11 | sys_menuはparent_idで階層構造を表現 | E-01, E-06 | ○ |
| C-12 | sys_user_roleはユーザーとロールの多対多関連 | E-01, E-15 | ○ |
| C-13 | sys_role_menuはロールとメニューの多対多関連 | E-01, E-16 | ○ |
| C-14 | sys_role_deptはロールと部門の多対多関連 | E-01, E-17 | ○ |
| C-15 | sys_user_postはユーザーと岗位の多対多関連 | E-01, E-18 | ○ |
| C-16 | sys_oper_logテーブルは操作ログを記録 | E-01, E-10 | ○ |
| C-17 | sys_dict_typeテーブルは辞書タイプを管理 | E-01, E-07 | ○ |
| C-18 | sys_dict_dataテーブルは辞書データを管理 | E-01, E-08 | ○ |
| C-19 | sys_configテーブルはシステムパラメータを管理 | E-01, E-11 | ○ |
| C-20 | sys_logininforテーブルはログイン履歴を記録 | E-01, E-13 | ○ |
| C-21 | sys_user_onlineテーブルはオンラインセッションを管理 | E-01, E-14 | ○ |
| C-22 | sys_jobテーブルは定時タスクを管理 | E-01, E-19 | ○ |
| C-23 | sys_job_logテーブルはタスク実行ログを記録 | E-01, E-20 | ○ |
| C-24 | sys_noticeテーブルは通知・公告を管理 | E-01, E-12 | ○ |
| C-25 | gen_tableテーブルはコード生成用テーブル定義を管理 | E-01, E-21 | ○ |
| C-26 | gen_table_columnテーブルはコード生成用カラム定義を管理 | E-01, E-22 | ○ |
| C-27 | QRTZ_JOB_DETAILSテーブルはQuartzジョブ詳細を管理 | E-02 | ○ |
| C-28 | QRTZ_TRIGGERSテーブルはトリガー情報を管理 | E-02 | ○ |
| C-29 | QRTZ_CRON_TRIGGERSテーブルはCronトリガーを管理 | E-02 | ○ |
| C-30 | QRTZ_SIMPLE_TRIGGERSテーブルは単純トリガーを管理 | E-02 | ○ |
| C-31 | del_flagによる論理削除を採用 | E-01 | ○ |
| C-32 | statusカラムで有効/無効状態を管理 | E-01 | ○ |
| C-33 | 共通の監査カラム（create_by, create_time等）を持つ | E-01 | ○ |
| C-34 | Quartzテーブルはクラスタ対応 | E-02 | ○ |
| C-35 | sys_oper_logにはインデックスが設定されている | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません

補足：
- 全ての主張はSQLファイルおよびJavaエンティティクラスから直接確認できます
- テーブル定義はCREATE TABLE文から抽出
- カラム情報はSQLのコメント句から日本語説明を取得

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり
- SQLファイルが最新のデータベーススキーマと一致することを前提としています
- 本番環境のデータベースとの差分がある場合は別途確認が必要です

## 6) レビュアーチェックリスト（最小）
- [ ] SQLファイル（ry_20250416.sql、quartz.sql）が最新であることを確認
- [ ] テーブル定義とJavaエンティティの整合性を確認
- [ ] 外部キー制約が適切に設定されているかを確認
- [ ] インデックス定義が性能要件を満たすかを確認
- [ ] 論理削除の運用ルールが明確かを確認
