# データベース設計書

## 概要

本ドキュメントは、RuoYiフレームワークのデータベース設計について記載します。RuoYiは、企業向け管理システムの開発基盤として設計されており、ユーザー管理、権限管理、システム監視、コード生成などの機能を提供します。データベースはMySQL（InnoDB）を使用し、合計31テーブルで構成されています。

## テーブル一覧

### システム管理系テーブル（20テーブル）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| sys_dept | SysDept | 部門情報を管理（階層構造対応） |
| sys_user | SysUser | ユーザー情報を管理 |
| sys_post | SysPost | 岗位（役職）情報を管理 |
| sys_role | SysRole | ロール（役割）情報を管理 |
| sys_menu | SysMenu | メニュー・権限情報を管理 |
| sys_user_role | SysUserRole | ユーザーとロールの関連を管理 |
| sys_role_menu | SysRoleMenu | ロールとメニューの関連を管理 |
| sys_role_dept | SysRoleDept | ロールと部門の関連を管理 |
| sys_user_post | SysUserPost | ユーザーと岗位の関連を管理 |
| sys_oper_log | SysOperLog | 操作ログを記録 |
| sys_dict_type | SysDictType | 辞書タイプを管理 |
| sys_dict_data | SysDictData | 辞書データを管理 |
| sys_config | SysConfig | システムパラメータ設定を管理 |
| sys_logininfor | SysLogininfor | ログイン履歴を記録 |
| sys_user_online | SysUserOnline | オンラインユーザーセッションを管理 |
| sys_job | SysJob | 定時タスクを管理 |
| sys_job_log | SysJobLog | 定時タスク実行ログを記録 |
| sys_notice | SysNotice | 通知・公告を管理 |
| gen_table | GenTable | コード生成用テーブル定義を管理 |
| gen_table_column | GenTableColumn | コード生成用カラム定義を管理 |

### Quartz定時タスク系テーブル（11テーブル）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| QRTZ_JOB_DETAILS | - | Quartzジョブ詳細情報 |
| QRTZ_TRIGGERS | - | Quartzトリガー情報 |
| QRTZ_SIMPLE_TRIGGERS | - | Quartz単純トリガー情報 |
| QRTZ_CRON_TRIGGERS | - | Quartz Cronトリガー情報 |
| QRTZ_BLOB_TRIGGERS | - | Quartz Blobトリガー情報 |
| QRTZ_CALENDARS | - | Quartzカレンダー情報 |
| QRTZ_PAUSED_TRIGGER_GRPS | - | Quartz一時停止トリガーグループ情報 |
| QRTZ_FIRED_TRIGGERS | - | Quartz実行済みトリガー情報 |
| QRTZ_SCHEDULER_STATE | - | Quartzスケジューラ状態情報 |
| QRTZ_LOCKS | - | Quartzロック情報 |
| QRTZ_SIMPROP_TRIGGERS | - | Quartzプロパティ付きトリガー情報 |

## 各テーブル定義

### 1. sys_dept（部門表）

部門情報を階層構造で管理するテーブル。親部門IDと祖先リストにより、ツリー構造を表現する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| dept_id | bigint(20) | NO | 部門ID（主キー、自動採番） |
| parent_id | bigint(20) | YES | 父部門ID（デフォルト: 0） |
| ancestors | varchar(50) | YES | 祖級リスト（カンマ区切りの親ID一覧） |
| dept_name | varchar(30) | YES | 部門名称 |
| order_num | int(4) | YES | 表示順序 |
| leader | varchar(20) | YES | 責任者 |
| phone | varchar(11) | YES | 連絡電話 |
| email | varchar(50) | YES | メールアドレス |
| status | char(1) | YES | 部門状態（0: 正常、1: 停止） |
| del_flag | char(1) | YES | 削除フラグ（0: 存在、2: 削除済） |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |

### 2. sys_user（ユーザー情報表）

システムユーザーの基本情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| user_id | bigint(20) | NO | ユーザーID（主キー、自動採番） |
| dept_id | bigint(20) | YES | 部門ID |
| login_name | varchar(30) | NO | ログインアカウント |
| user_name | varchar(30) | YES | ユーザー名（ニックネーム） |
| user_type | varchar(2) | YES | ユーザータイプ（00: システムユーザー、01: 登録ユーザー） |
| email | varchar(50) | YES | メールアドレス |
| phonenumber | varchar(11) | YES | 電話番号 |
| sex | char(1) | YES | 性別（0: 男、1: 女、2: 不明） |
| avatar | varchar(100) | YES | アバター画像パス |
| password | varchar(50) | YES | パスワード（暗号化済） |
| salt | varchar(20) | YES | パスワードソルト |
| status | char(1) | YES | アカウント状態（0: 正常、1: 停止） |
| del_flag | char(1) | YES | 削除フラグ（0: 存在、2: 削除済） |
| login_ip | varchar(128) | YES | 最終ログインIP |
| login_date | datetime | YES | 最終ログイン日時 |
| pwd_update_date | datetime | YES | パスワード最終更新日時 |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 3. sys_post（岗位情報表）

岗位（役職）情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| post_id | bigint(20) | NO | 岗位ID（主キー、自動採番） |
| post_code | varchar(64) | NO | 岗位コード |
| post_name | varchar(50) | NO | 岗位名称 |
| post_sort | int(4) | NO | 表示順序 |
| status | char(1) | NO | 状態（0: 正常、1: 停止） |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 4. sys_role（ロール情報表）

ロール（役割）情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| role_id | bigint(20) | NO | ロールID（主キー、自動採番） |
| role_name | varchar(30) | NO | ロール名称 |
| role_key | varchar(100) | NO | ロール権限文字列 |
| role_sort | int(4) | NO | 表示順序 |
| data_scope | char(1) | YES | データ範囲（1: 全データ、2: カスタム、3: 本部門、4: 本部門以下） |
| status | char(1) | NO | ロール状態（0: 正常、1: 停止） |
| del_flag | char(1) | YES | 削除フラグ（0: 存在、2: 削除済） |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 5. sys_menu（メニュー権限表）

システムメニューと権限情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| menu_id | bigint(20) | NO | メニューID（主キー、自動採番） |
| menu_name | varchar(50) | NO | メニュー名称 |
| parent_id | bigint(20) | YES | 親メニューID |
| order_num | int(4) | YES | 表示順序 |
| url | varchar(200) | YES | リクエストURL |
| target | varchar(20) | YES | 開き方（menuItem: 現ページ、menuBlank: 新ウィンドウ） |
| menu_type | char(1) | YES | メニュータイプ（M: ディレクトリ、C: メニュー、F: ボタン） |
| visible | char(1) | YES | 表示状態（0: 表示、1: 非表示） |
| is_refresh | char(1) | YES | リフレッシュ有無（0: する、1: しない） |
| perms | varchar(100) | YES | 権限識別子 |
| icon | varchar(100) | YES | メニューアイコン |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 6. sys_user_role（ユーザーロール関連表）

ユーザーとロールの多対多関係を管理する中間テーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| user_id | bigint(20) | NO | ユーザーID（複合主キー） |
| role_id | bigint(20) | NO | ロールID（複合主キー） |

### 7. sys_role_menu（ロールメニュー関連表）

ロールとメニューの多対多関係を管理する中間テーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| role_id | bigint(20) | NO | ロールID（複合主キー） |
| menu_id | bigint(20) | NO | メニューID（複合主キー） |

### 8. sys_role_dept（ロール部門関連表）

ロールと部門の多対多関係を管理する中間テーブル（データ権限用）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| role_id | bigint(20) | NO | ロールID（複合主キー） |
| dept_id | bigint(20) | NO | 部門ID（複合主キー） |

### 9. sys_user_post（ユーザー岗位関連表）

ユーザーと岗位の多対多関係を管理する中間テーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| user_id | bigint(20) | NO | ユーザーID（複合主キー） |
| post_id | bigint(20) | NO | 岗位ID（複合主キー） |

### 10. sys_oper_log（操作ログ記録表）

システム操作ログを記録するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| oper_id | bigint(20) | NO | ログID（主キー、自動採番） |
| title | varchar(50) | YES | モジュール名 |
| business_type | int(2) | YES | 業務タイプ（0: その他、1: 追加、2: 変更、3: 削除） |
| method | varchar(200) | YES | メソッド名 |
| request_method | varchar(10) | YES | リクエスト方式 |
| operator_type | int(1) | YES | 操作者タイプ（0: その他、1: 管理者、2: モバイルユーザー） |
| oper_name | varchar(50) | YES | 操作者名 |
| dept_name | varchar(50) | YES | 部門名 |
| oper_url | varchar(255) | YES | リクエストURL |
| oper_ip | varchar(128) | YES | 操作元IP |
| oper_location | varchar(255) | YES | 操作場所 |
| oper_param | varchar(2000) | YES | リクエストパラメータ |
| json_result | varchar(2000) | YES | レスポンス結果 |
| status | int(1) | YES | 操作状態（0: 正常、1: 異常） |
| error_msg | varchar(2000) | YES | エラーメッセージ |
| oper_time | datetime | YES | 操作日時 |
| cost_time | bigint(20) | YES | 処理時間（ミリ秒） |

**インデックス:**
- idx_sys_oper_log_bt: business_type
- idx_sys_oper_log_s: status
- idx_sys_oper_log_ot: oper_time

### 11. sys_dict_type（辞書タイプ表）

システム辞書のタイプ定義を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| dict_id | bigint(20) | NO | 辞書ID（主キー、自動採番） |
| dict_name | varchar(100) | YES | 辞書名称 |
| dict_type | varchar(100) | YES | 辞書タイプ（ユニーク制約あり） |
| status | char(1) | YES | 状態（0: 正常、1: 停止） |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 12. sys_dict_data（辞書データ表）

システム辞書の具体的なデータを管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| dict_code | bigint(20) | NO | 辞書コード（主キー、自動採番） |
| dict_sort | int(4) | YES | 表示順序 |
| dict_label | varchar(100) | YES | 辞書ラベル |
| dict_value | varchar(100) | YES | 辞書値 |
| dict_type | varchar(100) | YES | 辞書タイプ |
| css_class | varchar(100) | YES | CSSクラス |
| list_class | varchar(100) | YES | リスト表示クラス |
| is_default | char(1) | YES | デフォルト設定（Y: はい、N: いいえ） |
| status | char(1) | YES | 状態（0: 正常、1: 停止） |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 13. sys_config（パラメータ設定表）

システムパラメータ設定を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| config_id | int(5) | NO | パラメータID（主キー、自動採番） |
| config_name | varchar(100) | YES | パラメータ名称 |
| config_key | varchar(100) | YES | パラメータキー |
| config_value | varchar(500) | YES | パラメータ値 |
| config_type | char(1) | YES | システム組み込み（Y: はい、N: いいえ） |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 14. sys_logininfor（システムアクセス記録表）

ユーザーのログイン履歴を記録するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| info_id | bigint(20) | NO | アクセスID（主キー、自動採番） |
| login_name | varchar(50) | YES | ログインアカウント |
| ipaddr | varchar(128) | YES | ログインIP |
| login_location | varchar(255) | YES | ログイン場所 |
| browser | varchar(50) | YES | ブラウザタイプ |
| os | varchar(50) | YES | OS |
| status | char(1) | YES | ログイン状態（0: 成功、1: 失敗） |
| msg | varchar(255) | YES | メッセージ |
| login_time | datetime | YES | アクセス日時 |

**インデックス:**
- idx_sys_logininfor_s: status
- idx_sys_logininfor_lt: login_time

### 15. sys_user_online（オンラインユーザー記録表）

現在オンラインのユーザーセッション情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sessionId | varchar(50) | NO | セッションID（主キー） |
| login_name | varchar(50) | YES | ログインアカウント |
| dept_name | varchar(50) | YES | 部門名 |
| ipaddr | varchar(128) | YES | ログインIP |
| login_location | varchar(255) | YES | ログイン場所 |
| browser | varchar(50) | YES | ブラウザタイプ |
| os | varchar(50) | YES | OS |
| status | varchar(10) | YES | 状態（on_line: オンライン、off_line: オフライン） |
| start_timestamp | datetime | YES | セッション作成日時 |
| last_access_time | datetime | YES | 最終アクセス日時 |
| expire_time | int(5) | YES | タイムアウト時間（分） |

### 16. sys_job（定時タスク調度表）

定時タスクの設定情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| job_id | bigint(20) | NO | タスクID（複合主キー、自動採番） |
| job_name | varchar(64) | NO | タスク名称（複合主キー） |
| job_group | varchar(64) | NO | タスクグループ（複合主キー） |
| invoke_target | varchar(500) | NO | 呼び出し対象文字列 |
| cron_expression | varchar(255) | YES | cron実行式 |
| misfire_policy | varchar(20) | YES | 実行失敗時ポリシー（1: 即実行、2: 1回実行、3: 放棄） |
| concurrent | char(1) | YES | 並列実行可否（0: 許可、1: 禁止） |
| status | char(1) | YES | 状態（0: 正常、1: 一時停止） |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 17. sys_job_log（定時タスク実行ログ表）

定時タスクの実行履歴を記録するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| job_log_id | bigint(20) | NO | タスクログID（主キー、自動採番） |
| job_name | varchar(64) | NO | タスク名称 |
| job_group | varchar(64) | NO | タスクグループ |
| invoke_target | varchar(500) | NO | 呼び出し対象文字列 |
| job_message | varchar(500) | YES | ログ情報 |
| status | char(1) | YES | 実行状態（0: 正常、1: 失敗） |
| exception_info | varchar(2000) | YES | 例外情報 |
| create_time | datetime | YES | 作成日時 |

### 18. sys_notice（通知公告表）

システム通知・公告を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| notice_id | int(4) | NO | 公告ID（主キー、自動採番） |
| notice_title | varchar(50) | NO | 公告タイトル |
| notice_type | char(1) | NO | 公告タイプ（1: 通知、2: 公告） |
| notice_content | longblob | YES | 公告内容 |
| status | char(1) | YES | 状態（0: 正常、1: クローズ） |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(255) | YES | 備考 |

### 19. gen_table（コード生成業務表）

コード生成機能で使用するテーブル定義情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| table_id | bigint(20) | NO | テーブルID（主キー、自動採番） |
| table_name | varchar(200) | YES | テーブル名 |
| table_comment | varchar(500) | YES | テーブル説明 |
| sub_table_name | varchar(64) | YES | 関連子テーブル名 |
| sub_table_fk_name | varchar(64) | YES | 子テーブル外部キー名 |
| class_name | varchar(100) | YES | エンティティクラス名 |
| tpl_category | varchar(200) | YES | テンプレート（crud: 単表、tree: ツリー、sub: 主従表） |
| package_name | varchar(100) | YES | 生成パッケージパス |
| module_name | varchar(30) | YES | 生成モジュール名 |
| business_name | varchar(30) | YES | 生成業務名 |
| function_name | varchar(50) | YES | 生成機能名 |
| function_author | varchar(50) | YES | 生成機能著者 |
| form_col_num | int(1) | YES | フォームレイアウト（1: 単列、2: 2列、3: 3列） |
| gen_type | char(1) | YES | 生成方式（0: ZIP、1: カスタムパス） |
| gen_path | varchar(200) | YES | 生成パス |
| options | varchar(1000) | YES | その他生成オプション |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |
| remark | varchar(500) | YES | 備考 |

### 20. gen_table_column（コード生成業務表フィールド）

コード生成機能で使用するカラム定義情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| column_id | bigint(20) | NO | カラムID（主キー、自動採番） |
| table_id | bigint(20) | YES | 所属テーブルID |
| column_name | varchar(200) | YES | カラム名 |
| column_comment | varchar(500) | YES | カラム説明 |
| column_type | varchar(100) | YES | カラムタイプ |
| java_type | varchar(500) | YES | Javaタイプ |
| java_field | varchar(200) | YES | Javaフィールド名 |
| is_pk | char(1) | YES | 主キーか（1: はい） |
| is_increment | char(1) | YES | 自動採番か（1: はい） |
| is_required | char(1) | YES | 必須か（1: はい） |
| is_insert | char(1) | YES | 挿入フィールドか（1: はい） |
| is_edit | char(1) | YES | 編集フィールドか（1: はい） |
| is_list | char(1) | YES | リストフィールドか（1: はい） |
| is_query | char(1) | YES | クエリフィールドか（1: はい） |
| query_type | varchar(200) | YES | クエリ方式（EQ、NE、GT、LT、RANGE等） |
| html_type | varchar(200) | YES | 表示タイプ（テキスト、セレクト、日付等） |
| dict_type | varchar(200) | YES | 辞書タイプ |
| sort | int | YES | 表示順序 |
| create_by | varchar(64) | YES | 作成者 |
| create_time | datetime | YES | 作成日時 |
| update_by | varchar(64) | YES | 更新者 |
| update_time | datetime | YES | 更新日時 |

### 21. QRTZ_JOB_DETAILS（Quartzジョブ詳細情報表）

Quartzスケジューラのジョブ詳細情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| job_name | varchar(200) | NO | ジョブ名（複合主キー） |
| job_group | varchar(200) | NO | ジョブグループ（複合主キー） |
| description | varchar(250) | YES | 説明 |
| job_class_name | varchar(250) | NO | 実行クラス名 |
| is_durable | varchar(1) | NO | 永続化フラグ |
| is_nonconcurrent | varchar(1) | NO | 非並列フラグ |
| is_update_data | varchar(1) | NO | データ更新フラグ |
| requests_recovery | varchar(1) | NO | リカバリ要求フラグ |
| job_data | blob | YES | ジョブデータ |

### 22. QRTZ_TRIGGERS（Quartzトリガー情報表）

Quartzスケジューラのトリガー情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| trigger_name | varchar(200) | NO | トリガー名（複合主キー） |
| trigger_group | varchar(200) | NO | トリガーグループ（複合主キー） |
| job_name | varchar(200) | NO | ジョブ名（外部キー） |
| job_group | varchar(200) | NO | ジョブグループ（外部キー） |
| description | varchar(250) | YES | 説明 |
| next_fire_time | bigint(13) | YES | 次回発火時刻（ミリ秒） |
| prev_fire_time | bigint(13) | YES | 前回発火時刻（ミリ秒） |
| priority | integer | YES | 優先度 |
| trigger_state | varchar(16) | NO | トリガー状態 |
| trigger_type | varchar(8) | NO | トリガータイプ |
| start_time | bigint(13) | NO | 開始時刻 |
| end_time | bigint(13) | YES | 終了時刻 |
| calendar_name | varchar(200) | YES | カレンダー名 |
| misfire_instr | smallint(2) | YES | ミスファイア命令 |
| job_data | blob | YES | ジョブデータ |

### 23. QRTZ_SIMPLE_TRIGGERS（Quartz単純トリガー表）

単純トリガーの情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| trigger_name | varchar(200) | NO | トリガー名（複合主キー） |
| trigger_group | varchar(200) | NO | トリガーグループ（複合主キー） |
| repeat_count | bigint(7) | NO | 繰り返し回数 |
| repeat_interval | bigint(12) | NO | 繰り返し間隔 |
| times_triggered | bigint(10) | NO | 発火済み回数 |

### 24. QRTZ_CRON_TRIGGERS（Quartz Cronトリガー表）

Cron式ベースのトリガー情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| trigger_name | varchar(200) | NO | トリガー名（複合主キー） |
| trigger_group | varchar(200) | NO | トリガーグループ（複合主キー） |
| cron_expression | varchar(200) | NO | Cron式 |
| time_zone_id | varchar(80) | YES | タイムゾーンID |

### 25. QRTZ_BLOB_TRIGGERS（Quartz Blobトリガー表）

Blob形式のトリガー情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| trigger_name | varchar(200) | NO | トリガー名（複合主キー） |
| trigger_group | varchar(200) | NO | トリガーグループ（複合主キー） |
| blob_data | blob | YES | Blobデータ |

### 26. QRTZ_CALENDARS（Quartzカレンダー表）

スケジューリングのカレンダー情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| calendar_name | varchar(200) | NO | カレンダー名（複合主キー） |
| calendar | blob | NO | カレンダーデータ |

### 27. QRTZ_PAUSED_TRIGGER_GRPS（Quartz一時停止トリガーグループ表）

一時停止中のトリガーグループ情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| trigger_group | varchar(200) | NO | トリガーグループ（複合主キー） |

### 28. QRTZ_FIRED_TRIGGERS（Quartz発火済みトリガー表）

発火済みトリガーの情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| entry_id | varchar(95) | NO | エントリID（複合主キー） |
| trigger_name | varchar(200) | NO | トリガー名 |
| trigger_group | varchar(200) | NO | トリガーグループ |
| instance_name | varchar(200) | NO | インスタンス名 |
| fired_time | bigint(13) | NO | 発火時刻 |
| sched_time | bigint(13) | NO | スケジュール時刻 |
| priority | integer | NO | 優先度 |
| state | varchar(16) | NO | 状態 |
| job_name | varchar(200) | YES | ジョブ名 |
| job_group | varchar(200) | YES | ジョブグループ |
| is_nonconcurrent | varchar(1) | YES | 非並列フラグ |
| requests_recovery | varchar(1) | YES | リカバリ要求フラグ |

### 29. QRTZ_SCHEDULER_STATE（Quartzスケジューラ状態表）

スケジューラの状態情報を管理するテーブル（クラスタ対応）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| instance_name | varchar(200) | NO | インスタンス名（複合主キー） |
| last_checkin_time | bigint(13) | NO | 最終チェックイン時刻 |
| checkin_interval | bigint(13) | NO | チェックイン間隔 |

### 30. QRTZ_LOCKS（Quartzロック表）

悲観的ロック情報を管理するテーブル。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| lock_name | varchar(40) | NO | ロック名（複合主キー） |

### 31. QRTZ_SIMPROP_TRIGGERS（Quartzプロパティトリガー表）

プロパティ付きトリガーの情報を管理するテーブル（クラスタ同期用）。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| sched_name | varchar(120) | NO | スケジューラ名（複合主キー） |
| trigger_name | varchar(200) | NO | トリガー名（複合主キー） |
| trigger_group | varchar(200) | NO | トリガーグループ（複合主キー） |
| str_prop_1 | varchar(512) | YES | 文字列プロパティ1 |
| str_prop_2 | varchar(512) | YES | 文字列プロパティ2 |
| str_prop_3 | varchar(512) | YES | 文字列プロパティ3 |
| int_prop_1 | int | YES | 整数プロパティ1 |
| int_prop_2 | int | YES | 整数プロパティ2 |
| long_prop_1 | bigint | YES | 長整数プロパティ1 |
| long_prop_2 | bigint | YES | 長整数プロパティ2 |
| dec_prop_1 | numeric(13,4) | YES | 小数プロパティ1 |
| dec_prop_2 | numeric(13,4) | YES | 小数プロパティ2 |
| bool_prop_1 | varchar(1) | YES | 真偽値プロパティ1 |
| bool_prop_2 | varchar(1) | YES | 真偽値プロパティ2 |

## 備考

### ストレージエンジン
- 全テーブルでInnoDBストレージエンジンを使用
- トランザクション対応、外部キー制約対応

### 文字コード
- MySQL標準設定に依存（UTF-8推奨）

### 論理削除
- sys_dept、sys_user、sys_roleテーブルでは論理削除（del_flag）を採用
- del_flag = '0': 存在、del_flag = '2': 削除済み

### 監査カラム
- 多くのテーブルで共通の監査カラム（create_by、create_time、update_by、update_time）を持つ
- 作成者・更新者の追跡が可能

### 状態管理
- status カラムにより有効/無効状態を管理
- 一般的に '0' が正常/有効、'1' が停止/無効

### Quartzテーブル
- Quartz Schedulerライブラリの標準テーブル構造
- クラスタ対応の分散スケジューリングをサポート
