---
generated_at: 2026-01-08 12:00:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、特に優先レビューが必要な項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sql/ry_20250416.sql` - sys_jobテーブル定義とINSERTデータ（616-618行目）
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/task/RyTask.java` - タスク実装クラス
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` - ジョブドメインクラス
- E-04: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/JobInvokeUtil.java` - ジョブ実行ユーティリティ
- E-05: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/AbstractQuartzJob.java` - 抽象Quartzジョブクラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ryTask.ryNoParamsはシステムデフォルトの無参タスク | E-01 (job_id=1), E-02 (ryNoParamsメソッド) | ○ |
| C-02 | ryNoParamsのCron式は0/10 * * * * ? | E-01 (cron_expression) | ○ |
| C-03 | ryTask.ryParamsはシステムデフォルトの有参タスク | E-01 (job_id=2), E-02 (ryParamsメソッド) | ○ |
| C-04 | ryParamsのCron式は0/15 * * * * ? | E-01 (cron_expression) | ○ |
| C-05 | ryTask.ryMultipleParamsはシステムデフォルトの多参タスク | E-01 (job_id=3), E-02 (ryMultipleParamsメソッド) | ○ |
| C-06 | ryMultipleParamsのCron式は0/20 * * * * ? | E-01 (cron_expression) | ○ |
| C-07 | 全タスクは並発禁止（concurrent='1'） | E-01 (concurrent列) | ○ |
| C-08 | 全タスクはデフォルトで一時停止状態（status='1'） | E-01 (status列) | ○ |
| C-09 | タスク実行時にコンソール出力を行う | E-02 (System.out.println呼び出し) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全ての主張がソースコードおよびSQLファイルで確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠があり、ソースコードとSQL定義から直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] sys_jobテーブルに登録されているジョブ数が3件であることを確認
- [ ] RyTask.javaに定義されているメソッド数が3つであることを確認
- [ ] 各ジョブのCron式が正しく記載されていることを確認
- [ ] 実運用環境で追加されたカスタムジョブがある場合、本一覧への追加が必要
