# バッチ設計書 2-ryTask.ryParams

## 概要

本ドキュメントは、RuoYiシステムにおける定時タスク「ryTask.ryParams」（システムデフォルト・有参）のバッチ設計書である。Quartzスケジューラを利用した文字列パラメータを受け取る定時タスク実行処理について記述する。

### 本バッチの処理概要

本バッチは、システムの定時タスク機能のパラメータ渡し機能の動作確認を目的としたテスト用バッチである。文字列パラメータを1つ受け取り、コンソールに「执行有参方法：{params}」（有参メソッド実行：{パラメータ値}）というメッセージを出力する。

**業務上の目的・背景**：本バッチは、RuoYiシステムのQuartzベースの定時タスクスケジューリング機能において、パラメータ付きタスクの設定・実行が正常に動作することを確認するためのテスト用タスクとして提供されている。JobInvokeUtilによるinvokeTarget文字列のパース処理と、リフレクションを使ったパラメータ付きメソッド呼び出しの検証に使用される。定時タスクの動的パラメータ設定機能を開発者が理解・検証するための参照実装である。

**バッチの実行タイミング**：Cron式「0/15 * * * * ?」により15秒ごとに実行されるが、デフォルトで一時停止状態に設定されている。管理画面から有効化し、必要に応じてパラメータを変更して実行できる。

**主要な処理内容**：
1. Quartzスケジューラによるジョブのトリガー
2. JobInvokeUtilによるinvokeTarget文字列のパース（Bean名、メソッド名、パラメータの抽出）
3. パラメータの型判定と変換（文字列として認識）
4. RyTaskクラスのryParamsメソッドの実行
5. パラメータ値を含むメッセージのコンソール出力
6. 実行ログのデータベースへの記録

**前後の処理との関連**：本バッチは単独で動作するテスト用タスクであり、他のバッチとの依存関係はない。ryTask.ryNoParamsの上位互換として、パラメータ処理の検証に使用される。

**影響範囲**：本バッチの実行により、sys_job_logテーブルに実行ログが追加される。システムのコンソール（標準出力）にパラメータ値を含むメッセージが出力される。

## バッチ種別

テスト・動作確認用タスク

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 15秒毎（デフォルト停止状態） |
| 実行時刻 | 毎分0秒、15秒、30秒、45秒 |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | Cron（0/15 * * * * ?） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Quartzスケジューラ起動 | Spring Bootアプリケーション起動時にスケジューラが初期化されていること |
| タスク状態が正常 | sys_jobテーブルのstatus列が'0'（正常）であること |
| ryTaskビーン登録 | RyTaskクラスがSpringコンテナにBean登録されていること |
| invokeTarget設定 | パラメータを含むinvokeTarget文字列が正しく設定されていること |

### 実行可否判定

- sys_jobテーブルのstatus='0'（正常）の場合のみ実行される
- concurrent='1'（並発禁止）のため、前回実行が完了していない場合は新規実行されない
- invokeTargetのパラメータ部分のパースに失敗した場合、例外が発生して処理中断

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| params | String | Yes | 'ry' | 出力メッセージに含まれる文字列パラメータ |

### パラメータの指定方法

invokeTarget文字列内でパラメータを指定する：
- 形式：`ryTask.ryParams('パラメータ値')`
- 文字列パラメータはシングルクォートまたはダブルクォートで囲む
- デフォルト設定：`ryTask.ryParams('ry')`

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| sys_job | DB | タスク定義情報（invoke_target、cron_expression等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| sys_job_log | DB | タスク実行ログ |
| 標準出力 | コンソール | 「执行有参方法：{params}」メッセージ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. Quartzトリガー発火
   └─ Cron式に基づきQuartzがジョブをトリガー
2. AbstractQuartzJob#execute実行
   └─ JobExecutionContextからSysJob情報を取得
3. before処理
   └─ 開始時刻をThreadLocalに記録
4. doExecute実行（QuartzDisallowConcurrentExecution）
   └─ JobInvokeUtil#invokeMethodを呼び出し
5. invokeTargetパース
   └─ beanName: ryTask, methodName: ryParams, params: ['ry'] を抽出
6. パラメータ解析
   └─ シングルクォートで囲まれた値をString型として認識
7. Beanの取得
   └─ SpringUtils.getBean("ryTask")でRyTaskインスタンス取得
8. メソッド呼び出し
   └─ リフレクションでryParams(String)を特定
9. メソッド実行
   └─ RyTask#ryParams("ry")を実行
10. メッセージ出力
    └─ System.out.println("执行有参方法：ry")
11. after処理
    └─ 終了時刻を記録、実行時間を計算
12. ログ記録
    └─ sys_job_logテーブルにINSERT
```

### フローチャート

```mermaid
flowchart TD
    A[Quartzトリガー発火] --> B[AbstractQuartzJob#execute]
    B --> C[before: 開始時刻記録]
    C --> D[doExecute呼び出し]
    D --> E[JobInvokeUtil#invokeMethod]
    E --> F[getBeanName: ryTask抽出]
    F --> G[getMethodName: ryParams抽出]
    G --> H[getMethodParams: パラメータ解析]
    H --> I{パラメータの型判定}
    I -->|'または"で開始| J[String型として認識]
    J --> K[SpringUtils.getBean取得]
    K --> L[getMethodParamsType: Class配列作成]
    L --> M[getMethod: メソッド取得]
    M --> N[method.invoke: メソッド実行]
    N --> O[ryParams実行]
    O --> P[コンソール出力]
    P --> Q[after: 終了時刻記録]
    Q --> R{例外発生?}
    R -->|No| S[status=SUCCESS]
    R -->|Yes| T[status=FAIL, 例外情報記録]
    S --> U[sys_job_logにINSERT]
    T --> U
    U --> V[処理終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ログ記録 | sys_job_log | INSERT | タスク実行結果をログテーブルに記録 |

### テーブル別操作詳細

#### sys_job_log

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | job_name | SysJob#jobNameの値（システムデフォルト（有参）） | タスク名称 |
| INSERT | job_group | SysJob#jobGroupの値（DEFAULT） | タスクグループ |
| INSERT | invoke_target | ryTask.ryParams('ry') | 呼び出し対象文字列 |
| INSERT | job_message | "{job_name} 总共耗时：{n}毫秒" | 実行結果メッセージ |
| INSERT | status | '0'（成功）または'1'（失敗） | 実行状態 |
| INSERT | exception_info | 例外発生時のスタックトレース（最大2000文字） | エラー時のみ |
| INSERT | start_time | 実行開始日時 | before処理で記録 |
| INSERT | end_time | 実行終了日時 | after処理で記録 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NoSuchMethodException | ryParams(String)メソッドが存在しない、またはシグネチャ不一致 | RyTaskクラスの実装を確認 |
| - | IllegalAccessException | メソッドへのアクセス権限がない | メソッドのアクセス修飾子を確認 |
| - | IllegalArgumentException | パラメータの型が不一致 | invokeTargetの記述形式を確認 |
| - | InvocationTargetException | メソッド実行中に例外発生 | メソッド内の実装を確認 |
| - | BeanNotFoundException | ryTaskビーンが見つからない | @Component設定を確認 |
| - | StringIndexOutOfBoundsException | パラメータのクォート記述が不正 | invokeTargetの引用符を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. sys_job_logテーブルでstatus='1'のレコードを確認
2. exception_infoカラムからエラー内容を特定
3. invokeTargetの形式が正しいか確認（特にクォートの対応）
4. 必要に応じてタスクを一時停止（status='1'に更新）
5. 管理画面から手動で「即時実行」して動作確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ログ記録処理のみ |
| コミットタイミング | ログINSERT完了時 |
| ロールバック条件 | ログ記録中の例外発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件/実行 |
| 目標処理時間 | 100ms以内 |
| メモリ使用量上限 | 特に制限なし（軽量処理） |

## 排他制御

- concurrent='1'（並発禁止）により、同一ジョブの並発実行は禁止
- @DisallowConcurrentExecutionアノテーションにより、Quartzレベルで排他制御
- 前回実行が完了するまで次回実行はスキップされる

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | 標準では出力なし |
| 進捗ログ | なし | 標準では出力なし |
| 終了ログ | バッチ終了時 | DB（sys_job_log）に記録 |
| エラーログ | エラー発生時 | "任务执行异常 - ："+ スタックトレース |
| 業務ログ | メソッド実行時 | "执行有参方法：{params}"（標準出力） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 設定なし | - |
| エラー件数 | 設定なし | - |

※本バッチはテスト用のため、監視・アラート設定は行われていない

## 備考

- 本バッチはRuoYiフレームワークが提供するサンプル定時タスクであり、パラメータ渡し機能の検証用
- デフォルトで一時停止状態（status='1'）に設定されており、意図的に有効化しない限り実行されない
- パラメータはinvokeTarget内に直接記述する形式（管理画面から変更可能）
- invokeTargetの書式：`ryTask.ryParams('パラメータ値')`
  - シングルクォートまたはダブルクォートでパラメータを囲む
  - 文字列以外の場合はクォート不要（後述のryMultipleParams参照）
- JobInvokeUtil#getMethodParamsでの文字列パラメータ判定条件：
  - `StringUtils.startsWithAny(str, "'", "\"")`がtrueの場合String型
