---
generated_at: 2026-01-08 15:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-ryTask.ryParams.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：100ms以内という数値の根拠不足
  2. **パラメータのデフォルト値'ry'**：SQLデータで確認済み、ただし変更可能性あり
  3. **StringIndexOutOfBoundsExceptionの発生条件**：コードからの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/task/RyTask.java` - RyTaskクラス実装
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/AbstractQuartzJob.java` - 抽象Quartzジョブ基底クラス
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/JobInvokeUtil.java` - ジョブ呼び出しユーティリティ
- E-04: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/QuartzDisallowConcurrentExecution.java` - 並発禁止実行クラス
- E-05: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` - ジョブドメインクラス
- E-06: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` - ジョブログドメインクラス
- E-07: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobServiceImpl.java` - ジョブサービス実装
- E-08: `sql/ry_20250416.sql` - データベース初期化SQL（sys_job、sys_job_logテーブル定義、初期データ）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ryParamsメソッドは「执行有参方法：{params}」を出力する | E-01 (RyTask.java L19-22) | ○ |
| C-02 | ryParamsメソッドはString型パラメータを1つ受け取る | E-01 (RyTask.java L19) | ○ |
| C-03 | Cron式は「0/15 * * * * ?」で15秒毎に実行 | E-08 (ry_20250416.sql L617)、E-09 | ○ |
| C-04 | デフォルトで一時停止状態（status='1'） | E-08 (ry_20250416.sql L617) | ○ |
| C-05 | concurrent='1'で並発禁止 | E-08 (ry_20250416.sql L617) | ○ |
| C-06 | デフォルトパラメータは'ry' | E-08 (ry_20250416.sql L617: `ryTask.ryParams('ry')`) | ○ |
| C-07 | getBeanNameでBean名を抽出 | E-03 (JobInvokeUtil.java L82-86) | ○ |
| C-08 | getMethodNameでメソッド名を抽出 | E-03 (JobInvokeUtil.java L94-98) | ○ |
| C-09 | getMethodParamsでパラメータを解析 | E-03 (JobInvokeUtil.java L106-145) | ○ |
| C-10 | シングルクォートまたはダブルクォートで始まる値はString型 | E-03 (JobInvokeUtil.java L119-122) | ○ |
| C-11 | StringUtils.startsWithAny(str, "'", "\"")で文字列判定 | E-03 (JobInvokeUtil.java L119) | ○ |
| C-12 | getMethodParamsTypeでClass配列を作成 | E-03 (JobInvokeUtil.java L153-163) | ○ |
| C-13 | getMethodParamsValueでパラメータ値配列を作成 | E-03 (JobInvokeUtil.java L171-181) | ○ |
| C-14 | リフレクションでbean.getClass().getMethod()を呼び出し | E-03 (JobInvokeUtil.java L55) | ○ |
| C-15 | method.invoke(bean, args)でメソッド実行 | E-03 (JobInvokeUtil.java L56) | ○ |
| C-16 | sys_job_logに記録される項目一覧 | E-02 (AbstractQuartzJob.java L75-92)、E-06 | ○ |
| C-17 | 例外情報は最大2000文字まで記録 | E-02 (AbstractQuartzJob.java L86) | ○ |
| C-18 | invokeTargetの形式は「ryTask.ryParams('ry')」 | E-08 (ry_20250416.sql L617) | ○ |
| C-19 | RyTaskは@Component("ryTask")で登録 | E-01 (RyTask.java L11) | ○ |
| C-20 | 目標処理時間100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **目標処理時間（C-20）**：100ms以内という数値はコードベースに明示的な定義がなく、一般的なテストタスクの想定値として記載した推測値
  - 候補：パフォーマンス要件定義書 / 運用ガイドライン / システム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本バッチはテスト用タスクであり、業務影響なし
- 0: 低リスク - デフォルト停止状態のため、意図しない実行リスクなし
- 1: 中リスク - invokeTargetの記述ミス（クォートの不整合等）によるパースエラーの可能性
- 1: 中リスク - 有効化した場合、15秒毎のログ蓄積によるディスク使用量増加の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] RyTask.javaのryParamsメソッドの実装内容が設計書と一致しているか確認
- [ ] JobInvokeUtil.javaのパラメータパース処理（特にL119-122の文字列判定）を確認
- [ ] sys_job初期データのinvokeTarget、Cron式、status、concurrent設定が設計書と一致しているか確認
- [ ] パラメータにクォートを含む文字列を指定した場合の動作を検証（エスケープ処理の有無）
- [ ] パフォーマンス要件（100ms以内）の妥当性を業務要件と照らし合わせて確認
