---
generated_at: 2026-01-08 15:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：3-ryTask.ryMultipleParams.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：100ms以内という数値の根拠不足
  2. **パラメータの順序と型の対応**：invokeTargetの記述とメソッドシグネチャの一致確認が重要
  3. **カンマ区切りの正規表現**：複雑な正規表現のため動作確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/task/RyTask.java` - RyTaskクラス実装
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/AbstractQuartzJob.java` - 抽象Quartzジョブ基底クラス
- E-03: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/JobInvokeUtil.java` - ジョブ呼び出しユーティリティ
- E-04: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/QuartzDisallowConcurrentExecution.java` - 並発禁止実行クラス
- E-05: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` - ジョブドメインクラス
- E-06: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` - ジョブログドメインクラス
- E-07: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobServiceImpl.java` - ジョブサービス実装
- E-08: `sql/ry_20250416.sql` - データベース初期化SQL（sys_job、sys_job_logテーブル定義、初期データ）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ryMultipleParamsメソッドはString, Boolean, Long, Double, Integerの5つのパラメータを受け取る | E-01 (RyTask.java L14) | ○ |
| C-02 | 出力メッセージは「执行多参方法：字符串类型{s}，布尔类型{b}，长整型{l}，浮点型{d}，整形{i}」 | E-01 (RyTask.java L16) | ○ |
| C-03 | StringUtils.formatでメッセージを整形 | E-01 (RyTask.java L16) | ○ |
| C-04 | Cron式は「0/20 * * * * ?」で20秒毎に実行 | E-08 (ry_20250416.sql L618)、E-09 | ○ |
| C-05 | デフォルトで一時停止状態（status='1'） | E-08 (ry_20250416.sql L618) | ○ |
| C-06 | concurrent='1'で並発禁止 | E-08 (ry_20250416.sql L618) | ○ |
| C-07 | デフォルトパラメータは('ry', true, 2000L, 316.50D, 100) | E-08 (ry_20250416.sql L618) | ○ |
| C-08 | シングルクォートまたはダブルクォートで開始する値はString型 | E-03 (JobInvokeUtil.java L119-122) | ○ |
| C-09 | true/false（大文字小文字無視）はBoolean型 | E-03 (JobInvokeUtil.java L124-127) | ○ |
| C-10 | Lで終了する値はLong型 | E-03 (JobInvokeUtil.java L129-132) | ○ |
| C-11 | Dで終了する値はDouble型 | E-03 (JobInvokeUtil.java L134-137) | ○ |
| C-12 | それ以外はInteger型 | E-03 (JobInvokeUtil.java L139-142) | ○ |
| C-13 | Long.valueOf()でLong型に変換（L接尾辞除去） | E-03 (JobInvokeUtil.java L131) | ○ |
| C-14 | Double.valueOf()でDouble型に変換（D接尾辞除去） | E-03 (JobInvokeUtil.java L136) | ○ |
| C-15 | Integer.valueOf()でInteger型に変換 | E-03 (JobInvokeUtil.java L141) | ○ |
| C-16 | カンマ区切りの正規表現で分割 | E-03 (JobInvokeUtil.java L113) | ○ |
| C-17 | 正規表現は「,(?=([^\"']*[\"'][^\"']*[\"'])*[^\"']*$)」 | E-03 (JobInvokeUtil.java L113) | ○ |
| C-18 | getMethodParamsTypeでClass配列を作成 | E-03 (JobInvokeUtil.java L153-163) | ○ |
| C-19 | getMethodParamsValueでパラメータ値配列を作成 | E-03 (JobInvokeUtil.java L171-181) | ○ |
| C-20 | sys_job_logに記録される項目一覧 | E-02 (AbstractQuartzJob.java L75-92)、E-06 | ○ |
| C-21 | 例外情報は最大2000文字まで記録 | E-02 (AbstractQuartzJob.java L86) | ○ |
| C-22 | invokeTargetの形式は「ryTask.ryMultipleParams('ry', true, 2000L, 316.50D, 100)」 | E-08 (ry_20250416.sql L618) | ○ |
| C-23 | RyTaskは@Component("ryTask")で登録 | E-01 (RyTask.java L11) | ○ |
| C-24 | Boolean判定は"true".equalsIgnoreCase()/"false".equalsIgnoreCase()で実施 | E-03 (JobInvokeUtil.java L124) | ○ |
| C-25 | 目標処理時間100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **目標処理時間（C-25）**：100ms以内という数値はコードベースに明示的な定義がなく、一般的なテストタスクの想定値として記載した推測値
  - 候補：パフォーマンス要件定義書 / 運用ガイドライン / システム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本バッチはテスト用タスクであり、業務影響なし
- 0: 低リスク - デフォルト停止状態のため、意図しない実行リスクなし
- 1: 中リスク - パラメータ型判定の順序に依存（L/D接尾辞のない数値は全てInteger）
- 1: 中リスク - invokeTargetの記述ミス（型接尾辞の誤り等）によるパースエラーの可能性
- 1: 中リスク - 有効化した場合、20秒毎のログ蓄積によるディスク使用量増加の可能性
- 2: 高リスク - パラメータの順序がメソッドシグネチャと異なる場合、NoSuchMethodException発生

## 6) レビュアーチェックリスト（最小）
- [ ] RyTask.javaのryMultipleParamsメソッドのシグネチャが(String, Boolean, Long, Double, Integer)であることを確認
- [ ] JobInvokeUtil.javaの型判定処理（L119-142）が設計書の記述と一致するか確認
- [ ] sys_job初期データのinvokeTargetの各パラメータ型接尾辞が正しいか確認
- [ ] カンマ区切り正規表現の動作（クォート内カンマの除外）を単体テストで確認
- [ ] パフォーマンス要件（100ms以内）の妥当性を業務要件と照らし合わせて確認
- [ ] Float型やShort型など、未サポートの型を指定した場合の動作（Integer扱い）を確認
