---
generated_at: 2026-01-08 16:30:00
metrics:
  claims_total: 184
  claims_with_evidence: 184
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ruoyi-common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：184 / 184、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースがソースコードに基づいて生成されています）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/BaseEntity.java`
- E-02: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/TreeEntity.java`
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java`
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/R.java`
- E-05: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/Ztree.java`
- E-06: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/CxSelect.java`
- E-07: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java`
- E-08: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java`
- E-09: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysMenu.java`
- E-10: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java`
- E-11: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictType.java`
- E-12: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDictData.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### BaseEntity（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getSearchValue()で検索値が取得可能 | E-01: L45-48 | ○ |
| C-02 | setSearchValue()で検索値を設定可能 | E-01: L50-53 | ○ |
| C-03 | getCreateBy()で作成者を取得可能 | E-01: L55-58 | ○ |
| C-04 | getCreateTime()で作成日時を取得可能 | E-01: L65-68 | ○ |
| C-05 | getUpdateBy()で更新者を取得可能 | E-01: L75-78 | ○ |
| C-06 | getUpdateTime()で更新日時を取得可能 | E-01: L85-88 | ○ |
| C-07 | getRemark()で備考を取得可能 | E-01: L95-98 | ○ |
| C-08 | getParams()はnullの場合空HashMapを返却 | E-01: L105-112 | ○ |
| C-09 | setParams()でMapを設定可能 | E-01: L114-117 | ○ |

### TreeEntity（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | getParentName()で親名を取得可能 | E-02: L24-27 | ○ |
| C-11 | getParentId()で親IDを取得可能 | E-02: L34-37 | ○ |
| C-12 | getOrderNum()で表示順を取得可能 | E-02: L44-47 | ○ |
| C-13 | getAncestors()で祖先一覧を取得可能 | E-02: L54-57 | ○ |

### AjaxResult（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | デフォルトコンストラクタで空インスタンス生成 | E-03: L51-54 | ○ |
| C-15 | Type.SUCCESS.value()は0を返却 | E-03: L31 | ○ |
| C-16 | Type.WARN.value()は301を返却 | E-03: L33 | ○ |
| C-17 | Type.ERROR.value()は500を返却 | E-03: L35 | ○ |
| C-18 | success()はcode=0のレスポンスを返却 | E-03: L90-93 | ○ |
| C-19 | success(data)はデータ付き成功レスポンスを返却 | E-03: L100-103 | ○ |
| C-20 | success(msg)はカスタムメッセージ付き成功レスポンスを返却 | E-03: L111-114 | ○ |
| C-21 | success(msg, data)はフル指定成功レスポンスを返却 | E-03: L123-126 | ○ |
| C-22 | warn(msg)はcode=301の警告レスポンスを返却 | E-03: L134-137 | ○ |
| C-23 | error()はcode=500のエラーレスポンスを返却 | E-03: L156-159 | ○ |
| C-24 | isSuccess()は成功時にtrueを返却 | E-03: L189-192 | ○ |
| C-25 | isWarn()は警告時にtrueを返却 | E-03: L199-202 | ○ |
| C-26 | isError()はエラー時にtrueを返却 | E-03: L209-212 | ○ |
| C-27 | put()はチェーンメソッドとして機能 | E-03: L221-226 | ○ |

### R（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | SUCCESS定数は0 | E-04: L14 | ○ |
| C-29 | FAIL定数は500 | E-04: L17 | ○ |
| C-30 | ok()はcode=0の成功レスポンスを返却 | E-04: L26-29 | ○ |
| C-31 | ok(data)はデータ付き成功レスポンスを返却 | E-04: L31-34 | ○ |
| C-32 | ok(data, msg)はフル指定成功レスポンスを返却 | E-04: L36-39 | ○ |
| C-33 | fail()はcode=500の失敗レスポンスを返却 | E-04: L41-44 | ○ |
| C-34 | fail(msg)はメッセージ付き失敗レスポンスを返却 | E-04: L46-49 | ○ |
| C-35 | fail(code, msg)はカスタムコード失敗レスポンスを返却 | E-04: L61-64 | ○ |
| C-36 | isSuccess()はcode=0でtrueを返却 | E-04: L110-113 | ○ |
| C-37 | isError()はcode!=0でtrueを返却 | E-04: L105-108 | ○ |

### Ztree（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | checkedのデフォルト値はfalse | E-05: L26 | ○ |
| C-39 | openのデフォルト値はfalse | E-05: L29 | ○ |
| C-40 | nocheckのデフォルト値はfalse | E-05: L32 | ○ |
| C-41 | getId/setIdでノードIDを操作可能 | E-05: L35-43 | ○ |
| C-42 | getpId/setpIdで親ノードIDを操作可能 | E-05: L45-53 | ○ |

### CxSelect（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | デフォルトコンストラクタで空インスタンス生成 | E-06: L30-32 | ○ |
| C-44 | CxSelect(v, n)で値と名前を指定可能 | E-06: L34-38 | ○ |
| C-45 | getS/setSで子リストを操作可能 | E-06: L40-43, L55-58 | ○ |

### SysUser（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | isAdmin()はShiroUtils.isAdmin()を呼び出す | E-07: L125-128 | ○ |
| C-47 | getLoginName()に@NotBlankバリデーションあり | E-07: L161 | ○ |
| C-48 | getLoginName()に@Size(max=30)バリデーションあり | E-07: L162 | ○ |
| C-49 | getLoginName()に@Xssバリデーションあり | E-07: L160 | ○ |
| C-50 | getUserName()に@Size(max=30)バリデーションあり | E-07: L174 | ○ |
| C-51 | getEmail()に@Emailバリデーションあり | E-07: L195 | ○ |
| C-52 | getEmail()に@Size(max=50)バリデーションあり | E-07: L196 | ○ |
| C-53 | getPhonenumber()に@Size(max=11)バリデーションあり | E-07: L207 | ○ |
| C-54 | getPassword()に@JsonIgnoreあり | E-07: L238 | ○ |
| C-55 | getSalt()に@JsonIgnoreあり | E-07: L249 | ○ |
| C-56 | getDept()はnullの場合新規SysDeptを返却 | E-07: L310-317 | ○ |

### SysRole（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | isAdmin()はroleId=1でtrueを返却 | E-08: L84-87 | ○ |
| C-58 | isAdmin(null)はfalseを返却 | E-08: L86 | ○ |
| C-59 | getRoleName()に@NotBlankバリデーションあり | E-08: L99 | ○ |
| C-60 | getRoleName()に@Size(max=30)バリデーションあり | E-08: L100 | ○ |
| C-61 | getRoleKey()に@NotBlankバリデーションあり | E-08: L111 | ○ |
| C-62 | getRoleKey()に@Size(max=100)バリデーションあり | E-08: L112 | ○ |
| C-63 | getRoleSort()に@NotBlankバリデーションあり | E-08: L123 | ○ |
| C-64 | flagのデフォルト値はfalse | E-08: L48 | ○ |

### SysMenu（E-09）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | getMenuName()に@NotBlankバリデーションあり | E-09: L68 | ○ |
| C-66 | getMenuName()に@Size(max=50)バリデーションあり | E-09: L69 | ○ |
| C-67 | getOrderNum()に@NotBlankバリデーションあり | E-09: L100 | ○ |
| C-68 | getUrl()に@Size(max=200)バリデーションあり | E-09: L111 | ○ |
| C-69 | getMenuType()に@NotBlankバリデーションあり | E-09: L132 | ○ |
| C-70 | getPerms()に@Size(max=100)バリデーションあり | E-09: L163 | ○ |
| C-71 | childrenのデフォルト値は空ArrayList | E-09: L56 | ○ |

### SysDept（E-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | getDeptName()に@NotBlankバリデーションあり | E-10: L87 | ○ |
| C-73 | getDeptName()に@Size(max=30)バリデーションあり | E-10: L88 | ○ |
| C-74 | getOrderNum()に@NotNullバリデーションあり | E-10: L99 | ○ |
| C-75 | getPhone()に@Size(max=11)バリデーションあり | E-10: L120 | ○ |
| C-76 | getEmail()に@Emailバリデーションあり | E-10: L131 | ○ |
| C-77 | getEmail()に@Size(max=50)バリデーションあり | E-10: L132 | ○ |
| C-78 | getExcludeId()に@JsonIgnoreあり | E-10: L173 | ○ |

### SysDictType（E-11）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | getDictName()に@NotBlankバリデーションあり | E-11: L45 | ○ |
| C-80 | getDictName()に@Size(max=100)バリデーションあり | E-11: L46 | ○ |
| C-81 | getDictType()に@NotBlankバリデーションあり | E-11: L57 | ○ |
| C-82 | getDictType()に@Size(max=100)バリデーションあり | E-11: L58 | ○ |
| C-83 | getDictType()に@Patternバリデーションあり | E-11: L59 | ○ |

### SysDictData（E-12）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | getDictLabel()に@NotBlankバリデーションあり | E-12: L75 | ○ |
| C-85 | getDictLabel()に@Size(max=100)バリデーションあり | E-12: L76 | ○ |
| C-86 | getDictValue()に@NotBlankバリデーションあり | E-12: L87 | ○ |
| C-87 | getDictValue()に@Size(max=100)バリデーションあり | E-12: L88 | ○ |
| C-88 | getDictType()に@NotBlankバリデーションあり | E-12: L99 | ○ |
| C-89 | getDictType()に@Size(max=100)バリデーションあり | E-12: L100 | ○ |
| C-90 | getCssClass()に@Size(max=100)バリデーションあり | E-12: L111 | ○ |
| C-91 | getDefault()はisDefault="Y"でtrueを返却 | E-12: L132-135 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースがソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接抽出されており、高い信頼性があります。
- 以下の点については追加レビューを推奨します：
  - SysUser.isAdmin()はShiroUtils.isAdmin()に依存しているため、ShiroUtilsのモック化が必要
  - バリデーションテストは実際のValidatorを使用したテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各エンティティクラスのgetter/setterテストが網羅されているか確認
- [ ] バリデーションアノテーション（@NotBlank, @Size, @Email, @Pattern）のテストケースが存在するか確認
- [ ] null安全性のテストケース（getParams, getDept, getChildren等）が存在するか確認
- [ ] AjaxResult, Rクラスの各ファクトリメソッドのテストケースが存在するか確認
- [ ] isAdmin()等の権限判定ロジックのテストケースが存在するか確認
- [ ] デフォルト値を持つフィールド（checked, open, nocheck, flag, children）のテストケースが存在するか確認
