---
generated_at: 2026-01-08 16:30:00
metrics:
  claims_total: 173
  claims_with_evidence: 170
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：ruoyi-framework 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：170 / 173、根拠なし：3
- 優先レビュー（高）
  1. **UT-FRM-097 (Server.copyTo)**: OSHI ライブラリ依存の外部リソース取得
  2. **UT-FRM-108 (Jvm.getName)**: JVM内部APIへの依存
  3. **UT-FRM-159 (SpringSessionValidationScheduler)**: スケジューラ設定の外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java`
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysRegisterService.java`
- E-04: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysShiroService.java`
- E-05: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/PermissionService.java`
- E-06: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/CacheService.java`
- E-07: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/DictService.java`
- E-08: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/service/ConfigService.java`
- E-09: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java`
- E-10: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/DataScopeAspect.java`
- E-11: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/DataSourceAspect.java`
- E-12: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/PermissionsAspect.java`
- E-13: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/AsyncManager.java`
- E-14: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/ShutdownManager.java`
- E-15: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java`
- E-16: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/realm/UserRealm.java`
- E-17: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/session/OnlineSession.java`
- E-18: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/session/OnlineSessionDAO.java`
- E-19: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/session/OnlineSessionFactory.java`
- E-20: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java`
- E-21: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Cpu.java`
- E-22: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Mem.java`
- E-23: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Jvm.java`
- E-24: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/Sys.java`
- E-25: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/server/SysFile.java`
- E-26: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java`
- E-27: `ruoyi-framework/src/main/java/com/ruoyi/framework/interceptor/RepeatSubmitInterceptor.java`
- E-28: `ruoyi-framework/src/main/java/com/ruoyi/framework/interceptor/impl/SameUrlDataInterceptor.java`
- E-29: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/LogoutFilter.java`
- E-30: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/captcha/CaptchaValidateFilter.java`
- E-31: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/csrf/CsrfValidateFilter.java`
- E-32: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/sync/SyncOnlineSessionFilter.java`
- E-33: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/online/OnlineSessionFilter.java`
- E-34: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/kickout/KickoutSessionFilter.java`
- E-35: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/util/AuthorizationUtils.java`
- E-36: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/session/OnlineWebSessionManager.java`
- E-37: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/session/SpringSessionValidationScheduler.java`
- E-38: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/rememberMe/CustomCookieRememberMeManager.java`
- E-39: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/CustomShiroFilterFactoryBean.java`
- E-40: `ruoyi-framework/src/main/java/com/ruoyi/framework/datasource/DynamicDataSource.java`
- E-41: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/KaptchaTextCreator.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | SysPasswordService.validate メソッドの正常系テスト | E-01 (L42-69) | ○ |
| C-002 | SysPasswordService.validate メソッドのパスワード不一致テスト | E-01 (L59-64) | ○ |
| C-003 | SysPasswordService.validate メソッドのリトライ超過テスト | E-01 (L53-57) | ○ |
| C-004 | SysPasswordService.matches メソッドの正常系テスト | E-01 (L71-74) | ○ |
| C-005 | SysPasswordService.encryptPassword メソッドのテスト | E-01 (L81-84) | ○ |
| C-006 | SysPasswordService.clearLoginRecordCache メソッドのテスト | E-01 (L76-79) | ○ |
| C-007 | SysLoginService.login メソッドの正常系テスト | E-02 (L54-131) | ○ |
| C-008 | SysLoginService.login のユーザー名空チェック | E-02 (L63-67) | ○ |
| C-009 | SysLoginService.login のパスワード空チェック | E-02 (L63-67) | ○ |
| C-010 | SysLoginService.login のパスワード長チェック | E-02 (L69-74) | ○ |
| C-011 | SysLoginService.login のユーザー名長チェック | E-02 (L77-82) | ○ |
| C-012 | SysLoginService.login のIPブラックリストチェック | E-02 (L85-90) | ○ |
| C-013 | SysLoginService.login のユーザー存在チェック | E-02 (L107-111) | ○ |
| C-014 | SysLoginService.login の削除済みユーザーチェック | E-02 (L113-117) | ○ |
| C-015 | SysLoginService.login の無効化ユーザーチェック | E-02 (L119-123) | ○ |
| C-016 | SysLoginService.login のキャプチャエラーチェック | E-02 (L57-61) | ○ |
| C-017 | SysLoginService.setRolePermission メソッドの正常系テスト | E-02 (L158-173) | ○ |
| C-018 | SysLoginService.recordLoginInfo メソッドのテスト | E-02 (L180-183) | ○ |
| C-019 | SysRegisterService.register メソッドの正常系テスト | E-03 (L35-82) | ○ |
| C-020 | SysRegisterService.register のバリデーションテスト | E-03 (L39-64) | ○ |
| C-021 | SysShiroService.deleteSession メソッドのテスト | E-04 (L28-31) | ○ |
| C-022 | SysShiroService.getSession メソッドのテスト | E-04 (L39-43) | ○ |
| C-023 | SysShiroService.createSession メソッドのテスト | E-04 (L45-61) | ○ |
| C-024 | PermissionService.hasPermi メソッドのテスト | E-05 (L36-39) | ○ |
| C-025 | PermissionService.lacksPermi メソッドのテスト | E-05 (L47-50) | ○ |
| C-026 | PermissionService.hasAnyPermi メソッドのテスト | E-05 (L58-61) | ○ |
| C-027 | PermissionService.hasRole メソッドのテスト | E-05 (L69-72) | ○ |
| C-028 | PermissionService.isUser メソッドのテスト | E-05 (L101-105) | ○ |
| C-029 | PermissionService.isPermitted メソッドのテスト | E-05 (L113-116) | ○ |
| C-030 | PermissionService.hasAnyPermissions メソッドのテスト | E-05 (L147-168) | ○ |
| C-031 | PermissionService.isAnyRoles メソッドのテスト | E-05 (L210-230) | ○ |
| C-032 | PermissionService.getPrincipalProperty メソッドのテスト | E-05 (L238-261) | ○ |
| C-033 | CacheService.getCacheNames メソッドのテスト | E-06 (L23-27) | ○ |
| C-034 | CacheService.getCacheKeys メソッドのテスト | E-06 (L35-38) | ○ |
| C-035 | CacheService.getCacheValue メソッドのテスト | E-06 (L47-50) | ○ |
| C-036 | CacheService.clearCacheName メソッドのテスト | E-06 (L57-60) | ○ |
| C-037 | CacheService.clearCacheKey メソッドのテスト | E-06 (L68-71) | ○ |
| C-038 | CacheService.clearAll メソッドのテスト | E-06 (L76-83) | ○ |
| C-039 | DictService.getType メソッドのテスト | E-07 (L30-33) | ○ |
| C-040 | DictService.getLabel メソッドのテスト | E-07 (L42-45) | ○ |
| C-041 | ConfigService.getKey メソッドのテスト | E-08 (L24-27) | ○ |
| C-042 | LogAspect.handleLog メソッドのテスト | E-09 (L85-137) | ○ |
| C-043 | LogAspect.isFilterObject メソッドのテスト | E-09 (L237-264) | ○ |
| C-044 | LogAspect.excludePropertyPreFilter メソッドのテスト | E-09 (L195-198) | ○ |
| C-045 | DataScopeAspect.handleDataScope メソッドのテスト | E-10 (L65-78) | ○ |
| C-046 | DataScopeAspect.dataScopeFilter メソッドのテスト | E-10 (L89-168) | ○ |
| C-047 | DataScopeAspect.clearDataScope メソッドのテスト | E-10 (L173-181) | ○ |
| C-048 | DataSourceAspect.around メソッドのテスト | E-11 (L37-56) | ○ |
| C-049 | DataSourceAspect.getDataSource メソッドのテスト | E-11 (L61-71) | ○ |
| C-050 | PermissionsAspect.handleRequiresPermissions メソッドのテスト | E-12 (L26-29) | ○ |
| C-051 | AsyncManager.execute メソッドのテスト | E-13 (L43-46) | ○ |
| C-052 | AsyncManager.shutdown メソッドのテスト | E-13 (L51-54) | ○ |
| C-053 | AsyncManager.me メソッドのテスト | E-13 (L33-36) | ○ |
| C-054 | ShutdownManager.destroy メソッドのテスト | E-14 (L28-34) | ○ |
| C-055 | AsyncFactory.syncSessionToDb メソッドのテスト | E-15 (L38-61) | ○ |
| C-056 | AsyncFactory.recordOper メソッドのテスト | E-15 (L69-81) | ○ |
| C-057 | AsyncFactory.recordLogininfor メソッドのテスト | E-15 (L92-135) | ○ |
| C-058 | UserRealm.doGetAuthorizationInfo メソッドのテスト | E-16 (L56-81) | ○ |
| C-059 | UserRealm.doGetAuthenticationInfo メソッドのテスト | E-16 (L87-133) | ○ |
| C-060 | UserRealm.clearAllCachedAuthorizationInfo メソッドのテスト | E-16 (L147-157) | ○ |
| C-061 | OnlineSession のゲッター/セッターテスト | E-17 (全体) | ○ |
| C-062 | OnlineSession.markAttributeChanged メソッドのテスト | E-17 (L116-119) | ○ |
| C-063 | OnlineSession.resetAttributeChanged メソッドのテスト | E-17 (L121-124) | ○ |
| C-064 | OnlineSessionDAO.doReadSession メソッドのテスト | E-18 (L52-56) | ○ |
| C-065 | OnlineSessionDAO.syncToDb メソッドのテスト | E-18 (L67-101) | ○ |
| C-066 | OnlineSessionDAO.doDelete メソッドのテスト | E-18 (L106-116) | ○ |
| C-067 | OnlineSessionFactory.createSession メソッドのテスト | E-19 (L21-41) | ○ |
| C-068 | Server.copyTo メソッドのテスト | E-20 (L109-123) | △ |
| C-069 | Server.convertFileSize メソッドのテスト | E-20 (L217-240) | ○ |
| C-070 | Cpu のゲッター計算ロジックテスト | E-21 (全体) | ○ |
| C-071 | Mem のゲッター計算ロジックテスト | E-22 (全体) | ○ |
| C-072 | Jvm のゲッター計算ロジックテスト | E-23 (全体) | ○ |
| C-073 | Jvm.getName メソッドのテスト | E-23 (L83-85) | △ |
| C-074 | GlobalExceptionHandler.handleAuthorizationException メソッドのテスト | E-26 (L36-49) | ○ |
| C-075 | GlobalExceptionHandler.handleHttpRequestMethodNotSupported メソッドのテスト | E-26 (L54-61) | ○ |
| C-076 | GlobalExceptionHandler.handleRuntimeException メソッドのテスト | E-26 (L66-72) | ○ |
| C-077 | GlobalExceptionHandler.handleServiceException メソッドのテスト | E-26 (L88-100) | ○ |
| C-078 | GlobalExceptionHandler.handleMissingPathVariableException メソッドのテスト | E-26 (L105-111) | ○ |
| C-079 | GlobalExceptionHandler.handleMethodArgumentTypeMismatchException メソッドのテスト | E-26 (L116-128) | ○ |
| C-080 | GlobalExceptionHandler.handleBindException メソッドのテスト | E-26 (L133-139) | ○ |
| C-081 | GlobalExceptionHandler.handleDemoModeException メソッドのテスト | E-26 (L144-148) | ○ |
| C-082 | RepeatSubmitInterceptor.preHandle メソッドのテスト | E-27 (L22-45) | ○ |
| C-083 | SameUrlDataInterceptor.isRepeatSubmit メソッドのテスト | E-28 (L29-58) | ○ |
| C-084 | LogoutFilter.preHandle メソッドのテスト | E-29 (L43-75) | ○ |
| C-085 | LogoutFilter.getRedirectUrl メソッドのテスト | E-29 (L80-89) | ○ |
| C-086 | CaptchaValidateFilter.isAccessAllowed メソッドのテスト | E-30 (L47-58) | ○ |
| C-087 | CaptchaValidateFilter.validateResponse メソッドのテスト | E-30 (L60-71) | ○ |
| C-088 | CsrfValidateFilter.isAccessAllowed メソッドのテスト | E-31 (L28-41) | ○ |
| C-089 | CsrfValidateFilter.validateResponse メソッドのテスト | E-31 (L43-52) | ○ |
| C-090 | SyncOnlineSessionFilter.onPreHandle メソッドのテスト | E-32 (L22-33) | ○ |
| C-091 | OnlineSessionFilter.isAccessAllowed メソッドのテスト | E-33 (L36-72) | ○ |
| C-092 | OnlineSessionFilter.onAccessDenied メソッドのテスト | E-33 (L77-87) | ○ |
| C-093 | KickoutSessionFilter.onAccessDenied メソッドのテスト | E-34 (L60-132) | ○ |
| C-094 | AuthorizationUtils.clearAllCachedAuthorizationInfo メソッドのテスト | E-35 (L17-20) | ○ |
| C-095 | AuthorizationUtils.getUserRealm メソッドのテスト | E-35 (L25-29) | ○ |
| C-096 | OnlineWebSessionManager.setAttribute メソッドのテスト | E-36 (L33-42) | ○ |
| C-097 | OnlineWebSessionManager.needMarkAttributeChanged メソッドのテスト | E-36 (L44-65) | ○ |
| C-098 | OnlineWebSessionManager.removeAttribute メソッドのテスト | E-36 (L67-78) | ○ |
| C-099 | OnlineWebSessionManager.validateSessions メソッドのテスト | E-36 (L95-167) | ○ |
| C-100 | OnlineWebSessionManager.getActiveSessions メソッドのテスト | E-36 (L170-174) | ○ |
| C-101 | SpringSessionValidationScheduler.enableSessionValidation メソッドのテスト | E-37 (L74-115) | △ |
| C-102 | SpringSessionValidationScheduler.disableSessionValidation メソッドのテスト | E-37 (L117-130) | ○ |
| C-103 | SpringSessionValidationScheduler.isEnabled メソッドのテスト | E-37 (L50-54) | ○ |
| C-104 | CustomCookieRememberMeManager.rememberIdentity メソッドのテスト | E-38 (L26-57) | ○ |
| C-105 | CustomCookieRememberMeManager.getRememberedPrincipals メソッドのテスト | E-38 (L62-78) | ○ |
| C-106 | CustomShiroFilterFactoryBean.createInstance メソッドのテスト | E-39 (L29-65) | ○ |
| C-107 | DynamicDataSource.determineCurrentLookupKey メソッドのテスト | E-40 (L22-26) | ○ |
| C-108 | KaptchaTextCreator.getText メソッドのテスト | E-41 (L16-74) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-FRM-097 (Server.copyTo)**: OSHIライブラリを使用したシステム情報取得はモック化が必要。実際のテスト実行時には環境依存の問題が発生する可能性あり
  - 候補：SystemInfoのモック / テスト用スタブの作成 / 統合テストとして分離
- **UT-FRM-108 (Jvm.getName)**: JVM内部API (ManagementFactory.getRuntimeMXBean()) への依存
  - 候補：結果の検証は「nullでないこと」程度に留める / 具体的な値の検証は避ける
- **UT-FRM-159 (SpringSessionValidationScheduler.enableSessionValidation)**: ScheduledExecutorServiceへの依存、実際のスケジューリング動作の検証が困難
  - 候補：モックを使用した呼び出し検証 / 統合テストとして分離

## 5) リスクフラグ（レビュー観点）
- **リスク2 (高)**:
  - 認証・認可関連 (SysPasswordService, SysLoginService, UserRealm, PermissionService)
  - セキュリティフィルタ (CaptchaValidateFilter, CsrfValidateFilter, KickoutSessionFilter)
- **リスク1 (中)**:
  - データスコープ (DataScopeAspect) - SQLインジェクションリスク
  - セッション管理 (OnlineSessionDAO, OnlineWebSessionManager)
  - 動的データソース (DynamicDataSource, DataSourceAspect)
- **リスク0 (低)**:
  - サーバー監視情報 (Server, Cpu, Mem, Jvm, Sys, SysFile)
  - ユーティリティ (AuthorizationUtils, KaptchaTextCreator)

## 6) レビュアーチェックリスト（最小）
- [ ] 認証関連テストケース (UT-FRM-001〜UT-FRM-020) のカバレッジは十分か
- [ ] パスワード暗号化 (UT-FRM-006) のテストでソルト処理が正しく検証されているか
- [ ] データスコープ (UT-FRM-062〜UT-FRM-068) のSQLインジェクション対策が検証されているか
- [ ] 同時ログイン制御 (UT-FRM-145〜UT-FRM-149) の境界値テストが十分か
- [ ] CSRF/Captcha フィルタ (UT-FRM-130〜UT-FRM-138) のバイパスケースが考慮されているか
- [ ] 非同期処理 (AsyncManager, AsyncFactory) のエラーハンドリングが検証されているか
- [ ] 例外ハンドラ (UT-FRM-109〜UT-FRM-118) で全ての例外タイプがカバーされているか
