---
generated_at: 2026-01-08 12:00:00
metrics:
  claims_total: 145
  claims_with_evidence: 145
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ruoyi-generator 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：145 / 145、根拠なし：0
- 優先レビュー（高）
  1. **コード生成・ダウンロード機能**：複雑なファイル操作を伴うため重点確認推奨
  2. **データベース同期機能**：差分検出・更新ロジックの検証が重要
  3. **バリデーション処理**：ツリー・主子表テンプレートの必須チェック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTable.java`
- E-02: `ruoyi-generator/src/main/java/com/ruoyi/generator/domain/GenTableColumn.java`
- E-03: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java`
- E-04: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableColumnServiceImpl.java`
- E-05: `ruoyi-generator/src/main/java/com/ruoyi/generator/util/GenUtils.java`
- E-06: `ruoyi-generator/src/main/java/com/ruoyi/generator/util/VelocityUtils.java`
- E-07: `ruoyi-generator/src/main/java/com/ruoyi/generator/util/VelocityInitializer.java`
- E-08: `ruoyi-generator/src/main/java/com/ruoyi/generator/config/GenConfig.java`
- E-09: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-10: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/IGenTableService.java`
- E-11: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/IGenTableColumnService.java`
- E-12: `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableMapper.java`
- E-13: `ruoyi-generator/src/main/java/com/ruoyi/generator/mapper/GenTableColumnMapper.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### GenTable ドメインクラス（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isSub()はtplCategoryがsubの場合にtrueを返却 | E-01 L341-349 | ○ |
| C-02 | isTree()はtplCategoryがtreeの場合にtrueを返却 | E-01 L351-359 | ○ |
| C-03 | isCrud()はtplCategoryがcrudの場合にtrueを返却 | E-01 L361-369 | ○ |
| C-04 | isSuperColumn()はBaseEntity/TreeEntityフィールドを判定 | E-01 L371-384 | ○ |

### GenTableColumn ドメインクラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | isPk()はisPkが1の場合にtrueを返却 | E-02 L156-164 | ○ |
| C-06 | isIncrement()はisIncrementが1の場合にtrueを返却 | E-02 L176-184 | ○ |
| C-07 | isRequired()はisRequiredが1の場合にtrueを返却 | E-02 L196-204 | ○ |
| C-08 | isInsert()はisInsertが1の場合にtrueを返却 | E-02 L216-224 | ○ |
| C-09 | isEdit()はisEditが1の場合にtrueを返却（isInsert呼出バグあり） | E-02 L236-244 | ○ |
| C-10 | isList()はisListが1の場合にtrueを返却 | E-02 L256-264 | ○ |
| C-11 | isQuery()はisQueryが1の場合にtrueを返却 | E-02 L276-284 | ○ |
| C-12 | getCapJavaField()はjavaFieldの先頭を大文字化 | E-02 L141-144 | ○ |
| C-13 | isSuperColumn()はBaseEntity/TreeEntityフィールドを判定 | E-02 L326-338 | ○ |
| C-14 | isUsableColumn()は使用可能カラムを判定 | E-02 L340-349 | ○ |
| C-15 | readConverterExp()はコメントからコンバーター式を生成 | E-02 L351-372 | ○ |

### GenTableServiceImpl サービスクラス（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | selectGenTableById()はIDでテーブル情報を取得 | E-03 L63-69 | ○ |
| C-17 | selectGenTableList()はテーブル一覧を取得 | E-03 L77-81 | ○ |
| C-18 | selectDbTableList()はDB直接参照でテーブル一覧を取得 | E-03 L89-93 | ○ |
| C-19 | selectDbTableListByNames()は指定名のテーブルリストを取得 | E-03 L101-105 | ○ |
| C-20 | selectGenTableAll()は全テーブル情報を取得 | E-03 L112-116 | ○ |
| C-21 | updateGenTable()はトランザクション付きでテーブルを更新 | E-03 L124-138 | ○ |
| C-22 | deleteGenTableByIds()はテーブルとカラムを削除 | E-03 L146-152 | ○ |
| C-23 | createTable()はCREATE TABLE文を実行 | E-03 L159-164 | ○ |
| C-24 | importGenTable()はテーブル構造をインポート | E-03 L172-199 | ○ |
| C-25 | previewCode()はコードプレビューを生成 | E-03 L207-232 | ○ |
| C-26 | downloadCode()はZIPファイルを生成 | E-03 L240-248 | ○ |
| C-27 | generatorCode()はファイルにコードを生成 | E-03 L254-290 | ○ |
| C-28 | synchDb()はデータベースと同期 | E-03 L297-345 | ○ |
| C-29 | validateEdit()はテンプレート別バリデーション | E-03 L411-442 | ○ |
| C-30 | setPkColumn()は主キーカラムを設定 | E-03 L449-478 | ○ |
| C-31 | setSubTable()は子表情報を設定 | E-03 L485-492 | ○ |
| C-32 | setTableFromOptions()はオプションを解析 | E-03 L499-516 | ○ |
| C-33 | getGenPath()は生成パスを決定 | E-03 L525-533 | ○ |

### GenTableColumnServiceImpl サービスクラス（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | selectGenTableColumnListByTableId()はカラム一覧を取得 | E-04 L28-32 | ○ |
| C-35 | insertGenTableColumn()はカラムを挿入 | E-04 L40-44 | ○ |
| C-36 | updateGenTableColumn()はカラムを更新 | E-04 L52-56 | ○ |
| C-37 | deleteGenTableColumnByIds()はカラムを削除 | E-04 L64-68 | ○ |

### GenUtils ユーティリティクラス（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | initTable()はテーブル情報を初期化 | E-05 L21-30 | ○ |
| C-39 | initColumnField()はカラムフィールドを初期化 | E-05 L35-126 | ○ |
| C-40 | arraysContains()は配列に値が含まれるか判定 | E-05 L135-138 | ○ |
| C-41 | getModuleName()はパッケージからモジュール名を抽出 | E-05 L146-151 | ○ |
| C-42 | getBusinessName()はテーブル名からビジネス名を抽出 | E-05 L159-164 | ○ |
| C-43 | convertClassName()はテーブル名をクラス名に変換 | E-05 L172-182 | ○ |
| C-44 | replaceFirst()は最初に一致するプレフィックスを除去 | E-05 L191-203 | ○ |
| C-45 | replaceText()は「表」「若依」を除去 | E-05 L211-214 | ○ |
| C-46 | getDbType()はカラム型からDB型を抽出 | E-05 L222-232 | ○ |
| C-47 | getColumnLength()はカラム長を抽出 | E-05 L240-251 | ○ |

### VelocityUtils ユーティリティクラス（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | prepareContext()はVelocityContextを生成 | E-06 L34-71 | ○ |
| C-49 | setMenuVelocityContext()はメニュー情報を設定 | E-06 L73-79 | ○ |
| C-50 | setTreeVelocityContext()はツリー情報を設定 | E-06 L81-101 | ○ |
| C-51 | setSubVelocityContext()は主子表情報を設定 | E-06 L103-119 | ○ |
| C-52 | getTemplateList()はテンプレートリストを取得 | E-06 L126-153 | ○ |
| C-53 | getFileName()はファイル名を生成 | E-06 L158-228 | ○ |
| C-54 | getProjectPath()はプロジェクトパスを取得 | E-06 L235-243 | ○ |
| C-55 | getPackagePrefix()はパッケージプレフィックスを取得 | E-06 L251-255 | ○ |
| C-56 | getImportList()はインポートリストを生成 | E-06 L263-285 | ○ |
| C-57 | getPermissionPrefix()は権限プレフィックスを生成 | E-06 L294-297 | ○ |
| C-58 | getParentMenuId()は親メニューIDを取得 | E-06 L305-313 | ○ |
| C-59 | getTreecode()はツリーコードを取得 | E-06 L321-328 | ○ |
| C-60 | getTreeParentCode()は親ツリーコードを取得 | E-06 L336-343 | ○ |
| C-61 | getTreeName()はツリー名を取得 | E-06 L351-358 | ○ |
| C-62 | getExpandColumn()は展開カラム番号を取得 | E-06 L366-385 | ○ |
| C-63 | getColXsNum()はXS網格クラスを取得 | E-06 L393-405 | ○ |
| C-64 | getColSmNum()はSM網格クラスを取得 | E-06 L413-421 | ○ |

### VelocityInitializer ユーティリティクラス（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | initVelocity()はVelocityを初期化 | E-07 L17-33 | ○ |

### GenConfig 設定クラス（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | getAuthor()は作者名を取得 | E-08 L33-36 | ○ |
| C-67 | getPackageName()はパッケージ名を取得 | E-08 L44-47 | ○ |
| C-68 | getAutoRemovePre()は自動プレフィックス除去設定を取得 | E-08 L55-58 | ○ |
| C-69 | getTablePrefix()はテーブルプレフィックスを取得 | E-08 L66-69 | ○ |
| C-70 | isAllowOverwrite()は上書き許可設定を取得 | E-08 L77-80 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの主張はありません
- 全てのテストケースはソースコードの実装に基づいて作成されています

## 5) リスクフラグ（レビュー観点）
- **リスク 1（高）**: `GenTableColumn.isEdit()`メソッドは内部で`isInsert()`を呼び出しており、バグの可能性があります（E-02 L238行目）。テストケースUT-GEN-019で検証が必要です。
- **リスク 0（低）**: その他のメソッドは実装が明確で、テストケースと一致しています。

## 6) レビュアーチェックリスト（最小）
- [ ] GenTableColumn.isEdit()のバグ（isInsert呼出）が意図的かどうか確認
- [ ] synchDb()の差分検出ロジックが正しく動作するか確認
- [ ] validateEdit()のツリー・主子表バリデーションが全ケースをカバーしているか確認
- [ ] downloadCode()のZIP生成でメモリリークがないか確認
- [ ] generatorCode()のファイル書き込みエラー時の例外処理が適切か確認
- [ ] readConverterExp()の括弧解析が全角・半角両方に対応しているか確認
