---
generated_at: 2026-01-08 15:30:00
metrics:
  claims_total: 161
  claims_with_evidence: 161
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ruoyi-quartz 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：161 / 161、根拠なし：0
- 優先レビュー（高）
  1. **セキュリティ関連テストケース（UT-QTZ-053〜055, 128〜132）**：ホワイトリスト/禁止文字列の具体的な値は定数参照が必要
  2. **状態遷移テストケース（UT-QTZ-091〜103）**：Quartzスケジューラとの連携動作の確認が必要
  3. **パラメータ解析テストケース（UT-QTZ-067〜077）**：複雑な文字列パースロジックの境界値確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java`
- E-02: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java`
- E-03: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/CronUtils.java`
- E-04: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/ScheduleUtils.java`
- E-05: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/JobInvokeUtil.java`
- E-06: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/AbstractQuartzJob.java`
- E-07: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/QuartzJobExecution.java`
- E-08: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/QuartzDisallowConcurrentExecution.java`
- E-09: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobService.java`
- E-10: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobLogService.java`
- E-11: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobServiceImpl.java`
- E-12: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/impl/SysJobLogServiceImpl.java`
- E-13: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-14: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java`
- E-15: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/mapper/SysJobMapper.java`
- E-16: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/mapper/SysJobLogMapper.java`
- E-17: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-quartz/src/main/java/com/ruoyi/quartz/task/RyTask.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SysJob ドメインクラス（UT-QTZ-001〜019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SysJob.getJobId()が正しくIDを返却する | E-01 (56-59行目) | ○ |
| C-02 | SysJob.setJobId()が正しくIDを設定する | E-01 (61-64行目) | ○ |
| C-03 | SysJob.getJobName()が正しくタスク名を返却する | E-01 (66-71行目) | ○ |
| C-04 | @NotBlankアノテーションによりタスク名の空チェックが実行される | E-01 (66行目) | ○ |
| C-05 | @Sizeアノテーションによりタスク名の最大64文字制限がある | E-01 (67行目) | ○ |
| C-06 | SysJob.getInvokeTarget()の@NotBlankおよび@Sizeアノテーション | E-01 (88-89行目) | ○ |
| C-07 | SysJob.getCronExpression()の@NotBlankおよび@Sizeアノテーション | E-01 (100-101行目) | ○ |
| C-08 | SysJob.getNextValidTime()がCronUtilsを使用して次回実行時刻を計算する | E-01 (112-119行目) | ○ |
| C-09 | misfirePolicyのデフォルト値がMISFIRE_DEFAULT | E-01 (46行目) | ○ |
| C-10 | toString()がMULTI_LINE_STYLEで文字列を生成する | E-01 (151-168行目) | ○ |

### SysJobLog ドメインクラス（UT-QTZ-020〜030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | SysJobLogの各Getter/Setterが正しく動作する | E-02 (52-140行目) | ○ |
| C-12 | SysJobLog.toString()がMULTI_LINE_STYLEで文字列を生成する | E-02 (142-154行目) | ○ |

### CronUtils ユーティリティ（UT-QTZ-031〜041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | CronUtils.isValid()がCronExpression.isValidExpression()を呼び出す | E-03 (26-29行目) | ○ |
| C-14 | CronUtils.getInvalidMessage()が無効時にParseExceptionメッセージを返す | E-03 (37-48行目) | ○ |
| C-15 | CronUtils.getNextExecution()が次回実行時刻を計算する | E-03 (56-67行目) | ○ |
| C-16 | CronUtils.getRecentTriggerTime()がTriggerUtilsで10件の実行時刻を計算する | E-03 (75-93行目) | ○ |

### ScheduleUtils ユーティリティ（UT-QTZ-042〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | ScheduleUtils.getJobKey()がJobKeyを構築する | E-04 (52-55行目) | ○ |
| C-18 | ScheduleUtils.getTriggerKey()がTriggerKeyを構築する | E-04 (44-47行目) | ○ |
| C-19 | concurrent="0"でQuartzJobExecutionクラスが選択される | E-04 (35-39行目) | ○ |
| C-20 | concurrent="1"でQuartzDisallowConcurrentExecutionクラスが選択される | E-04 (35-39行目) | ○ |
| C-21 | createScheduleJob()がジョブを作成し、状態に応じて一時停止する | E-04 (60-98行目) | ○ |
| C-22 | handleCronScheduleMisfirePolicy()が各ポリシーを適切に処理する | E-04 (103-120行目) | ○ |
| C-23 | whiteList()がパッケージ名ベースのホワイトリストチェックを行う | E-04 (128-140行目) | ○ |

### JobInvokeUtil ユーティリティ（UT-QTZ-056〜077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | invokeMethod()がBean名またはクラス名を判断してメソッドを実行する | E-05 (23-40行目) | ○ |
| C-25 | isValidClassName()がピリオドの数で判断する | E-05 (71-74行目) | ○ |
| C-26 | getBeanName()が括弧前の最後のピリオドまでを抽出する | E-05 (82-86行目) | ○ |
| C-27 | getMethodName()が括弧前の最後のピリオド以降を抽出する | E-05 (94-98行目) | ○ |
| C-28 | getMethodParams()が各種型のパラメータを解析する | E-05 (106-145行目) | ○ |
| C-29 | 文字列は'または"で囲まれた形式で解析される | E-05 (119-122行目) | ○ |
| C-30 | boolean型はtrue/falseで判定される | E-05 (124-127行目) | ○ |
| C-31 | long型はL接尾辞で判定される | E-05 (129-132行目) | ○ |
| C-32 | double型はD接尾辞で判定される | E-05 (134-137行目) | ○ |
| C-33 | その他はinteger型として解析される | E-05 (139-142行目) | ○ |

### AbstractQuartzJob/QuartzJobExecution/QuartzDisallowConcurrentExecution（UT-QTZ-078〜085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | execute()がbefore→doExecute→afterの順で処理する | E-06 (33-51行目) | ○ |
| C-35 | before()がThreadLocalに開始時刻を設定する | E-06 (59-62行目) | ○ |
| C-36 | after()が実行時間とステータスをログに記録する | E-06 (70-96行目) | ○ |
| C-37 | 例外メッセージは2000文字に切り詰められる | E-06 (86行目) | ○ |
| C-38 | QuartzJobExecutionがJobInvokeUtil.invokeMethod()を呼び出す | E-07 (14-18行目) | ○ |
| C-39 | QuartzDisallowConcurrentExecutionが@DisallowConcurrentExecutionアノテーションを持つ | E-08 (13行目) | ○ |

### SysJobServiceImpl サービス（UT-QTZ-086〜111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | init()が起動時に全ジョブをスケジューラに登録する | E-11 (39-48行目) | ○ |
| C-41 | selectJobList()がmapper経由でリストを取得する | E-11 (57-60行目) | ○ |
| C-42 | selectJobById()がmapper経由でジョブを取得する | E-11 (69-72行目) | ○ |
| C-43 | pauseJob()がステータスをPAUSEに設定しスケジューラを一時停止する | E-11 (81-92行目) | ○ |
| C-44 | resumeJob()がステータスをNORMALに設定しスケジューラを再開する | E-11 (101-112行目) | ○ |
| C-45 | deleteJob()がDBとスケジューラからジョブを削除する | E-11 (121-131行目) | ○ |
| C-46 | deleteJobByIds()が複数ジョブを一括削除する | E-11 (141-149行目) | ○ |
| C-47 | changeStatus()がステータスに応じてresumeJob/pauseJobを呼び出す | E-11 (158-171行目) | ○ |
| C-48 | run()が即時実行を行いジョブ存在時にtrueを返す | E-11 (180-195行目) | ○ |
| C-49 | insertJob()がPAUSE状態で新規登録する | E-11 (204-213行目) | ○ |
| C-50 | updateJob()がDBとスケジューラを更新する | E-11 (222-231行目) | ○ |
| C-51 | updateSchedulerJob()が既存ジョブを削除して再作成する | E-11 (239-250行目) | ○ |
| C-52 | checkCronExpressionIsValid()がCronUtils.isValid()を呼び出す | E-11 (259-262行目) | ○ |

### SysJobLogServiceImpl サービス（UT-QTZ-112〜118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | selectJobLogList()がmapper経由でリストを取得する | E-12 (29-32行目) | ○ |
| C-54 | selectJobLogById()がmapper経由でログを取得する | E-12 (41-44行目) | ○ |
| C-55 | addJobLog()がmapper経由でログを登録する | E-12 (52-55行目) | ○ |
| C-56 | deleteJobLogByIds()がConvert.toStrArrayを使用して削除する | E-12 (64-67行目) | ○ |
| C-57 | deleteJobLogById()がmapper経由で削除する | E-12 (75-78行目) | ○ |
| C-58 | cleanJobLog()がmapper経由で全削除する | E-12 (84-87行目) | ○ |

### SysJobController コントローラー（UT-QTZ-119〜138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | list()がページング付きリストを返却する | E-13 (51-59行目) | ○ |
| C-60 | export()がExcelUtilでエクスポートする | E-13 (63-70行目) | ○ |
| C-61 | remove()がdeleteJobByIds()を呼び出す | E-13 (74-80行目) | ○ |
| C-62 | changeStatus()がステータス変更を行う | E-13 (97-103行目) | ○ |
| C-63 | run()が即時実行を行いエラー時にメッセージを返す | E-13 (110-116行目) | ○ |
| C-64 | addSave()がCron式検証とセキュリティチェックを行う | E-13 (134-163行目) | ○ |
| C-65 | RMI/LDAP/HTTP呼び出しが禁止されている | E-13 (141-152行目) | ○ |
| C-66 | editSave()が同様の検証を行って更新する | E-13 (183-210行目) | ○ |
| C-67 | checkCronExpressionIsValid()がbooleanを返す | E-13 (215-220行目) | ○ |
| C-68 | queryCronExpression()が実行時刻リストを返す | E-13 (234-247行目) | ○ |

### SysJobLogController コントローラー（UT-QTZ-139〜144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | jobLog()がジョブIDを受け取りビューを返す | E-14 (43-53行目) | ○ |
| C-70 | list()がページング付きリストを返却する | E-14 (55-63行目) | ○ |
| C-71 | export()がExcelUtilでエクスポートする | E-14 (65-74行目) | ○ |
| C-72 | remove()がdeleteJobLogByIds()を呼び出す | E-14 (76-83行目) | ○ |
| C-73 | clean()がcleanJobLog()を呼び出す | E-14 (94-102行目) | ○ |

### RyTask テストタスク（UT-QTZ-145〜147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | ryMultipleParams()が複数パラメータを受け取る | E-17 (14-17行目) | ○ |
| C-75 | ryParams()が単一パラメータを受け取る | E-17 (19-22行目) | ○ |
| C-76 | ryNoParams()がパラメータなしで実行される | E-17 (24-27行目) | ○ |

### Mapper インターフェース（UT-QTZ-148〜161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | SysJobMapperの各メソッドが定義されている | E-15 (全体) | ○ |
| C-78 | SysJobLogMapperの各メソッドが定義されている | E-16 (全体) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースがソースコードに基づいて生成されており、根拠なしの項目はありません。
- 追加で確認が推奨される項目：
  - `Constants.JOB_WHITELIST_STR` および `Constants.JOB_ERROR_STR` の具体的な値（ruoyi-commonモジュール内の定数）
  - `ScheduleConstants` の各定数値（ruoyi-commonモジュール内の定数）

## 5) リスクフラグ（レビュー観点）
- **リスク 0（低リスク）**: Getter/Setterのテストケース（UT-QTZ-001〜030）
- **リスク 1（中リスク）**: CronUtils、MapperのDBアクセステストケース
- **リスク 2（高リスク）**:
  - セキュリティ関連（UT-QTZ-053〜055, 128〜132）：ホワイトリスト検証ロジックの網羅性
  - ジョブ実行（UT-QTZ-056〜061, 078〜085）：リフレクション実行の安全性
  - 状態遷移（UT-QTZ-091〜107）：トランザクション整合性

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティチェック（RMI/LDAP/HTTP禁止）のテストケースが実際の禁止文字列を網羅しているか
- [ ] Cron式の境界値テストケースが十分か（特殊文字、長い式など）
- [ ] パラメータ解析のテストケースがエッジケースを網羅しているか（エスケープ文字、ネストした括弧など）
- [ ] トランザクションのロールバックテストケースが存在するか
- [ ] Quartzスケジューラの例外ハンドリングテストケースが十分か
- [ ] ThreadLocalの適切なクリーンアップがテストされているか
