---
generated_at: 2026-01-08 14:30:00
metrics:
  claims_total: 210
  claims_with_evidence: 198
  claims_without_evidence: 12
confidence_derived: 0.94
---

# 根拠レポート：ruoyi-system 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と一致しているか
3. **網羅性**：対象モジュールの全クラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：ソースコードに対応する実装が確認できた、「△」：実装の確認が困難または推測を含む

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：198 / 210、根拠なし：12
- 優先レビュー（高）
  1. **UT-SYS-027〜028**：checkUserDataScope のデータスコープ検証動作 - Shiroとの連携部分
  2. **UT-SYS-060〜061**：checkRoleDataScope のデータスコープ検証動作 - Shiroとの連携部分
  3. **UT-SYS-190〜191**：removeUserCache のEhCache連携動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java`
- E-02: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysRoleServiceImpl.java`
- E-03: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysMenuServiceImpl.java`
- E-04: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java`
- E-05: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysConfigServiceImpl.java`
- E-06: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictTypeServiceImpl.java`
- E-07: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictDataServiceImpl.java`
- E-08: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysPostServiceImpl.java`
- E-09: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java`
- E-10: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysOperLogServiceImpl.java`
- E-11: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysLogininforServiceImpl.java`
- E-12: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserOnlineServiceImpl.java`
- E-13: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java`
- E-14: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java`
- E-15: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java`
- E-16: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java`
- E-17: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java`
- E-18: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserOnline.java`
- E-19: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserRole.java`
- E-20: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysRoleMenu.java`
- E-21: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysUserPost.java`
- E-22: `/Users/tomokababa/Work/route06/RuoYi-master/ruoyi-system/src/main/java/com/ruoyi/system/domain/SysRoleDept.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SysUserServiceImpl (UT-SYS-001〜039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | selectUserList が DataScope アノテーション付きで実装されている | E-01 (L80-85) | ○ |
| C-02 | selectUserByLoginName でログイン名検索が可能 | E-01 (L119-123) | ○ |
| C-03 | deleteUserById がトランザクション処理で関連データも削除 | E-01 (L180-188) | ○ |
| C-04 | insertUser がトランザクション処理でロール・岗位関連も作成 | E-01 (L220-230) | ○ |
| C-05 | checkUserAllowed で管理者操作禁止 | E-01 (L442-448) | ○ |
| C-06 | checkUserDataScope でデータ権限チェック | E-01 (L455-468) | △ |
| C-07 | importUser でユーザーインポート処理 | E-01 (L513-582) | ○ |

### SysRoleServiceImpl (UT-SYS-040〜066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | selectRoleKeys でロールキー取得 | E-02 (L67-80) | ○ |
| C-09 | deleteRoleByIds で割り当て済みロール削除チェック | E-02 (L153-173) | ○ |
| C-10 | checkRoleAllowed で管理者ロール操作禁止 | E-02 (L314-321) | ○ |
| C-11 | checkRoleDataScope でデータ権限チェック | E-02 (L328-344) | △ |
| C-12 | insertAuthUsers で複数ユーザーへのロール認可 | E-02 (L402-416) | ○ |

### SysMenuServiceImpl (UT-SYS-067〜088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | selectMenusByUser で管理者全メニュー取得 | E-03 (L51-64) | ○ |
| C-14 | selectPermsByUserId で権限一覧取得 | E-03 (L113-126) | ○ |
| C-15 | getChildPerms で階層構造構築 | E-03 (L378-392) | ○ |
| C-16 | checkMenuNameUnique でメニュー名重複チェック | E-03 (L359-369) | ○ |

### SysDeptServiceImpl (UT-SYS-089〜109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | insertDept で親部門停止時エラー | E-04 (L192-203) | ○ |
| C-18 | updateDept で子部門の祖先パス更新 | E-04 (L211-232) | ○ |
| C-19 | checkDeptDataScope でデータ権限チェック | E-04 (L313-326) | △ |

### SysConfigServiceImpl (UT-SYS-110〜126)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | init で PostConstruct 初期化 | E-05 (L31-35) | ○ |
| C-21 | selectConfigByKey でキャッシュ優先取得 | E-05 (L57-74) | ○ |
| C-22 | deleteConfigByIds で内蔵設定削除禁止 | E-05 (L133-147) | ○ |

### SysDictTypeServiceImpl (UT-SYS-127〜146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | init で辞書キャッシュ初期化 | E-06 (L41-45) | ○ |
| C-24 | selectDictDataByType でキャッシュ優先取得 | E-06 (L77-91) | ○ |
| C-25 | deleteDictTypeByIds で辞書データ割り当て済み削除禁止 | E-06 (L122-136) | ○ |

### SysDictDataServiceImpl (UT-SYS-147〜155)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | insertDictData でキャッシュ更新 | E-07 (L85-94) | ○ |
| C-27 | updateDictData でキャッシュ更新 | E-07 (L103-112) | ○ |

### SysPostServiceImpl (UT-SYS-156〜168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | deletePostByIds でユーザー割り当て済み削除禁止 | E-08 (L96-108) | ○ |
| C-29 | checkPostNameUnique で岗位名重複チェック | E-08 (L153-162) | ○ |
| C-30 | checkPostCodeUnique で岗位コード重複チェック | E-08 (L170-180) | ○ |

### SysNoticeServiceImpl (UT-SYS-169〜173)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | selectNoticeById で公告取得 | E-09 (L29-33) | ○ |
| C-32 | deleteNoticeByIds で公告削除 | E-09 (L77-81) | ○ |

### SysOperLogServiceImpl (UT-SYS-174〜178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | insertOperlog で操作ログ登録 | E-10 (L27-31) | ○ |
| C-34 | cleanOperLog で全件クリア | E-10 (L72-76) | ○ |

### SysLogininforServiceImpl (UT-SYS-179〜182)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | insertLogininfor でログイン情報登録 | E-11 (L28-32) | ○ |
| C-36 | cleanLogininfor で全件クリア | E-11 (L62-65) | ○ |

### SysUserOnlineServiceImpl (UT-SYS-183〜192)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | deleteOnlineById で存在チェック後削除 | E-12 (L48-56) | ○ |
| C-38 | removeUserCache でEhCache操作 | E-12 (L117-127) | △ |
| C-39 | selectOnlineByExpired で期限切れセッション取得 | E-12 (L134-139) | ○ |

### Domain クラス (UT-SYS-193〜210)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | SysConfig のバリデーションアノテーション | E-13 (L49-51, L61-62, L73-74) | ○ |
| C-41 | SysPost の flag フィールド | E-14 (L40, L97-105) | ○ |
| C-42 | SysNotice の @Xss アノテーション | E-15 (L49) | ○ |
| C-43 | SysUserOnline のデフォルトステータス | E-18 (L49) | ○ |
| C-44 | 各関連テーブル Domain の toString | E-19, E-20, E-21, E-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Shiro連携部分（ShiroUtils）の動作検証**：`checkUserDataScope`、`checkRoleDataScope`、`checkDeptDataScope` メソッドは ShiroUtils.isAdmin() を呼び出しているが、Shiro の動作は ruoyi-common モジュールに依存
  - 候補：ruoyi-common/ShiroUtils.java / ruoyi-framework のセキュリティ設定
- **EhCache連携部分の動作検証**：`removeUserCache` メソッドは EhCacheManager を使用しているが、キャッシュの具体的な動作は設定依存
  - 候補：ehcache.xml / ruoyi-framework のキャッシュ設定
- **AOP Proxy取得部分**：`SpringUtils.getAopProxy(this)` の動作はSpringのAOP設定に依存
  - 候補：ruoyi-common/SpringUtils.java

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**：認証・認可関連のテストケース（UT-SYS-025〜028, UT-SYS-058〜061）- セキュリティに直結
- **リスク1（中）**：キャッシュ操作関連のテストケース（UT-SYS-110〜124, UT-SYS-127〜144）- データ整合性に影響
- **リスク1（中）**：トランザクション処理関連のテストケース（UT-SYS-009〜011, UT-SYS-046〜048）- データ整合性に影響
- **リスク0（低）**：Domain クラスの getter/setter テストケース（UT-SYS-193〜210）- 単純な POJO 操作

## 6) レビュアーチェックリスト（最小）
- [ ] 認証・認可関連テストケース（UT-SYS-025〜028, UT-SYS-058〜061）が Shiro の動作を考慮しているか確認
- [ ] キャッシュ操作テストケース（UT-SYS-110〜124, UT-SYS-127〜144）でキャッシュの初期化・クリア・更新が網羅されているか確認
- [ ] トランザクション処理テストケース（UT-SYS-009〜011, UT-SYS-046〜048）でロールバックシナリオが考慮されているか確認
- [ ] データスコープアノテーション（@DataScope）付きメソッドのテストケースでスコープ条件が考慮されているか確認
- [ ] インポート処理（UT-SYS-032〜035）でエラーハンドリングが網羅されているか確認
- [ ] 削除前チェック（ユーザー割り当て済み、辞書データ割り当て済み等）のテストケースが存在するか確認
