---
generated_at: 2026-01-08 12:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UAT-099（権限制御機能）**：一般的なセキュリティテストケースとして記載。具体的なテスト対象画面の列挙が必要
  2. **UAT-100（データスコープ検証）**：DataScopeAspectの動作確認だが、具体的なシナリオ詳細化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java`
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-04: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java`
- E-06: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java`
- E-07: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-08: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java`
- E-09: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java`
- E-10: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-11: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java`
- E-12: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java`
- E-13: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java`
- E-14: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-15: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-16: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java`
- E-17: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-18: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/DataScopeAspect.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ログイン機能（UAT-001 - UAT-008）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-001 | 正常ログイン処理 | E-01, E-16 | ○ |
| UAT-002 | 存在しないユーザーでのログイン失敗 | E-16 (UserNotExistsException) | ○ |
| UAT-003 | パスワード間違いでのログイン失敗 | E-16, E-17 (validate()) | ○ |
| UAT-004 | 検証コード間違いでのログイン失敗 | E-16 (CaptchaException) | ○ |
| UAT-005 | IPブラックリストによるブロック | E-16 (BlackListException, sys.login.blackIPList) | ○ |
| UAT-006 | 無効化ユーザーでのログイン失敗 | E-16 (UserBlockedException, UserStatus.DISABLE) | ○ |
| UAT-007 | 削除済みユーザーでのログイン失敗 | E-16 (UserDeleteException, UserStatus.DELETED) | ○ |
| UAT-008 | Remember Me機能 | E-01 (rememberMe設定) | ○ |

### ユーザー登録機能（UAT-009 - UAT-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-009 | 新規ユーザー登録 | E-11 (ajaxRegister()) | ○ |
| UAT-010 | 登録機能無効時のエラー | E-11 (sys.account.registerUser設定チェック) | ○ |

### ユーザー管理機能（UAT-011 - UAT-023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-011 | ユーザー一覧表示 | E-02 (list()) | ○ |
| UAT-012 | 新規ユーザー追加 | E-02 (addSave()) | ○ |
| UAT-013 | 重複ログイン名チェック | E-02 (checkLoginNameUnique()) | ○ |
| UAT-014 | 重複電話番号チェック | E-02 (checkPhoneUnique()) | ○ |
| UAT-015 | 重複メールチェック | E-02 (checkEmailUnique()) | ○ |
| UAT-016 | ユーザー情報編集 | E-02 (editSave()) | ○ |
| UAT-017 | ユーザー削除 | E-02 (remove()) | ○ |
| UAT-018 | 自分自身の削除防止 | E-02 (ArrayUtils.contains検証) | ○ |
| UAT-019 | パスワードリセット | E-02 (resetPwdSave()) | ○ |
| UAT-020 | ユーザーステータス変更 | E-02 (changeStatus()) | ○ |
| UAT-021 | ユーザーデータエクスポート | E-02 (export()) | ○ |
| UAT-022 | ユーザーデータインポート | E-02 (importData()) | ○ |
| UAT-023 | ロール割り当て | E-02 (insertAuthRole()) | ○ |

### ロール管理機能（UAT-024 - UAT-034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-024 | ロール一覧表示 | E-03 (list()) | ○ |
| UAT-025 | 新規ロール追加 | E-03 (addSave()) | ○ |
| UAT-026 | 重複ロール名チェック | E-03 (checkRoleNameUnique()) | ○ |
| UAT-027 | 重複ロールキーチェック | E-03 (checkRoleKeyUnique()) | ○ |
| UAT-028 | ロール情報編集 | E-03 (editSave()) | ○ |
| UAT-029 | ロール削除 | E-03 (remove()) | ○ |
| UAT-030 | データ権限設定 | E-03 (authDataScopeSave()) | ○ |
| UAT-031 | ロールステータス変更 | E-03 (changeStatus()) | ○ |
| UAT-032 | ユーザー割り当て | E-03 (selectAuthUserAll()) | ○ |
| UAT-033 | ユーザー解除 | E-03 (cancelAuthUser()) | ○ |
| UAT-034 | ロールデータエクスポート | E-03 (export()) | ○ |

### メニュー管理機能（UAT-035 - UAT-041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-035 | メニュー一覧表示 | E-04 (list()) | ○ |
| UAT-036 | 新規メニュー追加 | E-04 (addSave()) | ○ |
| UAT-037 | 重複メニュー名チェック | E-04 (checkMenuNameUnique()) | ○ |
| UAT-038 | メニュー情報編集 | E-04 (editSave()) | ○ |
| UAT-039 | メニュー削除 | E-04 (remove()) | ○ |
| UAT-040 | 子メニュー存在時の削除防止 | E-04 (selectCountMenuByParentId()) | ○ |
| UAT-041 | ロール割当済みメニューの削除防止 | E-04 (selectCountRoleMenuByMenuId()) | ○ |

### 部門管理機能（UAT-042 - UAT-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-042 | 部門一覧表示 | E-05 (list()) | ○ |
| UAT-043 | 新規部門追加 | E-05 (addSave()) | ○ |
| UAT-044 | 重複部門名チェック | E-05 (checkDeptNameUnique()) | ○ |
| UAT-045 | 部門情報編集 | E-05 (editSave()) | ○ |
| UAT-046 | 自己参照防止 | E-05 (parentId.equals(deptId)検証) | ○ |
| UAT-047 | 部門削除 | E-05 (remove()) | ○ |
| UAT-048 | 子部門存在時の削除防止 | E-05 (selectDeptCount()) | ○ |
| UAT-049 | ユーザー所属部門の削除防止 | E-05 (checkDeptExistUser()) | ○ |
| UAT-050 | 有効子部門持つ部門の無効化防止 | E-05 (selectNormalChildrenDeptById()) | ○ |

### 岗位管理機能（UAT-051 - UAT-055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-051 | 岗位一覧表示 | E-06 (list()) | ○ |
| UAT-052 | 新規岗位追加 | E-06 (addSave()) | ○ |
| UAT-053 | 岗位情報編集 | E-06 (editSave()) | ○ |
| UAT-054 | 岗位削除 | E-06 (remove()) | ○ |
| UAT-055 | 岗位データエクスポート | E-06 (export()) | ○ |

### 通知公告機能（UAT-056 - UAT-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-056 | 通知一覧表示 | E-07 (list()) | ○ |
| UAT-057 | 新規通知追加 | E-07 (addSave()) | ○ |
| UAT-058 | 通知内容編集 | E-07 (editSave()) | ○ |
| UAT-059 | 通知削除 | E-07 (remove()) | ○ |
| UAT-060 | 通知詳細表示 | E-07 (view()) | ○ |

### 個人プロファイル機能（UAT-061 - UAT-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-061 | 個人情報表示 | E-08 (profile()) | ○ |
| UAT-062 | 個人情報編集 | E-08 (update()) | ○ |
| UAT-063 | パスワード変更 | E-08 (resetPwd()) | ○ |
| UAT-064 | 旧パスワード検証 | E-08 (passwordService.matches()) | ○ |
| UAT-065 | 新旧パスワード同一検証 | E-08 (同一パスワード検証) | ○ |
| UAT-066 | アバター変更 | E-08 (updateAvatar()) | ○ |

### 辞書管理機能（UAT-067 - UAT-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-067 | 辞書タイプ一覧表示 | E-09 (list()) | ○ |
| UAT-068 | 新規辞書タイプ追加 | E-09 (addSave()) | ○ |
| UAT-069 | 辞書タイプ編集 | E-09 (editSave()) | ○ |
| UAT-070 | 辞書タイプ削除 | E-09 (remove()) | ○ |
| UAT-071 | 辞書キャッシュリフレッシュ | E-09 (refreshCache()) | ○ |

### パラメータ設定機能（UAT-072 - UAT-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-072 | パラメータ一覧表示 | E-10 (list()) | ○ |
| UAT-073 | 新規パラメータ追加 | E-10 (addSave()) | ○ |
| UAT-074 | パラメータ編集 | E-10 (editSave()) | ○ |
| UAT-075 | パラメータ削除 | E-10 (remove()) | ○ |
| UAT-076 | パラメータキャッシュリフレッシュ | E-10 (refreshCache()) | ○ |

### オンラインユーザー監視機能（UAT-077 - UAT-079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-077 | オンラインユーザー一覧表示 | E-12 (list()) | ○ |
| UAT-078 | 強制ログアウト | E-12 (batchForceLogout()) | ○ |
| UAT-079 | 自己強制ログアウト防止 | E-12 (sessionId.equals検証) | ○ |

### 操作ログ機能（UAT-080 - UAT-084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-080 | 操作ログ一覧表示 | E-13 (list()) | ○ |
| UAT-081 | 操作ログ詳細表示 | E-13 (detail()) | ○ |
| UAT-082 | 操作ログ削除 | E-13 (remove()) | ○ |
| UAT-083 | 操作ログクリア | E-13 (clean()) | ○ |
| UAT-084 | 操作ログエクスポート | E-13 (export()) | ○ |

### 定時タスク機能（UAT-085 - UAT-091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-085 | 定時タスク一覧表示 | E-14 (list()) | ○ |
| UAT-086 | 新規定時タスク追加 | E-14 (addSave()) | ○ |
| UAT-087 | Cron式妥当性検証 | E-14 (CronUtils.isValid()) | ○ |
| UAT-088 | 定時タスク編集 | E-14 (editSave()) | ○ |
| UAT-089 | 定時タスク削除 | E-14 (remove()) | ○ |
| UAT-090 | タスク状態変更 | E-14 (changeStatus()) | ○ |
| UAT-091 | タスク即時実行 | E-14 (run()) | ○ |

### コード生成機能（UAT-092 - UAT-098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-092 | テーブル一覧表示 | E-15 (genList()) | ○ |
| UAT-093 | テーブルインポート | E-15 (importTableSave()) | ○ |
| UAT-094 | 生成設定編集 | E-15 (editSave()) | ○ |
| UAT-095 | コードプレビュー | E-15 (preview()) | ○ |
| UAT-096 | コードダウンロード | E-15 (download()) | ○ |
| UAT-097 | データベース同期 | E-15 (synchDb()) | ○ |
| UAT-098 | テーブル作成 | E-15 (create(), @RequiresRoles("admin")) | ○ |

### 権限制御機能（UAT-099 - UAT-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UAT-099 | 権限のない機能へのアクセス制御 | 全コントローラー (@RequiresPermissions) | △ |
| UAT-100 | データスコープ外データへのアクセス制御 | E-18 | △ |

## 4) 不足情報（Unknown / Missing）
- **UAT-099, UAT-100**: 一般的なセキュリティテストケースとして記載しているが、具体的なテスト対象画面・シナリオの詳細化が推奨される
  - 候補：各機能画面ごとの権限パターンテスト / 部門間データアクセステスト / クロスロールテスト
- **フロントエンド検証**: HTMLテンプレートやJavaScript側の入力検証ロジックは本分析対象外
  - 候補：`resources/templates/` 配下のThymeleafテンプレート解析

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UAT-051 - UAT-055（岗位管理）、UAT-060（通知詳細）、UAT-066（アバター変更）
- **1（中リスク）**: UAT-099, UAT-100（権限制御の網羅性確認が必要）
- **2（高リスク）**: なし

## 6) レビュアーチェックリスト（最小）
- [ ] ログイン機能のテストケース（UAT-001 - UAT-008）が実際のログインフローを網羅しているか
- [ ] ユーザー管理機能の一意性検証（ログイン名、電話、メール）のテストケースが十分か
- [ ] ロール・メニュー・部門の階層構造に関する削除制約のテストケースが適切か
- [ ] 権限制御テスト（UAT-099, UAT-100）の具体的なシナリオ詳細化が必要か
- [ ] 業務ドメイン固有のシナリオ（例：承認フロー等）が存在する場合、追加テストケースが必要か
- [ ] 非機能テスト（性能、セキュリティ）は別途計画されているか
