---
generated_at: 2026-01-08 12:00:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 根拠不足の項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java`
- E-04: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java`
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictDataController.java`
- E-06: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-07: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java`
- E-08: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java`
- E-09: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-10: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java`
- E-11: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoOperateController.java`
- E-12: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoTableController.java`
- E-13: `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java`
- E-14: `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Excel.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 用户数据帳票はSysUserController.export()でエクスポート可能 | E-01（81-90行目: export()メソッド、ExcelUtil使用） | ○ |
| C-02 | 角色数据帳票はSysRoleController.export()でエクスポート可能 | E-02（66-75行目: export()メソッド、ExcelUtil使用） | ○ |
| C-03 | 岗位数据帳票はSysPostController.export()でエクスポート可能 | E-03（54-63行目: export()メソッド、ExcelUtil使用） | ○ |
| C-04 | 字典类型帳票はSysDictTypeController.export()でエクスポート可能 | E-04（55-65行目: export()メソッド、ExcelUtil使用） | ○ |
| C-05 | 字典数据帳票はSysDictDataController.export()でエクスポート可能 | E-05（54-63行目: export()メソッド、ExcelUtil使用） | ○ |
| C-06 | 参数数据帳票はSysConfigController.export()でエクスポート可能 | E-06（57-66行目: export()メソッド、ExcelUtil使用） | ○ |
| C-07 | 操作日志帳票はSysOperlogController.export()でエクスポート可能 | E-07（53-62行目: export()メソッド、ExcelUtil使用） | ○ |
| C-08 | 登录日志帳票はSysLogininforController.export()でエクスポート可能 | E-08（55-64行目: export()メソッド、ExcelUtil使用） | ○ |
| C-09 | 定时任务帳票はSysJobController.export()でエクスポート可能 | E-09（61-70行目: export()メソッド、ExcelUtil使用） | ○ |
| C-10 | 调度日志帳票はSysJobLogController.export()でエクスポート可能 | E-10（65-74行目: export()メソッド、ExcelUtil使用） | ○ |
| C-11 | デモ用户数据帳票はDemoOperateController/DemoTableControllerでエクスポート可能 | E-11（191-198行目）、E-12（194-218行目: exportData()メソッド） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全ての帳票エクスポート機能についてソースコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] 全てのexport()メソッドを持つControllerを網羅的に調査済み
- [x] ExcelUtilクラスと@Excelアノテーションの使用を確認済み
- [ ] 実際にエクスポート機能を実行して出力されるExcelファイルの内容を確認
- [ ] 各ドメインクラスの@Excelアノテーション定義と出力カラムの対応を詳細確認
