# 帳票設計書 1-用户数据

## 概要

本ドキュメントは、RuoYiシステムにおけるユーザー情報のExcelエクスポート機能に関する帳票設計書である。システム管理者がユーザー管理画面からユーザー情報をExcel形式で一括出力するための仕様を定義する。

### 本帳票の処理概要

本帳票は、システムに登録されているユーザー情報をExcel形式でエクスポートする機能を提供する。

**業務上の目的・背景**：システム管理者がユーザー情報を一覧で確認・管理するため、または外部システムとのデータ連携や監査対応のためにユーザー情報を出力する必要がある。Excelファイルとして出力することで、データの二次利用や加工が容易になり、組織内での情報共有を効率化する。

**帳票の利用シーン**：ユーザー管理画面において、検索条件を指定してユーザー一覧を絞り込んだ後、「エクスポート」ボタンをクリックすることで、条件に合致するユーザー情報をExcelファイルとしてダウンロードする。定期的な棚卸し作業、部門別のユーザー一覧作成、外部監査対応などで利用される。

**主要な出力内容**：
1. ユーザー基本情報（ユーザーID、ログイン名、ユーザー名）
2. 連絡先情報（メールアドレス、電話番号）
3. 所属情報（部門名、部門責任者）
4. アカウント状態情報（性別、アカウント状態、最終ログインIP、最終ログイン日時）

**帳票の出力タイミング**：ユーザー管理画面（/system/user）の一覧画面から「エクスポート」ボタンをクリックした時点で、現在の検索条件に基づいてデータを取得し、Excelファイルを生成してダウンロードする。

**帳票の利用者**：システム管理者、セキュリティ管理者、監査担当者

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| SYS-001 | ユーザー管理 | /system/user | 「エクスポート」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | A4横相当（印刷時） |
| 向き | 横 |
| ファイル名 | 用户数据_{yyyyMMddHHmmss}.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 用户数据 |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、1行目にヘッダー行、2行目以降にデータ行が出力される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（項目名）          │
├─────────────────────────────────────┤
│         データ行1                    │
│         データ行2                    │
│         ...                         │
│         データ行N                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 用户序号 | ユーザーID | sys_user.user_id | 数値 |
| 2 | 登录名称 | ログイン名 | sys_user.login_name | 文字列 |
| 3 | 用户名称 | ユーザー名 | sys_user.user_name | 文字列 |
| 4 | 用户邮箱 | メールアドレス | sys_user.email | 文字列 |
| 5 | 手机号码 | 電話番号 | sys_user.phonenumber | 文字列 |
| 6 | 用户性别 | 性別 | sys_user.sex | 0=男,1=女,2=未知 |
| 7 | 账号状态 | アカウント状態 | sys_user.status | 0=正常,1=停用 |
| 8 | 最后登录IP | 最終ログインIP | sys_user.login_ip | 文字列 |
| 9 | 最后登录时间 | 最終ログイン日時 | sys_user.login_date | yyyy-MM-dd HH:mm:ss |
| 10 | 部门名称 | 部門名 | sys_dept.dept_name | 文字列 |
| 11 | 部门负责人 | 部門責任者 | sys_dept.leader | 文字列 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 用户序号 | ユーザーID | sys_user.user_id | 数値 | 15 |
| 2 | 登录名称 | ログイン名 | sys_user.login_name | 文字列 | 20 |
| 3 | 用户名称 | ユーザー名 | sys_user.user_name | 文字列 | 20 |
| 4 | 用户邮箱 | メールアドレス | sys_user.email | 文字列 | 30 |
| 5 | 手机号码 | 電話番号 | sys_user.phonenumber | 文字列 | 15 |
| 6 | 用户性别 | 性別 | sys_user.sex | 変換表示 | 10 |
| 7 | 账号状态 | アカウント状態 | sys_user.status | 変換表示 | 12 |
| 8 | 最后登录IP | 最終ログインIP | sys_user.login_ip | 文字列 | 20 |
| 9 | 最后登录时间 | 最終ログイン日時 | sys_user.login_date | 日時 | 25 |
| 10 | 部门名称 | 部門名 | sys_dept.dept_name | 文字列 | 20 |
| 11 | 部门负责人 | 部門責任者 | sys_dept.leader | 文字列 | 15 |

### フッター部

本帳票にフッター部はない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ログイン名 | 部分一致検索 | No |
| ユーザー名 | 部分一致検索 | No |
| 電話番号 | 部分一致検索 | No |
| 状態 | 完全一致（0/1） | No |
| 部門ID | 完全一致 | No |
| 作成日From | 範囲検索 | No |
| 作成日To | 範囲検索 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | user_id | 昇順 |

### 改ページ条件

Excel出力のため、65536行を超える場合は新しいシートを作成

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sys_user | ユーザー基本情報 | メインテーブル |
| sys_dept | 部門情報 | sys_user.dept_id = sys_dept.dept_id |

### テーブル別参照項目詳細

#### sys_user

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| user_id | 用户序号 | del_flag = '0' | 削除されていないユーザー |
| login_name | 登录名称 | - | - |
| user_name | 用户名称 | - | - |
| email | 用户邮箱 | - | - |
| phonenumber | 手机号码 | - | - |
| sex | 用户性别 | - | 0=男,1=女,2=未知に変換 |
| status | 账号状态 | - | 0=正常,1=停用に変換 |
| login_ip | 最后登录IP | - | - |
| login_date | 最后登录时间 | - | - |

#### sys_dept

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| dept_name | 部门名称 | - | 関連する部門の名称 |
| leader | 部门负责人 | - | 関連する部門の責任者 |

## 計算仕様

### 計算項目一覧

本帳票に計算項目はない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートボタン押下] --> B[権限チェック]
    B --> C{system:user:export権限あり?}
    C -->|No| D[権限エラー]
    C -->|Yes| E[検索条件取得]
    E --> F[userService.selectUserList呼出]
    F --> G[データ取得]
    G --> H[ExcelUtil初期化]
    H --> I[@Excelアノテーション解析]
    I --> J[ヘッダー行生成]
    J --> K[データ行生成]
    K --> L[値変換処理]
    L --> M[Excelファイル生成]
    M --> N[ファイルダウンロード]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | system:user:export権限がない場合 | 権限がありません | 管理者に権限付与を依頼 |
| データなし | 検索条件に該当するデータがない場合 | 空のExcelファイルが出力される | 検索条件を見直す |
| システムエラー | Excel生成時にエラーが発生した場合 | エクスポートに失敗しました | システム管理者に連絡 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1000件 |
| 目標出力時間 | 5秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- system:user:export権限を持つユーザーのみエクスポート可能
- パスワード、ソルト情報はエクスポート対象外（@JsonIgnoreアノテーション）
- 操作ログに「用户管理」「EXPORT」として記録される

## 備考

- @Excelアノテーションにより出力項目を定義
- readConverterExp属性により数値から文字列への変換を実現
- Type.EXPORT属性により出力専用項目を指定

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | @Excelアノテーションの定義、フィールド構成、readConverterExpの変換ルール |
| 1-2 | SysDept.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` | 部門情報の構造、@Excelsによるネスト出力 |

**読解のコツ**: @Excelアノテーションのname属性がヘッダー名、typeがEXPORT/IMPORTを制御、readConverterExpが値変換ルールを定義

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysUserController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` | exportメソッド（81-90行目）、権限チェック、ExcelUtil呼び出し |

**主要処理フロー**:
1. **81-82行**: @Log、@RequiresPermissionsで操作ログと権限制御
2. **87行**: userService.selectUserList(user)でデータ取得
3. **88行**: ExcelUtil<SysUser>インスタンス生成
4. **89行**: exportExcel(list, "用户数据")でExcel出力

#### Step 3: Serviceレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | selectUserListメソッドの定義 |
| 3-2 | SysUserServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java` | 検索ロジック、データスコープ制御 |

#### Step 4: Excel出力ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | exportExcelメソッド、@Excelアノテーション解析、SXSSFWorkbook生成 |
| 4-2 | Excel.java | `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Excel.java` | アノテーション定義、属性の意味 |

**主要処理フロー**:
- フィールドスキャン → @Excelアノテーション抽出 → ヘッダー生成 → データ行生成 → ファイル出力

### プログラム呼び出し階層図

```
SysUserController.export()
    │
    ├─ userService.selectUserList(user)
    │      └─ SysUserMapper.selectUserList()
    │             └─ SQL実行（sys_user, sys_dept結合）
    │
    └─ ExcelUtil.exportExcel(list, sheetName)
           ├─ createExcelField() - @Excelアノテーション解析
           ├─ createWorkbook() - SXSSFWorkbook生成
           ├─ createTitle() - タイトル行生成
           ├─ createSubHead() - ヘッダー行生成
           └─ fillExcelData() - データ行生成
                  └─ addCell() - セル値設定、変換処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysUserController.export() ───▶ Excelファイル
(SysUser)    │                              (用户数据_{日時}.xlsx)
             ├─▶ ISysUserService
             │      └─▶ SysUserMapper
             │             └─▶ MySQL
             │
             └─▶ ExcelUtil
                    └─▶ Apache POI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysUserController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` | ソース | エントリーポイント、exportメソッド定義 |
| SysUser.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` | ソース | ユーザーエンティティ、@Excelアノテーション定義 |
| SysDept.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysDept.java` | ソース | 部門エンティティ |
| ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | ソース | サービスインターフェース |
| SysUserServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java` | ソース | サービス実装 |
| SysUserMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserMapper.java` | ソース | Mapperインターフェース |
| SysUserMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` | 設定 | SQL定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel出力ユーティリティ |
| Excel.java | `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Excel.java` | ソース | Excelアノテーション定義 |
