# 帳票設計書 10-调度日志

## 概要

本ドキュメントは、RuoYiシステムにおけるスケジュール実行ログのExcelエクスポート機能に関する帳票設計書である。システム管理者がスケジュールログ管理画面からスケジュール実行ログ情報をExcel形式で一括出力するための仕様を定義する。

### 本帳票の処理概要

本帳票は、システムで記録されたスケジュールタスクの実行ログ情報をExcel形式でエクスポートする機能を提供する。

**業務上の目的・背景**：システム管理者がスケジュールタスクの実行履歴を一覧で確認・分析するため、またはタスク実行結果の監査や障害調査のために実行ログを出力する必要がある。Excelファイルとして出力することで、実行履歴の分析や報告書作成が容易になり、システム運用・保守の効率化に寄与する。

**帳票の利用シーン**：スケジュールログ管理画面において、検索条件を指定してスケジュールログ一覧を絞り込んだ後、「エクスポート」ボタンをクリックすることで、条件に合致するスケジュール実行ログ情報をExcelファイルとしてダウンロードする。タスク実行結果の監査、障害調査、実行履歴の定期的なバックアップなどで利用される。

**主要な出力内容**：
1. ログ基本情報（ログID、タスク名、タスクグループ）
2. 実行情報（呼出対象、ログ情報）
3. 結果情報（実行状態、例外情報）

**帳票の出力タイミング**：スケジュールログ管理画面（/monitor/jobLog）の一覧画面から「エクスポート」ボタンをクリックした時点で、現在の検索条件に基づいてデータを取得し、Excelファイルを生成してダウンロードする。

**帳票の利用者**：システム管理者、運用担当者

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| MON-004 | スケジュールログ管理 | /monitor/jobLog | 「エクスポート」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | A4横相当（印刷時） |
| 向き | 横 |
| ファイル名 | 调度日志_{yyyyMMddHHmmss}.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 调度日志 |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、1行目にヘッダー行、2行目以降にデータ行が出力される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（項目名）          │
├─────────────────────────────────────┤
│         データ行1                    │
│         データ行2                    │
│         ...                         │
│         データ行N                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 日志序号 | ログID | sys_job_log.job_log_id | 数値 |
| 2 | 任务名称 | タスク名 | sys_job_log.job_name | 文字列 |
| 3 | 任务组名 | タスクグループ | sys_job_log.job_group | 文字列 |
| 4 | 调用目标字符串 | 呼出対象 | sys_job_log.invoke_target | 文字列 |
| 5 | 日志信息 | ログ情報 | sys_job_log.job_message | 文字列 |
| 6 | 执行状态 | 実行状態 | sys_job_log.status | 変換表示 |
| 7 | 异常信息 | 例外情報 | sys_job_log.exception_info | 文字列 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 日志序号 | ログID | sys_job_log.job_log_id | 数値 | 12 |
| 2 | 任务名称 | タスク名 | sys_job_log.job_name | 文字列 | 20 |
| 3 | 任务组名 | タスクグループ | sys_job_log.job_group | 文字列 | 15 |
| 4 | 调用目标字符串 | 呼出対象 | sys_job_log.invoke_target | 文字列 | 50 |
| 5 | 日志信息 | ログ情報 | sys_job_log.job_message | 文字列 | 30 |
| 6 | 执行状态 | 実行状態 | sys_job_log.status | 変換表示 | 10 |
| 7 | 异常信息 | 例外情報 | sys_job_log.exception_info | 文字列 | 50 |

### フッター部

本帳票にフッター部はない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| タスク名 | 部分一致検索 | No |
| タスクグループ | 完全一致検索 | No |
| 実行状態 | 完全一致（0/1） | No |
| 開始時間From | 範囲検索 | No |
| 開始時間To | 範囲検索 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | job_log_id | 降順 |

### 改ページ条件

Excel出力のため、65536行を超える場合は新しいシートを作成

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sys_job_log | スケジュール実行ログ基本情報 | メインテーブル |

### テーブル別参照項目詳細

#### sys_job_log

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| job_log_id | 日志序号 | - | - |
| job_name | 任务名称 | - | - |
| job_group | 任务组名 | - | - |
| invoke_target | 调用目标字符串 | - | - |
| job_message | 日志信息 | - | - |
| status | 执行状态 | - | 0=正常,1=失败に変換 |
| exception_info | 异常信息 | - | - |

## 計算仕様

### 計算項目一覧

本帳票に計算項目はない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートボタン押下] --> B[権限チェック]
    B --> C{monitor:job:export権限あり?}
    C -->|No| D[権限エラー]
    C -->|Yes| E[検索条件取得]
    E --> F[jobLogService.selectJobLogList呼出]
    F --> G[データ取得]
    G --> H[ExcelUtil初期化]
    H --> I[@Excelアノテーション解析]
    I --> J[ヘッダー行生成]
    J --> K[データ行生成]
    K --> L[値変換処理]
    L --> M[Excelファイル生成]
    M --> N[ファイルダウンロード]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | monitor:job:export権限がない場合 | 権限がありません | 管理者に権限付与を依頼 |
| データなし | 検索条件に該当するデータがない場合 | 空のExcelファイルが出力される | 検索条件を見直す |
| システムエラー | Excel生成時にエラーが発生した場合 | エクスポートに失敗しました | システム管理者に連絡 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 10000件 |
| 目標出力時間 | 10秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- monitor:job:export権限を持つユーザーのみエクスポート可能
- 操作ログに「调度日志」「EXPORT」として記録される
- 例外情報にはスタックトレースが含まれる可能性があるため、出力ファイルの取り扱いに注意

## 備考

- @Excelアノテーションにより出力項目を定義
- readConverterExp属性により実行状態の変換を実現
- スケジュールログはスケジュールタスク実行時に自動記録される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysJobLog.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` | @Excelアノテーションの定義、statusの変換ルール |

**読解のコツ**: @ExcelアノテーションのreadConverterExpで実行状態（正常/失敗）の変換が定義されている

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysJobLogController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java` | exportメソッド（65-74行目）、権限チェック、ExcelUtil呼び出し |

**主要処理フロー**:
1. **65-66行**: @Log、@RequiresPermissionsで操作ログと権限制御
2. **71行**: jobLogService.selectJobLogList(jobLog)でデータ取得
3. **72行**: ExcelUtil<SysJobLog>インスタンス生成
4. **73行**: exportExcel(list, "调度日志")でExcel出力

### プログラム呼び出し階層図

```
SysJobLogController.export()
    │
    ├─ jobLogService.selectJobLogList(jobLog)
    │      └─ SysJobLogMapper.selectJobLogList()
    │             └─ SQL実行（sys_job_log）
    │
    └─ ExcelUtil.exportExcel(list, sheetName)
           ├─ createExcelField() - @Excelアノテーション解析
           ├─ createWorkbook() - SXSSFWorkbook生成
           └─ fillExcelData() - データ行生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysJobLogController.export() ───▶ Excelファイル
(SysJobLog)  │                              (调度日志_{日時}.xlsx)
             ├─▶ ISysJobLogService
             │      └─▶ SysJobLogMapper
             │             └─▶ MySQL
             │
             └─▶ ExcelUtil
                    └─▶ Apache POI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysJobLogController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java` | ソース | エントリーポイント、exportメソッド定義 |
| SysJobLog.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` | ソース | スケジュールログエンティティ、@Excelアノテーション定義 |
| ISysJobLogService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobLogService.java` | ソース | サービスインターフェース |
| SysJobLogMapper.xml | `ruoyi-quartz/src/main/resources/mapper/quartz/SysJobLogMapper.xml` | 設定 | SQL定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel出力ユーティリティ |
