# 帳票設計書 11-用户数据（デモ）

## 概要

本ドキュメントは、RuoYiシステムのデモ機能で提供される「用户数据（デモ）」帳票のエクスポート機能に関する設計書である。この帳票は、システムの操作デモおよびテーブル表示デモ機能において、ユーザーデータをExcel形式でエクスポートするための仕様を定義する。

### 本帳票の処理概要

**業務上の目的・背景**：本帳票は、RuoYiシステムのExcelエクスポート機能のデモンストレーションを目的として設計されている。システム導入時の機能確認、開発者向けのサンプル実装の提示、および新規機能開発時の参照用として使用される。実際の業務データではなく、テスト用のダミーデータを使用することで、本番環境に影響を与えずにExcelエクスポート機能の動作確認が可能となる。

**帳票の利用シーン**：本帳票は以下のような場面で利用される。
1. システム導入検討時のExcelエクスポート機能のデモンストレーション
2. 開発者がカスタムExcelエクスポート機能を実装する際の参照実装として
3. システム運用担当者向けの操作トレーニング時の練習用データとして
4. システムの動作確認・テスト時のサンプルデータ出力として

**主要な出力内容**：
1. ユーザー編号（userCode）：7桁の一意なユーザー識別番号
2. ユーザー姓名（userName）：ユーザーの表示名
3. ユーザー性別（userSex）：性別情報（0=男、1=女、2=未知として変換表示）
4. ユーザー手機（userPhone）：電話番号
5. ユーザー郵箱（userEmail）：メールアドレス
6. ユーザー余額（userBalance）：残高情報
7. ユーザー状態（status）：アカウント状態（0=正常、1=停用として変換表示）
8. 創建時間（createTime）：レコード作成日時（エクスポートのみ）

**帳票の出力タイミング**：ユーザーがデモ画面（操作デモまたはテーブルデモ）にアクセスし、「導出」ボタンをクリックした際にExcelファイルが生成され、ダウンロードされる。

**帳票の利用者**：システム管理者、開発者、システム導入検討者、運用担当者

## 帳票種別

一覧表（デモ用ユーザーデータの一覧エクスポート）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| DEMO-01 | 操作デモ画面 | /demo/operate/table | 「導出」ボタン押下 |
| DEMO-02 | テーブルエクスポートデモ | /demo/table/export | テーブル上部のエクスポートボタン |
| DEMO-03 | 列選択エクスポートデモ | /demo/table/exportSelected | 「導出」ボタン押下（選択行のみ） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | 該当なし（電子ファイル） |
| 向き | 該当なし |
| ファイル名 | {UUID}_用户数据.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 用户数据 |
| 保護設定 | 無 |
| 最大行数/シート | 65536行 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、ヘッダー行（列タイトル）と明細行（データ）からなる。データ件数が65536行を超える場合は、複数シートに分割して出力される。

```
┌─────────────────────────────────────────────────────────────────────────────┐
│   A        B          C          D          E          F        G      H    │
├─────────────────────────────────────────────────────────────────────────────┤
│用户编号  用户姓名   用户性别   用户手机    用户邮箱   用户余额  用户状态 创建时间│  ← ヘッダー行
├─────────────────────────────────────────────────────────────────────────────┤
│1000001   测试1      男        15888888888 ry@qq.com  150.0    正常   yyyy-MM-dd│
│1000002   测试2      女        15666666666 ry@qq.com  180.0    停用   yyyy-MM-dd│
│...                                                                           │
└─────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | - | ヘッダー部は存在しない（タイトル行がヘッダーを兼ねる） | - | - |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 用户编号 | ユーザー識別番号 | UserOperateModel.userCode / UserTableModel.userCode | 文字列 | 16 |
| 2 | 用户姓名 | ユーザー名 | UserOperateModel.userName / UserTableModel.userName | 文字列 | 16 |
| 3 | 用户性别 | 性別 | UserOperateModel.userSex | 0=男,1=女,2=未知 | 16 |
| 4 | 用户手机 | 電話番号 | UserOperateModel.userPhone / UserTableModel.userPhone | 文字列 | 16 |
| 5 | 用户邮箱 | メールアドレス | UserOperateModel.userEmail / UserTableModel.userEmail | 文字列 | 16 |
| 6 | 用户余额 | 残高 | UserOperateModel.userBalance / UserTableModel.userBalance | 数値 | 16 |
| 7 | 用户状态 | アカウント状態 | UserOperateModel.status | 0=正常,1=停用 | 16 |
| 8 | 创建时间 | 作成日時（DemoOperateControllerのみ） | UserOperateModel.createTime | yyyy-MM-dd HH:mm:ss | 30 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| - | - | フッター部は存在しない | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| なし（全件出力） | 静的データからすべてのレコードを出力 | - |
| userIds（列選択エクスポート時） | 選択されたユーザーIDに絞り込み | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | userId | 昇順（データ登録順） |

### 改ページ条件

Excel形式のため物理的な改ページはないが、65536行を超える場合は新しいシートに分割される。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用せず、コントローラー内で定義された静的データ（インメモリ）を使用する。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| （なし） | 静的データを使用 | - |

### データソース詳細

#### DemoOperateController - 静的データ定義

| フィールド | 帳票項目との対応 | 初期データ件数 | 備考 |
|-----------|----------------|--------------|------|
| users（LinkedHashMap） | 全項目 | 26件 | userId(1-26)をキーとしたマップ |

#### DemoTableController - 静的データ定義

| フィールド | 帳票項目との対応 | 初期データ件数 | 備考 |
|-----------|----------------|--------------|------|
| users（ArrayList） | 用户编号、用户姓名、用户手机、用户邮箱、用户余额 | 26件 | リスト形式で保持 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| なし | - | - | 計算項目は存在しない |

### 値変換仕様

| 項目名 | 変換式 | 備考 |
|-------|-------|------|
| 用户性别 | 0=男, 1=女, 2=未知 | @Excel(readConverterExp)による変換 |
| 用户状态 | 0=正常, 1=停用 | @Excel(readConverterExp)による変換 |
| 创建时间 | yyyy-MM-dd HH:mm:ss形式 | @Excel(dateFormat)による変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ユーザー操作: 導出ボタン押下] --> B[POST /demo/operate/export または /demo/table/exportData]
    B --> C[Controllerでリクエスト受信]
    C --> D[静的データからリストを取得]
    D --> E{userIds指定あり?}
    E -->|Yes| F[指定IDでフィルタリング]
    E -->|No| G[全件取得]
    F --> H[ExcelUtil初期化]
    G --> H
    H --> I[exportExcel実行]
    I --> J[@Excelアノテーション解析]
    J --> K[シート作成・ヘッダー行生成]
    K --> L[データ行生成ループ]
    L --> M[値変換処理]
    M --> N[Excelファイル書き込み]
    N --> O[一時ファイル保存]
    O --> P[AjaxResultでファイル名返却]
    P --> Q[クライアント側でダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | usersリストが空 | （空のExcelファイルが生成される） | 正常動作（空ファイル） |
| 出力失敗 | ファイル書き込みエラー | 导出Excel失败，请联系网站管理员！ | ログ確認・権限確認 |
| インポートデータ空 | importData時にファイルが空 | 导入用户数据不能为空！ | 正しいデータを含むファイルを再アップロード |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 26件（静的データ） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 特に制限なし |

## セキュリティ考慮事項

- 本帳票はデモ用途であり、実際の個人情報は含まれない
- テストデータのみを使用するため、個人情報保護の観点からのリスクは低い
- アクセス制御はSpring Securityおよび権限管理機能により実施される
- CSVインジェクション対策として、`=-+@`で始まるセル値にはタブ文字がプレフィックスとして付与される（ExcelUtil.setCellVo メソッド、行1022-1025）

## 備考

- 本帳票は2つのコントローラー（DemoOperateController、DemoTableController）から出力可能
- DemoOperateControllerからのエクスポートでは「创建时间」列が含まれる
- DemoTableControllerからのエクスポートでは「用户性别」「用户状态」「创建时间」列は含まれない
- どちらのコントローラーも同一のExcelUtilクラスを使用してExcel生成を行う
- SXSSFWorkbook（ストリーミング方式）を使用し、大量データにも対応可能な設計

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象となるデータモデルの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UserOperateModel.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/domain/UserOperateModel.java` | @Excelアノテーションによるフィールド定義を確認。各フィールドの出力名、変換式、日付フォーマットを理解する |
| 1-2 | UserTableModel（内部クラス） | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoTableController.java` (行689-832) | DemoTableController内で定義される別のユーザーモデル。@Excelアノテーションの違いを比較する |
| 1-3 | Excel.java | `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Excel.java` | Excelエクスポート用アノテーションの全属性を確認 |

**読解のコツ**: @Excelアノテーションの各属性（name, readConverterExp, dateFormat, type, width等）の意味を把握することで、出力されるExcelの列構成と値変換ロジックが理解できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DemoOperateController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoOperateController.java` | exportメソッド（行191-198）が起点。静的データusersからリストを取得し、ExcelUtilへ渡す |
| 2-2 | DemoTableController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoTableController.java` | exportSelectedメソッド（行194-218）。userIds指定による絞り込み機能あり |

**主要処理フロー（DemoOperateController.export）**:
1. **行194**: 静的データusersからArrayListを生成
2. **行195-196**: ExcelUtil<UserOperateModel>をインスタンス化
3. **行197**: exportExcel(list, "用户数据")を呼び出し

**主要処理フロー（DemoTableController.exportSelected）**:
1. **行198-199**: usersリストのコピーを作成
2. **行202-215**: userIds指定時のフィルタリング処理
3. **行216-217**: ExcelUtilでエクスポート実行

#### Step 3: Excel生成処理を理解する

ExcelUtilクラスの内部処理を追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | exportExcel()メソッドがメイン。init()→writeSheet()→ファイル出力の流れ |

**主要処理フロー**:
- **行534-537**: exportExcel(List, sheetName) - エントリーポイント
- **行229-243**: init() - リスト、シート名、タイプの初期化とフィールド情報の抽出
- **行686-722**: writeSheet() - シート作成とヘッダー・データ行の書き込み
- **行730-792**: fillExcelData() - 各行のデータをセルに設定
- **行1127-1193**: addCell() - 個別セルの値設定と変換処理
- **行1016-1053**: setCellVo() - セルタイプ別の値設定

#### Step 4: フロントエンドの連携を理解する

画面からのエクスポート操作とダウンロード処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | table.html | `ruoyi-admin/src/main/resources/templates/demo/operate/table.html` | 導出ボタンの定義（行22-23）とexportUrl設定（行48） |
| 4-2 | exportSelected.html | `ruoyi-admin/src/main/resources/templates/demo/table/exportSelected.html` | exportSelected()関数（行100-117）でPOSTリクエストとダウンロード処理 |

### プログラム呼び出し階層図

```
画面操作（導出ボタン）
    │
    ├─ DemoOperateController.export()
    │      │
    │      ├─ new ArrayList<>(users.values())     [行195]
    │      │
    │      └─ ExcelUtil.exportExcel()             [行196-197]
    │             │
    │             ├─ init()                        [行549]
    │             │      ├─ createExcelField()
    │             │      │      └─ getFields() - @Excelアノテーション解析
    │             │      └─ createWorkbook()
    │             │
    │             └─ exportExcel()                 [行550→660-681]
    │                    ├─ writeSheet()
    │                    │      ├─ createSheet()
    │                    │      ├─ createHeadCell() - ヘッダー行生成
    │                    │      └─ fillExcelData() - データ行生成
    │                    │             └─ addCell()
    │                    │                    └─ setCellVo() / convertByExp()
    │                    ├─ encodingFilename()
    │                    └─ wb.write(out)
    │
    └─ DemoTableController.exportSelected()
           │
           ├─ Collections.copy(userList, users)   [行198-199]
           │
           ├─ userIds フィルタリング               [行202-215]
           │
           └─ ExcelUtil.exportExcel()             [行216-217]
                  └─ (同上)
```

### データフロー図

```
[入力]                       [処理]                              [出力]

静的データ                   Controller                          Excel
(LinkedHashMap/             ┌─────────────┐                     ファイル
 ArrayList)                 │             │                     ┌────────┐
    │                       │ データ取得  │                     │        │
    └──────────────────────►│ List生成    │                     │ .xlsx  │
                            │             │                     │        │
                            └──────┬──────┘                     │ シート │
                                   │                            │ ヘッダー│
                                   ▼                            │ データ │
                            ┌─────────────┐                     │        │
                            │  ExcelUtil  │                     └────────┘
                            │             │                          ▲
                            │ @Excel解析  │                          │
                            │ シート作成  │──────────────────────────┘
                            │ セル生成    │
                            │ 値変換      │
                            │ ファイル化  │
                            └─────────────┘
                                   │
                                   ▼
                            ┌─────────────┐
                            │ AjaxResult  │
                            │ ファイル名  │──────► クライアント
                            │   返却      │        ダウンロード
                            └─────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DemoOperateController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoOperateController.java` | ソース | 操作デモのコントローラー。export()メソッドでExcelエクスポート |
| DemoTableController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/controller/DemoTableController.java` | ソース | テーブルデモのコントローラー。exportSelected()メソッドで選択エクスポート |
| UserOperateModel.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/demo/domain/UserOperateModel.java` | ソース | 操作デモ用ユーザーモデル。@Excelアノテーションでエクスポート項目定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel生成ユーティリティ。Apache POIを使用したExcel生成処理 |
| Excel.java | `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Excel.java` | ソース | Excelエクスポート用カスタムアノテーション定義 |
| table.html | `ruoyi-admin/src/main/resources/templates/demo/operate/table.html` | テンプレート | 操作デモ画面。導出ボタンのUI定義 |
| export.html | `ruoyi-admin/src/main/resources/templates/demo/table/export.html` | テンプレート | テーブルエクスポートデモ画面 |
| exportSelected.html | `ruoyi-admin/src/main/resources/templates/demo/table/exportSelected.html` | テンプレート | 列選択エクスポートデモ画面 |
