# 帳票設計書 2-角色数据

## 概要

本ドキュメントは、RuoYiシステムにおけるロール情報のExcelエクスポート機能に関する帳票設計書である。システム管理者がロール管理画面からロール情報をExcel形式で一括出力するための仕様を定義する。

### 本帳票の処理概要

本帳票は、システムに登録されているロール（役割）情報をExcel形式でエクスポートする機能を提供する。

**業務上の目的・背景**：システム管理者がロール情報を一覧で確認・管理するため、または権限設計の見直しや監査対応のためにロール情報を出力する必要がある。Excelファイルとして出力することで、権限体系の分析や文書化が容易になり、セキュリティ管理の効率化に寄与する。

**帳票の利用シーン**：ロール管理画面において、検索条件を指定してロール一覧を絞り込んだ後、「エクスポート」ボタンをクリックすることで、条件に合致するロール情報をExcelファイルとしてダウンロードする。権限体系の棚卸し、セキュリティ監査対応、新システム移行時の権限設計資料作成などで利用される。

**主要な出力内容**：
1. ロール基本情報（ロールID、ロール名、権限キー）
2. 表示設定（表示順序）
3. データ権限設定（データスコープ）
4. ロール状態情報（状態）

**帳票の出力タイミング**：ロール管理画面（/system/role）の一覧画面から「エクスポート」ボタンをクリックした時点で、現在の検索条件に基づいてデータを取得し、Excelファイルを生成してダウンロードする。

**帳票の利用者**：システム管理者、セキュリティ管理者、監査担当者

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| SYS-002 | ロール管理 | /system/role | 「エクスポート」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | A4横相当（印刷時） |
| 向き | 横 |
| ファイル名 | 角色数据_{yyyyMMddHHmmss}.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 角色数据 |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、1行目にヘッダー行、2行目以降にデータ行が出力される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（項目名）          │
├─────────────────────────────────────┤
│         データ行1                    │
│         データ行2                    │
│         ...                         │
│         データ行N                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 角色序号 | ロールID | sys_role.role_id | 数値 |
| 2 | 角色名称 | ロール名 | sys_role.role_name | 文字列 |
| 3 | 角色权限 | 権限キー | sys_role.role_key | 文字列 |
| 4 | 角色排序 | 表示順序 | sys_role.role_sort | 数値 |
| 5 | 数据范围 | データスコープ | sys_role.data_scope | 変換表示 |
| 6 | 角色状态 | ロール状態 | sys_role.status | 変換表示 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 角色序号 | ロールID | sys_role.role_id | 数値 | 15 |
| 2 | 角色名称 | ロール名 | sys_role.role_name | 文字列 | 25 |
| 3 | 角色权限 | 権限キー | sys_role.role_key | 文字列 | 25 |
| 4 | 角色排序 | 表示順序 | sys_role.role_sort | 数値 | 12 |
| 5 | 数据范围 | データスコープ | sys_role.data_scope | 変換表示 | 20 |
| 6 | 角色状态 | ロール状態 | sys_role.status | 変換表示 | 12 |

### フッター部

本帳票にフッター部はない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ロール名 | 部分一致検索 | No |
| 権限キー | 部分一致検索 | No |
| 状態 | 完全一致（0/1） | No |
| 作成日From | 範囲検索 | No |
| 作成日To | 範囲検索 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | role_sort | 昇順 |

### 改ページ条件

Excel出力のため、65536行を超える場合は新しいシートを作成

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sys_role | ロール基本情報 | メインテーブル |

### テーブル別参照項目詳細

#### sys_role

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| role_id | 角色序号 | del_flag = '0' | 削除されていないロール |
| role_name | 角色名称 | - | - |
| role_key | 角色权限 | - | - |
| role_sort | 角色排序 | - | - |
| data_scope | 数据范围 | - | 1=所有数据权限,2=自定义数据权限,3=本部门数据权限,4=本部门及以下数据权限,5=仅本人数据权限 |
| status | 角色状态 | - | 0=正常,1=停用に変換 |

## 計算仕様

### 計算項目一覧

本帳票に計算項目はない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートボタン押下] --> B[権限チェック]
    B --> C{system:role:export権限あり?}
    C -->|No| D[権限エラー]
    C -->|Yes| E[検索条件取得]
    E --> F[roleService.selectRoleList呼出]
    F --> G[データ取得]
    G --> H[ExcelUtil初期化]
    H --> I[@Excelアノテーション解析]
    I --> J[ヘッダー行生成]
    J --> K[データ行生成]
    K --> L[値変換処理]
    L --> M[Excelファイル生成]
    M --> N[ファイルダウンロード]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | system:role:export権限がない場合 | 権限がありません | 管理者に権限付与を依頼 |
| データなし | 検索条件に該当するデータがない場合 | 空のExcelファイルが出力される | 検索条件を見直す |
| システムエラー | Excel生成時にエラーが発生した場合 | エクスポートに失敗しました | システム管理者に連絡 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 100件 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- system:role:export権限を持つユーザーのみエクスポート可能
- 操作ログに「角色管理」「EXPORT」として記録される

## 備考

- @Excelアノテーションにより出力項目を定義
- readConverterExp属性により数値から文字列への変換を実現
- データスコープの変換は5種類のパターンに対応

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysRole.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java` | @Excelアノテーションの定義、フィールド構成、データスコープの変換ルール |

**読解のコツ**: @Excelアノテーションのname属性がヘッダー名、readConverterExpがdata_scopeの5種類の変換ルールを定義

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysRoleController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` | exportメソッド（66-75行目）、権限チェック、ExcelUtil呼び出し |

**主要処理フロー**:
1. **66-67行**: @Log、@RequiresPermissionsで操作ログと権限制御
2. **72行**: roleService.selectRoleList(role)でデータ取得
3. **73行**: ExcelUtil<SysRole>インスタンス生成
4. **74行**: exportExcel(list, "角色数据")でExcel出力

#### Step 3: Serviceレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysRoleService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java` | selectRoleListメソッドの定義 |
| 3-2 | SysRoleServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysRoleServiceImpl.java` | 検索ロジック |

### プログラム呼び出し階層図

```
SysRoleController.export()
    │
    ├─ roleService.selectRoleList(role)
    │      └─ SysRoleMapper.selectRoleList()
    │             └─ SQL実行（sys_role）
    │
    └─ ExcelUtil.exportExcel(list, sheetName)
           ├─ createExcelField() - @Excelアノテーション解析
           ├─ createWorkbook() - SXSSFWorkbook生成
           └─ fillExcelData() - データ行生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysRoleController.export() ───▶ Excelファイル
(SysRole)    │                              (角色数据_{日時}.xlsx)
             ├─▶ ISysRoleService
             │      └─▶ SysRoleMapper
             │             └─▶ MySQL
             │
             └─▶ ExcelUtil
                    └─▶ Apache POI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysRoleController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java` | ソース | エントリーポイント、exportメソッド定義 |
| SysRole.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysRole.java` | ソース | ロールエンティティ、@Excelアノテーション定義 |
| ISysRoleService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysRoleService.java` | ソース | サービスインターフェース |
| SysRoleMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysRoleMapper.xml` | 設定 | SQL定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel出力ユーティリティ |
