# 帳票設計書 3-岗位数据

## 概要

本ドキュメントは、RuoYiシステムにおけるポスト（役職）情報のExcelエクスポート機能に関する帳票設計書である。システム管理者がポスト管理画面からポスト情報をExcel形式で一括出力するための仕様を定義する。

### 本帳票の処理概要

本帳票は、システムに登録されているポスト（役職）情報をExcel形式でエクスポートする機能を提供する。

**業務上の目的・背景**：システム管理者がポスト情報を一覧で確認・管理するため、または組織体制の見直しや人事システムとのデータ連携のためにポスト情報を出力する必要がある。Excelファイルとして出力することで、組織構造の分析や文書化が容易になり、人事管理の効率化に寄与する。

**帳票の利用シーン**：ポスト管理画面において、検索条件を指定してポスト一覧を絞り込んだ後、「エクスポート」ボタンをクリックすることで、条件に合致するポスト情報をExcelファイルとしてダウンロードする。組織体制の棚卸し、人事システム連携、新規システム導入時の役職マスタ作成などで利用される。

**主要な出力内容**：
1. ポスト基本情報（ポストID、ポストコード、ポスト名）
2. 表示設定（表示順序）
3. ポスト状態情報（状態）

**帳票の出力タイミング**：ポスト管理画面（/system/post）の一覧画面から「エクスポート」ボタンをクリックした時点で、現在の検索条件に基づいてデータを取得し、Excelファイルを生成してダウンロードする。

**帳票の利用者**：システム管理者、人事管理者

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| SYS-003 | ポスト管理 | /system/post | 「エクスポート」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | A4横相当（印刷時） |
| 向き | 横 |
| ファイル名 | 岗位数据_{yyyyMMddHHmmss}.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 岗位数据 |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、1行目にヘッダー行、2行目以降にデータ行が出力される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（項目名）          │
├─────────────────────────────────────┤
│         データ行1                    │
│         データ行2                    │
│         ...                         │
│         データ行N                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 岗位序号 | ポストID | sys_post.post_id | 数値 |
| 2 | 岗位编码 | ポストコード | sys_post.post_code | 文字列 |
| 3 | 岗位名称 | ポスト名 | sys_post.post_name | 文字列 |
| 4 | 岗位排序 | 表示順序 | sys_post.post_sort | 数値 |
| 5 | 状态 | ポスト状態 | sys_post.status | 変換表示 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 岗位序号 | ポストID | sys_post.post_id | 数値 | 15 |
| 2 | 岗位编码 | ポストコード | sys_post.post_code | 文字列 | 20 |
| 3 | 岗位名称 | ポスト名 | sys_post.post_name | 文字列 | 25 |
| 4 | 岗位排序 | 表示順序 | sys_post.post_sort | 数値 | 12 |
| 5 | 状态 | ポスト状態 | sys_post.status | 変換表示 | 12 |

### フッター部

本帳票にフッター部はない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ポストコード | 部分一致検索 | No |
| ポスト名 | 部分一致検索 | No |
| 状態 | 完全一致（0/1） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | post_sort | 昇順 |

### 改ページ条件

Excel出力のため、65536行を超える場合は新しいシートを作成

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sys_post | ポスト基本情報 | メインテーブル |

### テーブル別参照項目詳細

#### sys_post

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| post_id | 岗位序号 | - | - |
| post_code | 岗位编码 | - | - |
| post_name | 岗位名称 | - | - |
| post_sort | 岗位排序 | - | - |
| status | 状态 | - | 0=正常,1=停用に変換 |

## 計算仕様

### 計算項目一覧

本帳票に計算項目はない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートボタン押下] --> B[権限チェック]
    B --> C{system:post:export権限あり?}
    C -->|No| D[権限エラー]
    C -->|Yes| E[検索条件取得]
    E --> F[postService.selectPostList呼出]
    F --> G[データ取得]
    G --> H[ExcelUtil初期化]
    H --> I[@Excelアノテーション解析]
    I --> J[ヘッダー行生成]
    J --> K[データ行生成]
    K --> L[値変換処理]
    L --> M[Excelファイル生成]
    M --> N[ファイルダウンロード]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | system:post:export権限がない場合 | 権限がありません | 管理者に権限付与を依頼 |
| データなし | 検索条件に該当するデータがない場合 | 空のExcelファイルが出力される | 検索条件を見直す |
| システムエラー | Excel生成時にエラーが発生した場合 | エクスポートに失敗しました | システム管理者に連絡 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 50件 |
| 目標出力時間 | 2秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- system:post:export権限を持つユーザーのみエクスポート可能
- 操作ログに「岗位管理」「EXPORT」として記録される

## 備考

- @Excelアノテーションにより出力項目を定義
- readConverterExp属性により状態の変換を実現
- ポストはユーザーに紐付けられる役職マスタ

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | @Excelアノテーションの定義、フィールド構成 |

**読解のコツ**: @Excelアノテーションのname属性がヘッダー名、cellTypeでNUMERICを指定している項目は数値として出力

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | exportメソッド（54-63行目）、権限チェック、ExcelUtil呼び出し |

**主要処理フロー**:
1. **54-55行**: @Log、@RequiresPermissionsで操作ログと権限制御
2. **60行**: postService.selectPostList(post)でデータ取得
3. **61行**: ExcelUtil<SysPost>インスタンス生成
4. **62行**: exportExcel(list, "岗位数据")でExcel出力

### プログラム呼び出し階層図

```
SysPostController.export()
    │
    ├─ postService.selectPostList(post)
    │      └─ SysPostMapper.selectPostList()
    │             └─ SQL実行（sys_post）
    │
    └─ ExcelUtil.exportExcel(list, sheetName)
           ├─ createExcelField() - @Excelアノテーション解析
           ├─ createWorkbook() - SXSSFWorkbook生成
           └─ fillExcelData() - データ行生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysPostController.export() ───▶ Excelファイル
(SysPost)    │                              (岗位数据_{日時}.xlsx)
             ├─▶ ISysPostService
             │      └─▶ SysPostMapper
             │             └─▶ MySQL
             │
             └─▶ ExcelUtil
                    └─▶ Apache POI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysPostController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java` | ソース | エントリーポイント、exportメソッド定義 |
| SysPost.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysPost.java` | ソース | ポストエンティティ、@Excelアノテーション定義 |
| ISysPostService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysPostService.java` | ソース | サービスインターフェース |
| SysPostMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysPostMapper.xml` | 設定 | SQL定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel出力ユーティリティ |
