# 帳票設計書 6-参数数据

## 概要

本ドキュメントは、RuoYiシステムにおけるシステムパラメータ設定のExcelエクスポート機能に関する帳票設計書である。システム管理者がパラメータ設定画面からパラメータ情報をExcel形式で一括出力するための仕様を定義する。

### 本帳票の処理概要

本帳票は、システムに登録されているパラメータ設定情報をExcel形式でエクスポートする機能を提供する。

**業務上の目的・背景**：システム管理者がパラメータ設定を一覧で確認・管理するため、またはシステム設定の変更履歴管理や環境間のパラメータ比較のためにパラメータ情報を出力する必要がある。Excelファイルとして出力することで、設定値の分析や文書化が容易になり、システム運用・保守の効率化に寄与する。

**帳票の利用シーン**：パラメータ設定画面において、検索条件を指定してパラメータ一覧を絞り込んだ後、「エクスポート」ボタンをクリックすることで、条件に合致するパラメータ情報をExcelファイルとしてダウンロードする。システム設定の棚卸し、環境移行時のパラメータ確認、設定変更前後の比較などで利用される。

**主要な出力内容**：
1. パラメータ基本情報（パラメータID、パラメータ名、パラメータキー、パラメータ値）
2. システム組込み情報（システム組込みフラグ）

**帳票の出力タイミング**：パラメータ設定画面（/system/config）の一覧画面から「エクスポート」ボタンをクリックした時点で、現在の検索条件に基づいてデータを取得し、Excelファイルを生成してダウンロードする。

**帳票の利用者**：システム管理者、運用担当者

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| SYS-006 | パラメータ設定 | /system/config | 「エクスポート」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | A4横相当（印刷時） |
| 向き | 横 |
| ファイル名 | 参数数据_{yyyyMMddHHmmss}.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 参数数据 |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、1行目にヘッダー行、2行目以降にデータ行が出力される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（項目名）          │
├─────────────────────────────────────┤
│         データ行1                    │
│         データ行2                    │
│         ...                         │
│         データ行N                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 参数主键 | パラメータID | sys_config.config_id | 数値 |
| 2 | 参数名称 | パラメータ名 | sys_config.config_name | 文字列 |
| 3 | 参数键名 | パラメータキー | sys_config.config_key | 文字列 |
| 4 | 参数键值 | パラメータ値 | sys_config.config_value | 文字列 |
| 5 | 系统内置 | システム組込み | sys_config.config_type | 変換表示 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 参数主键 | パラメータID | sys_config.config_id | 数値 | 15 |
| 2 | 参数名称 | パラメータ名 | sys_config.config_name | 文字列 | 30 |
| 3 | 参数键名 | パラメータキー | sys_config.config_key | 文字列 | 35 |
| 4 | 参数键值 | パラメータ値 | sys_config.config_value | 文字列 | 30 |
| 5 | 系统内置 | システム組込み | sys_config.config_type | 変換表示 | 12 |

### フッター部

本帳票にフッター部はない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パラメータ名 | 部分一致検索 | No |
| パラメータキー | 部分一致検索 | No |
| システム組込み | 完全一致（Y/N） | No |
| 作成日From | 範囲検索 | No |
| 作成日To | 範囲検索 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | config_id | 昇順 |

### 改ページ条件

Excel出力のため、65536行を超える場合は新しいシートを作成

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sys_config | パラメータ設定基本情報 | メインテーブル |

### テーブル別参照項目詳細

#### sys_config

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| config_id | 参数主键 | - | - |
| config_name | 参数名称 | - | - |
| config_key | 参数键名 | - | - |
| config_value | 参数键值 | - | - |
| config_type | 系统内置 | - | Y=是,N=否に変換 |

## 計算仕様

### 計算項目一覧

本帳票に計算項目はない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートボタン押下] --> B[権限チェック]
    B --> C{system:config:export権限あり?}
    C -->|No| D[権限エラー]
    C -->|Yes| E[検索条件取得]
    E --> F[configService.selectConfigList呼出]
    F --> G[データ取得]
    G --> H[ExcelUtil初期化]
    H --> I[@Excelアノテーション解析]
    I --> J[ヘッダー行生成]
    J --> K[データ行生成]
    K --> L[値変換処理]
    L --> M[Excelファイル生成]
    M --> N[ファイルダウンロード]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | system:config:export権限がない場合 | 権限がありません | 管理者に権限付与を依頼 |
| データなし | 検索条件に該当するデータがない場合 | 空のExcelファイルが出力される | 検索条件を見直す |
| システムエラー | Excel生成時にエラーが発生した場合 | エクスポートに失敗しました | システム管理者に連絡 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 50件 |
| 目標出力時間 | 2秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- system:config:export権限を持つユーザーのみエクスポート可能
- 操作ログに「参数管理」「EXPORT」として記録される
- パラメータ値に機密情報が含まれる可能性があるため、出力ファイルの取り扱いに注意

## 備考

- @Excelアノテーションにより出力項目を定義
- readConverterExp属性によりシステム組込みフラグの変換を実現
- パラメータはシステム全体の設定値を管理

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | @Excelアノテーションの定義、フィールド構成、config_typeの変換ルール |

**読解のコツ**: @Excelアノテーションのname属性がヘッダー名、config_typeはY/Nのフラグでシステム組込みかどうかを示す

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | exportメソッド（57-66行目）、権限チェック、ExcelUtil呼び出し |

**主要処理フロー**:
1. **57-58行**: @Log、@RequiresPermissionsで操作ログと権限制御
2. **63行**: configService.selectConfigList(config)でデータ取得
3. **64行**: ExcelUtil<SysConfig>インスタンス生成
4. **65行**: exportExcel(list, "参数数据")でExcel出力

### プログラム呼び出し階層図

```
SysConfigController.export()
    │
    ├─ configService.selectConfigList(config)
    │      └─ SysConfigMapper.selectConfigList()
    │             └─ SQL実行（sys_config）
    │
    └─ ExcelUtil.exportExcel(list, sheetName)
           ├─ createExcelField() - @Excelアノテーション解析
           ├─ createWorkbook() - SXSSFWorkbook生成
           └─ fillExcelData() - データ行生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysConfigController.export() ───▶ Excelファイル
(SysConfig)  │                              (参数数据_{日時}.xlsx)
             ├─▶ ISysConfigService
             │      └─▶ SysConfigMapper
             │             └─▶ MySQL
             │
             └─▶ ExcelUtil
                    └─▶ Apache POI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysConfigController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java` | ソース | エントリーポイント、exportメソッド定義 |
| SysConfig.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysConfig.java` | ソース | パラメータエンティティ、@Excelアノテーション定義 |
| ISysConfigService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysConfigService.java` | ソース | サービスインターフェース |
| SysConfigMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysConfigMapper.xml` | 設定 | SQL定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel出力ユーティリティ |
