# 帳票設計書 7-操作日志

## 概要

本ドキュメントは、RuoYiシステムにおける操作ログ情報のExcelエクスポート機能に関する帳票設計書である。システム管理者が操作ログ管理画面から操作ログ情報をExcel形式で一括出力するための仕様を定義する。

### 本帳票の処理概要

本帳票は、システムで記録された操作ログ情報をExcel形式でエクスポートする機能を提供する。

**業務上の目的・背景**：システム管理者がユーザーの操作履歴を一覧で確認・分析するため、またはセキュリティ監査や問題調査のために操作ログを出力する必要がある。Excelファイルとして出力することで、操作履歴の分析や報告書作成が容易になり、セキュリティ管理・監査対応の効率化に寄与する。

**帳票の利用シーン**：操作ログ管理画面において、検索条件を指定して操作ログ一覧を絞り込んだ後、「エクスポート」ボタンをクリックすることで、条件に合致する操作ログ情報をExcelファイルとしてダウンロードする。セキュリティ監査対応、問題発生時の調査、操作履歴の定期的なバックアップなどで利用される。

**主要な出力内容**：
1. 操作基本情報（操作ID、操作モジュール、業務タイプ）
2. リクエスト情報（リクエストメソッド、リクエスト方式、リクエストURL、リクエストパラメータ）
3. オペレーター情報（オペレーター、部門名、操作IP、操作地点）
4. 結果情報（状態、エラーメッセージ、操作時間、消耗時間）

**帳票の出力タイミング**：操作ログ管理画面（/monitor/operlog）の一覧画面から「エクスポート」ボタンをクリックした時点で、現在の検索条件に基づいてデータを取得し、Excelファイルを生成してダウンロードする。

**帳票の利用者**：システム管理者、セキュリティ管理者、監査担当者

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| MON-001 | 操作ログ管理 | /monitor/operlog | 「エクスポート」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | A4横相当（印刷時） |
| 向き | 横 |
| ファイル名 | 操作日志_{yyyyMMddHHmmss}.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 操作日志 |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、1行目にヘッダー行、2行目以降にデータ行が出力される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（項目名）          │
├─────────────────────────────────────┤
│         データ行1                    │
│         データ行2                    │
│         ...                         │
│         データ行N                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 操作序号 | 操作ID | sys_oper_log.oper_id | 数値 |
| 2 | 操作模块 | 操作モジュール | sys_oper_log.title | 文字列 |
| 3 | 业务类型 | 業務タイプ | sys_oper_log.business_type | 変換表示 |
| 4 | 请求方法 | リクエストメソッド | sys_oper_log.method | 文字列 |
| 5 | 请求方式 | リクエスト方式 | sys_oper_log.request_method | 文字列 |
| 6 | 操作类别 | 操作類別 | sys_oper_log.operator_type | 変換表示 |
| 7 | 操作人员 | オペレーター | sys_oper_log.oper_name | 文字列 |
| 8 | 部门名称 | 部門名 | sys_oper_log.dept_name | 文字列 |
| 9 | 请求地址 | リクエストURL | sys_oper_log.oper_url | 文字列 |
| 10 | 操作地址 | 操作IP | sys_oper_log.oper_ip | 文字列 |
| 11 | 操作地点 | 操作地点 | sys_oper_log.oper_location | 文字列 |
| 12 | 请求参数 | リクエストパラメータ | sys_oper_log.oper_param | 文字列 |
| 13 | 返回参数 | レスポンス | sys_oper_log.json_result | 文字列 |
| 14 | 状态 | 状態 | sys_oper_log.status | 変換表示 |
| 15 | 错误消息 | エラーメッセージ | sys_oper_log.error_msg | 文字列 |
| 16 | 操作时间 | 操作時間 | sys_oper_log.oper_time | 日時 |
| 17 | 消耗时间 | 消耗時間 | sys_oper_log.cost_time | 数値（ミリ秒） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 操作序号 | 操作ID | sys_oper_log.oper_id | 数値 | 12 |
| 2 | 操作模块 | 操作モジュール | sys_oper_log.title | 文字列 | 20 |
| 3 | 业务类型 | 業務タイプ | sys_oper_log.business_type | 変換表示 | 12 |
| 4 | 请求方法 | リクエストメソッド | sys_oper_log.method | 文字列 | 40 |
| 5 | 请求方式 | リクエスト方式 | sys_oper_log.request_method | 文字列 | 10 |
| 6 | 操作类别 | 操作類別 | sys_oper_log.operator_type | 変換表示 | 12 |
| 7 | 操作人员 | オペレーター | sys_oper_log.oper_name | 文字列 | 15 |
| 8 | 部门名称 | 部門名 | sys_oper_log.dept_name | 文字列 | 15 |
| 9 | 请求地址 | リクエストURL | sys_oper_log.oper_url | 文字列 | 30 |
| 10 | 操作地址 | 操作IP | sys_oper_log.oper_ip | 文字列 | 15 |
| 11 | 操作地点 | 操作地点 | sys_oper_log.oper_location | 文字列 | 20 |
| 12 | 请求参数 | リクエストパラメータ | sys_oper_log.oper_param | 文字列 | 50 |
| 13 | 返回参数 | レスポンス | sys_oper_log.json_result | 文字列 | 50 |
| 14 | 状态 | 状態 | sys_oper_log.status | 変換表示 | 10 |
| 15 | 错误消息 | エラーメッセージ | sys_oper_log.error_msg | 文字列 | 30 |
| 16 | 操作时间 | 操作時間 | sys_oper_log.oper_time | 日時 | 25 |
| 17 | 消耗时间 | 消耗時間 | sys_oper_log.cost_time | 数値（ミリ秒） | 15 |

### フッター部

本帳票にフッター部はない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 操作モジュール | 部分一致検索 | No |
| オペレーター | 部分一致検索 | No |
| 業務タイプ | 完全一致（0-9） | No |
| 状態 | 完全一致（0/1） | No |
| 操作時間From | 範囲検索 | No |
| 操作時間To | 範囲検索 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | oper_time | 降順 |

### 改ページ条件

Excel出力のため、65536行を超える場合は新しいシートを作成

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sys_oper_log | 操作ログ基本情報 | メインテーブル |

### テーブル別参照項目詳細

#### sys_oper_log

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| oper_id | 操作序号 | - | - |
| title | 操作模块 | - | - |
| business_type | 业务类型 | - | 0=其它,1=新增,2=修改,3=删除,4=授权,5=导出,6=导入,7=强退,8=生成代码,9=清空数据に変換 |
| method | 请求方法 | - | - |
| request_method | 请求方式 | - | - |
| operator_type | 操作类别 | - | 0=其它,1=后台用户,2=手机端用户に変換 |
| oper_name | 操作人员 | - | - |
| dept_name | 部门名称 | - | - |
| oper_url | 请求地址 | - | - |
| oper_ip | 操作地址 | - | - |
| oper_location | 操作地点 | - | - |
| oper_param | 请求参数 | - | - |
| json_result | 返回参数 | - | - |
| status | 状态 | - | 0=正常,1=异常に変換 |
| error_msg | 错误消息 | - | - |
| oper_time | 操作时间 | - | yyyy-MM-dd HH:mm:ss形式 |
| cost_time | 消耗时间 | - | ミリ秒単位 |

## 計算仕様

### 計算項目一覧

本帳票に計算項目はない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートボタン押下] --> B[権限チェック]
    B --> C{monitor:operlog:export権限あり?}
    C -->|No| D[権限エラー]
    C -->|Yes| E[検索条件取得]
    E --> F[operLogService.selectOperLogList呼出]
    F --> G[データ取得]
    G --> H[ExcelUtil初期化]
    H --> I[@Excelアノテーション解析]
    I --> J[ヘッダー行生成]
    J --> K[データ行生成]
    K --> L[値変換処理]
    L --> M[Excelファイル生成]
    M --> N[ファイルダウンロード]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | monitor:operlog:export権限がない場合 | 権限がありません | 管理者に権限付与を依頼 |
| データなし | 検索条件に該当するデータがない場合 | 空のExcelファイルが出力される | 検索条件を見直す |
| システムエラー | Excel生成時にエラーが発生した場合 | エクスポートに失敗しました | システム管理者に連絡 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 10000件 |
| 目標出力時間 | 10秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- monitor:operlog:export権限を持つユーザーのみエクスポート可能
- 操作ログに「操作日志」「EXPORT」として記録される
- リクエストパラメータやレスポンスに機密情報が含まれる可能性があるため、出力ファイルの取り扱いに注意

## 備考

- @Excelアノテーションにより出力項目を定義
- readConverterExp属性により業務タイプ、操作類別、状態の変換を実現
- 操作ログは@Logアノテーションにより自動記録される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysOperLog.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` | @Excelアノテーションの定義、business_typeとoperator_typeの変換ルール |

**読解のコツ**: @ExcelアノテーションのreadConverterExpで多数の業務タイプ（10種類）と操作類別（3種類）の変換が定義されている

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysOperlogController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` | exportメソッド（53-62行目）、権限チェック、ExcelUtil呼び出し |

**主要処理フロー**:
1. **53-54行**: @Log、@RequiresPermissionsで操作ログと権限制御
2. **59行**: operLogService.selectOperLogList(operLog)でデータ取得
3. **60行**: ExcelUtil<SysOperLog>インスタンス生成
4. **61行**: exportExcel(list, "操作日志")でExcel出力

### プログラム呼び出し階層図

```
SysOperlogController.export()
    │
    ├─ operLogService.selectOperLogList(operLog)
    │      └─ SysOperLogMapper.selectOperLogList()
    │             └─ SQL実行（sys_oper_log）
    │
    └─ ExcelUtil.exportExcel(list, sheetName)
           ├─ createExcelField() - @Excelアノテーション解析
           ├─ createWorkbook() - SXSSFWorkbook生成
           └─ fillExcelData() - データ行生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysOperlogController.export() ───▶ Excelファイル
(SysOperLog) │                              (操作日志_{日時}.xlsx)
             ├─▶ ISysOperLogService
             │      └─▶ SysOperLogMapper
             │             └─▶ MySQL
             │
             └─▶ ExcelUtil
                    └─▶ Apache POI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysOperlogController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java` | ソース | エントリーポイント、exportメソッド定義 |
| SysOperLog.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` | ソース | 操作ログエンティティ、@Excelアノテーション定義 |
| ISysOperLogService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysOperLogService.java` | ソース | サービスインターフェース |
| SysOperLogMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysOperLogMapper.xml` | 設定 | SQL定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel出力ユーティリティ |
