# 帳票設計書 8-登录日志

## 概要

本ドキュメントは、RuoYiシステムにおけるログイン情報のExcelエクスポート機能に関する帳票設計書である。システム管理者がログインログ管理画面からログイン情報をExcel形式で一括出力するための仕様を定義する。

### 本帳票の処理概要

本帳票は、システムで記録されたログイン情報をExcel形式でエクスポートする機能を提供する。

**業務上の目的・背景**：システム管理者がユーザーのログイン履歴を一覧で確認・分析するため、またはセキュリティ監査や不正アクセス調査のためにログイン情報を出力する必要がある。Excelファイルとして出力することで、ログイン履歴の分析や報告書作成が容易になり、セキュリティ管理・監査対応の効率化に寄与する。

**帳票の利用シーン**：ログインログ管理画面において、検索条件を指定してログインログ一覧を絞り込んだ後、「エクスポート」ボタンをクリックすることで、条件に合致するログイン情報をExcelファイルとしてダウンロードする。セキュリティ監査対応、不正アクセス調査、ログイン履歴の定期的なバックアップなどで利用される。

**主要な出力内容**：
1. アクセス情報（アクセスID、ユーザーアカウント）
2. 接続情報（ログイン状態、IPアドレス、ログイン地点）
3. クライアント情報（ブラウザ、OS）
4. 結果情報（提示メッセージ、アクセス時間）

**帳票の出力タイミング**：ログインログ管理画面（/monitor/logininfor）の一覧画面から「エクスポート」ボタンをクリックした時点で、現在の検索条件に基づいてデータを取得し、Excelファイルを生成してダウンロードする。

**帳票の利用者**：システム管理者、セキュリティ管理者、監査担当者

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| MON-002 | ログインログ管理 | /monitor/logininfor | 「エクスポート」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | A4横相当（印刷時） |
| 向き | 横 |
| ファイル名 | 登录日志_{yyyyMMddHHmmss}.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 登录日志 |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、1行目にヘッダー行、2行目以降にデータ行が出力される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（項目名）          │
├─────────────────────────────────────┤
│         データ行1                    │
│         データ行2                    │
│         ...                         │
│         データ行N                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 序号 | アクセスID | sys_logininfor.info_id | 数値 |
| 2 | 用户账号 | ユーザーアカウント | sys_logininfor.login_name | 文字列 |
| 3 | 登录状态 | ログイン状態 | sys_logininfor.status | 変換表示 |
| 4 | 登录地址 | IPアドレス | sys_logininfor.ipaddr | 文字列 |
| 5 | 登录地点 | ログイン地点 | sys_logininfor.login_location | 文字列 |
| 6 | 浏览器 | ブラウザ | sys_logininfor.browser | 文字列 |
| 7 | 操作系统 | OS | sys_logininfor.os | 文字列 |
| 8 | 提示消息 | 提示メッセージ | sys_logininfor.msg | 文字列 |
| 9 | 访问时间 | アクセス時間 | sys_logininfor.login_time | 日時 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 序号 | アクセスID | sys_logininfor.info_id | 数値 | 12 |
| 2 | 用户账号 | ユーザーアカウント | sys_logininfor.login_name | 文字列 | 20 |
| 3 | 登录状态 | ログイン状態 | sys_logininfor.status | 変換表示 | 12 |
| 4 | 登录地址 | IPアドレス | sys_logininfor.ipaddr | 文字列 | 20 |
| 5 | 登录地点 | ログイン地点 | sys_logininfor.login_location | 文字列 | 25 |
| 6 | 浏览器 | ブラウザ | sys_logininfor.browser | 文字列 | 25 |
| 7 | 操作系统 | OS | sys_logininfor.os | 文字列 | 20 |
| 8 | 提示消息 | 提示メッセージ | sys_logininfor.msg | 文字列 | 30 |
| 9 | 访问时间 | アクセス時間 | sys_logininfor.login_time | 日時 | 25 |

### フッター部

本帳票にフッター部はない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ユーザーアカウント | 部分一致検索 | No |
| IPアドレス | 部分一致検索 | No |
| ログイン状態 | 完全一致（0/1） | No |
| アクセス時間From | 範囲検索 | No |
| アクセス時間To | 範囲検索 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | login_time | 降順 |

### 改ページ条件

Excel出力のため、65536行を超える場合は新しいシートを作成

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sys_logininfor | ログイン情報基本情報 | メインテーブル |

### テーブル別参照項目詳細

#### sys_logininfor

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| info_id | 序号 | - | - |
| login_name | 用户账号 | - | - |
| status | 登录状态 | - | 0=成功,1=失败に変換 |
| ipaddr | 登录地址 | - | - |
| login_location | 登录地点 | - | - |
| browser | 浏览器 | - | - |
| os | 操作系统 | - | - |
| msg | 提示消息 | - | - |
| login_time | 访问时间 | - | yyyy-MM-dd HH:mm:ss形式 |

## 計算仕様

### 計算項目一覧

本帳票に計算項目はない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートボタン押下] --> B[権限チェック]
    B --> C{monitor:logininfor:export権限あり?}
    C -->|No| D[権限エラー]
    C -->|Yes| E[検索条件取得]
    E --> F[logininforService.selectLogininforList呼出]
    F --> G[データ取得]
    G --> H[ExcelUtil初期化]
    H --> I[@Excelアノテーション解析]
    I --> J[ヘッダー行生成]
    J --> K[データ行生成]
    K --> L[値変換処理]
    L --> M[Excelファイル生成]
    M --> N[ファイルダウンロード]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | monitor:logininfor:export権限がない場合 | 権限がありません | 管理者に権限付与を依頼 |
| データなし | 検索条件に該当するデータがない場合 | 空のExcelファイルが出力される | 検索条件を見直す |
| システムエラー | Excel生成時にエラーが発生した場合 | エクスポートに失敗しました | システム管理者に連絡 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 10000件 |
| 目標出力時間 | 10秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- monitor:logininfor:export権限を持つユーザーのみエクスポート可能
- 操作ログに「登录日志」「EXPORT」として記録される
- ログイン失敗情報には攻撃パターンが含まれる可能性があるため、出力ファイルの取り扱いに注意

## 備考

- @Excelアノテーションにより出力項目を定義
- readConverterExp属性によりログイン状態の変換を実現
- ログイン情報はシステムへのアクセス時に自動記録される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | @Excelアノテーションの定義、statusの変換ルール |

**読解のコツ**: @ExcelアノテーションのreadConverterExpでログイン状態（成功/失敗）の変換が定義されている

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysLogininforController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java` | exportメソッド（55-64行目）、権限チェック、ExcelUtil呼び出し |

**主要処理フロー**:
1. **55-56行**: @Log、@RequiresPermissionsで操作ログと権限制御
2. **61行**: logininforService.selectLogininforList(logininfor)でデータ取得
3. **62行**: ExcelUtil<SysLogininfor>インスタンス生成
4. **63行**: exportExcel(list, "登录日志")でExcel出力

### プログラム呼び出し階層図

```
SysLogininforController.export()
    │
    ├─ logininforService.selectLogininforList(logininfor)
    │      └─ SysLogininforMapper.selectLogininforList()
    │             └─ SQL実行（sys_logininfor）
    │
    └─ ExcelUtil.exportExcel(list, sheetName)
           ├─ createExcelField() - @Excelアノテーション解析
           ├─ createWorkbook() - SXSSFWorkbook生成
           └─ fillExcelData() - データ行生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysLogininforController.export() ───▶ Excelファイル
(SysLogininfor)│                              (登录日志_{日時}.xlsx)
             ├─▶ ISysLogininforService
             │      └─▶ SysLogininforMapper
             │             └─▶ MySQL
             │
             └─▶ ExcelUtil
                    └─▶ Apache POI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysLogininforController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysLogininforController.java` | ソース | エントリーポイント、exportメソッド定義 |
| SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ソース | ログイン情報エンティティ、@Excelアノテーション定義 |
| ISysLogininforService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysLogininforService.java` | ソース | サービスインターフェース |
| SysLogininforMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysLogininforMapper.xml` | 設定 | SQL定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel出力ユーティリティ |
