# 帳票設計書 9-定时任务

## 概要

本ドキュメントは、RuoYiシステムにおけるスケジュールタスク情報のExcelエクスポート機能に関する帳票設計書である。システム管理者がスケジュールタスク管理画面からタスク情報をExcel形式で一括出力するための仕様を定義する。

### 本帳票の処理概要

本帳票は、システムに登録されているスケジュールタスク（定時処理）情報をExcel形式でエクスポートする機能を提供する。

**業務上の目的・背景**：システム管理者がスケジュールタスク設定を一覧で確認・管理するため、またはタスク設計書作成や環境間のタスク設定比較のためにスケジュールタスク情報を出力する必要がある。Excelファイルとして出力することで、タスク設定の分析や文書化が容易になり、システム運用・保守の効率化に寄与する。

**帳票の利用シーン**：スケジュールタスク管理画面において、検索条件を指定してタスク一覧を絞り込んだ後、「エクスポート」ボタンをクリックすることで、条件に合致するスケジュールタスク情報をExcelファイルとしてダウンロードする。タスク設定の棚卸し、環境移行時のタスク確認、定期処理の設計書作成などで利用される。

**主要な出力内容**：
1. タスク基本情報（タスクID、タスク名、タスクグループ）
2. 実行設定（呼出対象、cron式）
3. 実行制御情報（計画策略、並行実行、タスク状態）

**帳票の出力タイミング**：スケジュールタスク管理画面（/monitor/job）の一覧画面から「エクスポート」ボタンをクリックした時点で、現在の検索条件に基づいてデータを取得し、Excelファイルを生成してダウンロードする。

**帳票の利用者**：システム管理者、運用担当者

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| MON-003 | スケジュールタスク管理 | /monitor/job | 「エクスポート」ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel (.xlsx) |
| 用紙サイズ | A4横相当（印刷時） |
| 向き | 横 |
| ファイル名 | 定时任务_{yyyyMMddHHmmss}.xlsx |
| 出力方法 | ダウンロード |
| 文字コード | UTF-8 |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | 定时任务 |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

Excelファイルは単一シートで構成され、1行目にヘッダー行、2行目以降にデータ行が出力される。

```
┌─────────────────────────────────────┐
│         ヘッダー行（項目名）          │
├─────────────────────────────────────┤
│         データ行1                    │
│         データ行2                    │
│         ...                         │
│         データ行N                    │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 任务序号 | タスクID | sys_job.job_id | 数値 |
| 2 | 任务名称 | タスク名 | sys_job.job_name | 文字列 |
| 3 | 任务组名 | タスクグループ | sys_job.job_group | 文字列 |
| 4 | 调用目标字符串 | 呼出対象 | sys_job.invoke_target | 文字列 |
| 5 | 执行表达式 | cron式 | sys_job.cron_expression | 文字列 |
| 6 | 计划策略 | 計画策略 | sys_job.misfire_policy | 変換表示 |
| 7 | 并发执行 | 並行実行 | sys_job.concurrent | 変換表示 |
| 8 | 任务状态 | タスク状態 | sys_job.status | 変換表示 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 任务序号 | タスクID | sys_job.job_id | 数値 | 12 |
| 2 | 任务名称 | タスク名 | sys_job.job_name | 文字列 | 20 |
| 3 | 任务组名 | タスクグループ | sys_job.job_group | 文字列 | 15 |
| 4 | 调用目标字符串 | 呼出対象 | sys_job.invoke_target | 文字列 | 50 |
| 5 | 执行表达式 | cron式 | sys_job.cron_expression | 文字列 | 20 |
| 6 | 计划策略 | 計画策略 | sys_job.misfire_policy | 変換表示 | 18 |
| 7 | 并发执行 | 並行実行 | sys_job.concurrent | 変換表示 | 10 |
| 8 | 任务状态 | タスク状態 | sys_job.status | 変換表示 | 10 |

### フッター部

本帳票にフッター部はない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| タスク名 | 部分一致検索 | No |
| タスクグループ | 完全一致検索 | No |
| タスク状態 | 完全一致（0/1） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | job_id | 昇順 |

### 改ページ条件

Excel出力のため、65536行を超える場合は新しいシートを作成

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| sys_job | スケジュールタスク基本情報 | メインテーブル |

### テーブル別参照項目詳細

#### sys_job

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| job_id | 任务序号 | - | - |
| job_name | 任务名称 | - | - |
| job_group | 任务组名 | - | - |
| invoke_target | 调用目标字符串 | - | - |
| cron_expression | 执行表达式 | - | - |
| misfire_policy | 计划策略 | - | 0=默认,1=立即触发执行,2=触发一次执行,3=不触发立即执行に変換 |
| concurrent | 并发执行 | - | 0=允许,1=禁止に変換 |
| status | 任务状态 | - | 0=正常,1=暂停に変換 |

## 計算仕様

### 計算項目一覧

本帳票に計算項目はない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートボタン押下] --> B[権限チェック]
    B --> C{monitor:job:export権限あり?}
    C -->|No| D[権限エラー]
    C -->|Yes| E[検索条件取得]
    E --> F[jobService.selectJobList呼出]
    F --> G[データ取得]
    G --> H[ExcelUtil初期化]
    H --> I[@Excelアノテーション解析]
    I --> J[ヘッダー行生成]
    J --> K[データ行生成]
    K --> L[値変換処理]
    L --> M[Excelファイル生成]
    M --> N[ファイルダウンロード]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限エラー | monitor:job:export権限がない場合 | 権限がありません | 管理者に権限付与を依頼 |
| データなし | 検索条件に該当するデータがない場合 | 空のExcelファイルが出力される | 検索条件を見直す |
| システムエラー | Excel生成時にエラーが発生した場合 | エクスポートに失敗しました | システム管理者に連絡 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 100件 |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- monitor:job:export権限を持つユーザーのみエクスポート可能
- 操作ログに「定时任务」「EXPORT」として記録される
- 呼出対象にはメソッド名やパラメータが含まれる可能性があるため、出力ファイルの取り扱いに注意

## 備考

- @Excelアノテーションにより出力項目を定義
- readConverterExp属性により計画策略、並行実行、タスク状態の変換を実現
- スケジュールタスクはQuartzフレームワークにより管理される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エクスポート対象のデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` | @Excelアノテーションの定義、misfire_policy/concurrent/statusの変換ルール |

**読解のコツ**: @ExcelアノテーションのreadConverterExpで計画策略（4種類）、並行実行（2種類）、タスク状態（2種類）の変換が定義されている

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | exportメソッド（61-70行目）、権限チェック、ExcelUtil呼び出し |

**主要処理フロー**:
1. **61-62行**: @Log、@RequiresPermissionsで操作ログと権限制御
2. **67行**: jobService.selectJobList(job)でデータ取得
3. **68行**: ExcelUtil<SysJob>インスタンス生成
4. **69行**: exportExcel(list, "定时任务")でExcel出力

### プログラム呼び出し階層図

```
SysJobController.export()
    │
    ├─ jobService.selectJobList(job)
    │      └─ SysJobMapper.selectJobList()
    │             └─ SQL実行（sys_job）
    │
    └─ ExcelUtil.exportExcel(list, sheetName)
           ├─ createExcelField() - @Excelアノテーション解析
           ├─ createWorkbook() - SXSSFWorkbook生成
           └─ fillExcelData() - データ行生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件 ───▶ SysJobController.export() ───▶ Excelファイル
(SysJob)     │                              (定时任务_{日時}.xlsx)
             ├─▶ ISysJobService
             │      └─▶ SysJobMapper
             │             └─▶ MySQL
             │
             └─▶ ExcelUtil
                    └─▶ Apache POI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysJobController.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java` | ソース | エントリーポイント、exportメソッド定義 |
| SysJob.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJob.java` | ソース | スケジュールタスクエンティティ、@Excelアノテーション定義 |
| ISysJobService.java | `ruoyi-quartz/src/main/java/com/ruoyi/quartz/service/ISysJobService.java` | ソース | サービスインターフェース |
| SysJobMapper.xml | `ruoyi-quartz/src/main/resources/mapper/quartz/SysJobMapper.xml` | 設定 | SQL定義 |
| ExcelUtil.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` | ソース | Excel出力ユーティリティ |
