---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-用户数据.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（想定データ件数・出力時間）**：具体的な要件定義書なし
  2. **ファイル名命名規則の日時フォーマット**：実装コードでの詳細確認推奨
  3. **同時出力数上限**：システム設定ファイルでの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` (81-90行目)
- E-02: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/entity/SysUser.java` (@Excelアノテーション定義)
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/utils/poi/ExcelUtil.java` (exportExcelメソッド)
- E-04: `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` (selectUserList SQL)
- E-05: `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Excel.java` (アノテーション定義)
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` (帳票一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エクスポート機能はSysUserController.exportメソッドで実装 | E-01 | ○ |
| C-02 | 権限チェックはsystem:user:exportで行われる | E-01 (82行目) | ○ |
| C-03 | @Logアノテーションで操作ログを記録 | E-01 (81行目) | ○ |
| C-04 | userService.selectUserListでデータ取得 | E-01 (87行目) | ○ |
| C-05 | ExcelUtil<SysUser>でExcel出力を実行 | E-01 (88-89行目) | ○ |
| C-06 | シート名は「用户数据」 | E-01 (89行目) | ○ |
| C-07 | user_idは「用户序号」として出力 | E-02 (27行目) | ○ |
| C-08 | login_nameは「登录名称」として出力 | E-02 (41行目) | ○ |
| C-09 | user_nameは「用户名称」として出力 | E-02 (45行目) | ○ |
| C-10 | emailは「用户邮箱」として出力 | E-02 (52行目) | ○ |
| C-11 | phonenumberは「手机号码」として出力 | E-02 (56行目) | ○ |
| C-12 | sexは0=男,1=女,2=未知に変換される | E-02 (60行目) | ○ |
| C-13 | statusは0=正常,1=停用に変換される | E-02 (73行目) | ○ |
| C-14 | login_ipはEXPORT時のみ出力 | E-02 (80行目) | ○ |
| C-15 | login_dateはyyyy-MM-dd HH:mm:ss形式で出力 | E-02 (84行目) | ○ |
| C-16 | 部門名称と部門責任者は@Excelsで定義 | E-02 (91-94行目) | ○ |
| C-17 | パスワードはエクスポート対象外 | E-02 (238行目 @JsonIgnore) | ○ |
| C-18 | ソルトはエクスポート対象外 | E-02 (249行目 @JsonIgnore) | ○ |
| C-19 | Excel出力形式はxlsx | E-03 (SXSSFWorkbook使用) | ○ |
| C-20 | 最大シート行数は65536行 | E-03 (112行目) | ○ |
| C-21 | sys_userとsys_deptを結合して取得 | E-04 | ○ |
| C-22 | del_flag='0'で削除されていないユーザーを取得 | E-04 | ○ |
| C-23 | ファイル名形式は「用户数据_{日時}.xlsx」 | E-03 | ○ |
| C-24 | 出力方法はダウンロード | E-03 | ○ |
| C-25 | 想定データ件数は1000件、目標出力時間は5秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25のパフォーマンス要件については、明確な要件定義書やシステム設計書での規定が見つからなかった
  - 候補：非機能要件定義書 / システム設計書 / 性能テスト計画書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力項目とデータ型の定義（コードで明確に定義）
- 0: 低リスク - 権限制御の実装（アノテーションで明確）
- 1: 中リスク - パフォーマンス要件（要確認）
- 0: 低リスク - セキュリティ（パスワード除外が実装済み）

## 6) レビュアーチェックリスト（最小）
- [ ] @Excelアノテーションの出力項目がSysUser.javaの定義と一致しているか
- [ ] readConverterExpの変換ルールが正しいか
- [ ] 権限設定（system:user:export）が適切か
- [ ] パスワード等の機密情報が除外されているか
- [ ] パフォーマンス要件の妥当性を別途確認
